/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.preview.editor.Messages;

public class EngineDialog
extends MessageDialog {
    private boolean isRemember = false;
    private static boolean webkitIsUsed = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Use visual editor for html5 editing");
    private static String webkitOption = MessageFormat.format(VpeUIMessages.ENGINE_DIALOG_HTML5, webkitIsUsed ? VpeUIMessages.ENGINE_DIALOG_STAY_WITH : VpeUIMessages.ENGINE_DIALOG_CHANGE_TO);
    private static String xulrunnerOption = MessageFormat.format(VpeUIMessages.ENGINE_DIALOG_JSF, webkitIsUsed ? VpeUIMessages.ENGINE_DIALOG_CHANGE_TO : VpeUIMessages.ENGINE_DIALOG_STAY_WITH);
    public static final String PREFS_ID = "org.jboss.tools.vpe.editor";
    private Link link;

    public EngineDialog(Shell parentShell) {
        super(parentShell, VpeUIMessages.ENGINE_DIALOG_HEADER, null, "", 2, new String[]{webkitOption, xulrunnerOption}, webkitIsUsed ? 0 : 1);
        this.message = Messages.EngineDialog_MESSAGE;
    }

    protected Control createCustomArea(Composite parent) {
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        Button button = new Button(parent, 32);
        GridData gridData = new GridData(32);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EngineDialog.this.isRemember = !EngineDialog.this.isRemember;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EngineDialog.this.isRemember = !EngineDialog.this.isRemember;
            }
        });
        button.setText(VpeUIMessages.ENGINE_DIALOG_DO_NOT_SHOW_AGAIN);
        return parent;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.link = new Link(composite, this.getMessageLabelStyle());
            this.link.setText(this.message);
            this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn(null, (String)EngineDialog.PREFS_ID, (String[])new String[]{EngineDialog.PREFS_ID}, null).open();
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.link);
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        WebUiPlugin.getDefault().getPreferenceStore().setValue("Remember visual editor engine", this.isRemember);
        boolean useWebkit = false;
        if (buttonId == 0) {
            useWebkit = true;
        }
        if (buttonId == 1) {
            useWebkit = false;
        }
        if (useWebkit != webkitIsUsed) {
            WebUiPlugin.getDefault().getPreferenceStore().setValue("Use visual editor for html5 editing", useWebkit);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().restart();
                }
            });
        }
    }
}

