/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.foundation.ui.xpl.taskwizard.TaskWizardDialog;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.internal.discovery.DiscoveryUtil;
import org.jboss.tools.project.examples.internal.discovery.JBossDiscoveryUi;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;
import org.jboss.tools.project.examples.wizard.WizardContext;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.wizard.DownloadRuntimesTaskWizard;

public class NewProjectExamplesRequirementsPage
extends WizardPage
implements IProjectExamplesWizardPage {
    private static final String PAGE_NAME = "org.jboss.tools.project.examples.requirements";
    protected ProjectExampleWorkingCopy projectExample;
    protected Text descriptionText;
    protected Label projectSizeLabel;
    protected Text projectSize;
    protected WizardContext wizardContext;
    protected TableViewer tableViewer;
    protected List<ProjectFix> fixes = new ArrayList<ProjectFix>();
    protected ArrayList<ProjectFix> unsatisfiedFixes = new ArrayList();
    private Image checkboxOn;
    private Image checkboxOff;
    private Link link;
    private IServerLifecycleListener serverListener = new IServerLifecycleListener(){

        private void refreshInUIThread() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NewProjectExamplesRequirementsPage.this.refreshFixes();
                }
            });
        }

        public void serverAdded(IServer server) {
            this.refreshInUIThread();
        }

        public void serverChanged(IServer server) {
            this.refreshInUIThread();
        }

        public void serverRemoved(IServer server) {
            this.refreshInUIThread();
        }
    };

    public NewProjectExamplesRequirementsPage(ProjectExampleWorkingCopy projectExample) {
        this(PAGE_NAME, projectExample);
    }

    public NewProjectExamplesRequirementsPage(String pageName, ProjectExampleWorkingCopy projectExample) {
        super(pageName);
        this.projectExample = projectExample;
        this.setTitleAndDescription(projectExample);
        this.checkboxOn = RuntimeUIActivator.sharedImages().image("checkbox_on");
        this.checkboxOff = RuntimeUIActivator.sharedImages().image("checkbox_off");
    }

    public NewProjectExamplesRequirementsPage() {
        this(null);
    }

    protected void setTitleAndDescription(ProjectExample projectExample) {
        this.setTitle("Requirements");
        this.setDescription("Project Example Requirements");
        if (projectExample != null) {
            if (projectExample.getShortDescription() != null) {
                this.setTitle(projectExample.getShortDescription());
            }
            if (projectExample.getHeadLine() != null) {
                this.setDescription(ProjectExamplesActivator.getShortDescription(projectExample.getHeadLine()));
            }
            if (this.descriptionText != null) {
                if (projectExample.getDescription() != null) {
                    this.descriptionText.setText(projectExample.getDescription());
                }
                if (projectExample.getSizeAsText() != null && this.projectSize != null) {
                    this.projectSize.setText(projectExample.getSizeAsText());
                }
            }
        } else {
            this.setTitle("Requirements");
            this.setDescription("Project Example Requirements");
            if (this.descriptionText != null) {
                this.descriptionText.setText("");
                if (this.projectSize != null) {
                    this.projectSize.setText("");
                }
            }
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, false, false);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setDescriptionArea(composite);
        this.setSelectionArea(composite);
        Group fixesGroup = new Group(composite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        fixesGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        fixesGroup.setLayout((Layout)layout);
        fixesGroup.setText("Requirements");
        this.tableViewer = new TableViewer((Composite)fixesGroup, 68356);
        Table table = this.tableViewer.getTable();
        gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Type", "Description", "Found?"};
        int[] columnWidths = new int[]{100, 300, 50};
        int i = 0;
        while (i < columnNames.length) {
            TableViewerColumn tc = new TableViewerColumn(this.tableViewer, 16384);
            tc.getColumn().setText(columnNames[i]);
            tc.getColumn().setWidth(columnWidths[i]);
            tc.setLabelProvider((CellLabelProvider)new FixLabelProvider(i));
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)new FixContentProvider(this.fixes));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.createButtons((Composite)fixesGroup, this.tableViewer);
        this.link = new Link(composite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.link.setLayoutData((Object)gd);
        this.setAdditionalControls(composite);
        this.setPageComplete(true);
        this.setControl((Control)composite);
        if (this.projectExample != null) {
            this.setProjectExample(this.projectExample);
        }
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverListener);
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverListener);
        super.dispose();
    }

    protected void setDescriptionArea(Composite composite) {
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.NewProjectExamplesWizardPage_Description);
        GridData gd = new GridData(1, 4, false, false);
        gd.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = new Text(composite, 2888);
        gd = new GridData(4, 4, false, false);
        GC gc = new GC((Drawable)composite.getParent());
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)6);
        gc.dispose();
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.descriptionText.setLayoutData((Object)gd);
    }

    protected void setSelectionArea(Composite composite) {
        this.projectSizeLabel = new Label(composite, 0);
        this.projectSizeLabel.setText(Messages.NewProjectExamplesWizardPage_Project_size);
        this.projectSize = new Text(composite, 8);
        this.projectSize.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    protected void setAdditionalControls(Composite composite) {
    }

    private void createButtons(Composite parent, final TableViewer viewer) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        final Button install = new Button(buttonComposite, 8);
        install.setLayoutData((Object)new GridData(768));
        install.setText("Install...");
        install.setEnabled(false);
        install.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProjectFix fix = NewProjectExamplesRequirementsPage.this.getSelectedProjectFix();
                if ("wtpruntime".equals(fix.getType()) || "seam".equals(fix.getType())) {
                    String preferenceId = "org.jboss.tools.runtime.preferences.RuntimePreferencePage";
                    PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)NewProjectExamplesRequirementsPage.this.getShell(), (String)preferenceId, null, null);
                    preferenceDialog.open();
                    NewProjectExamplesRequirementsPage.this.refreshFixes();
                } else if ("plugin".equals(fix.getType())) {
                    String connectorId = fix.getProperties().get(ProjectFix.CONNECTOR_ID);
                    HashSet<String> connectorIds = new HashSet<String>();
                    if (connectorId != null) {
                        String[] ids;
                        String[] stringArray = ids = connectorId.split(",");
                        int n = ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            if (id != null && !id.trim().isEmpty()) {
                                connectorIds.add(id.trim());
                            }
                            ++n2;
                        }
                    }
                    if (connectorIds.size() > 0) {
                        try {
                            NewProjectExamplesRequirementsPage.this.install(connectorIds);
                        }
                        catch (Exception e1) {
                            ProjectExamplesActivator.log(e1);
                        }
                    }
                    NewProjectExamplesRequirementsPage.this.refreshFixes();
                }
            }
        });
        final Button downloadAndInstall = new Button(buttonComposite, 8);
        downloadAndInstall.setLayoutData((Object)new GridData(768));
        downloadAndInstall.setText("Download and Install...");
        downloadAndInstall.setEnabled(false);
        downloadAndInstall.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectFix fix = NewProjectExamplesRequirementsPage.this.getSelectedProjectFix();
                if (fix != null) {
                    List<DownloadRuntime> runtimes = NewProjectExamplesRequirementsPage.this.getDownloadRuntimes(fix);
                    TaskWizardDialog dialog = new TaskWizardDialog(NewProjectExamplesRequirementsPage.this.getShell(), (IWizard)new DownloadRuntimesTaskWizard(runtimes));
                    dialog.open();
                    NewProjectExamplesRequirementsPage.this.refreshFixes();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = viewer.getSelection();
                install.setEnabled(false);
                downloadAndInstall.setEnabled(false);
                downloadAndInstall.setToolTipText("");
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ProjectFix) {
                    ProjectFix fix = (ProjectFix)object;
                    String fixType = fix.getType();
                    if (!(NewProjectExamplesRequirementsPage.this.unsatisfiedFixes.contains(fix) || "wtpruntime".equals(fixType) || "seam".equals(fixType))) {
                        return;
                    }
                    if ("wtpruntime".equals(fixType) || "seam".equals(fixType)) {
                        List<DownloadRuntime> downloadRuntimes = NewProjectExamplesRequirementsPage.this.getDownloadRuntimes(fix);
                        if (downloadRuntimes != null) {
                            Iterator<DownloadRuntime> iterator = downloadRuntimes.iterator();
                            while (iterator.hasNext()) {
                                DownloadRuntime downloadRuntime = iterator.next();
                                if (downloadRuntime != null) continue;
                                iterator.remove();
                            }
                        }
                        if (downloadRuntimes != null && !downloadRuntimes.isEmpty()) {
                            StringBuilder tooltip = new StringBuilder("Download and install ");
                            if (downloadRuntimes.size() > 1 && downloadRuntimes.get(0) != null && downloadRuntimes.get(0).getName() != null) {
                                tooltip.append("a runtime");
                            } else {
                                tooltip.append(downloadRuntimes.get(0).getName());
                            }
                            downloadAndInstall.setToolTipText(tooltip.toString());
                            downloadAndInstall.setEnabled(true);
                        } else {
                            downloadAndInstall.setEnabled(false);
                        }
                        install.setEnabled(true);
                        install.setToolTipText("JBoss Runtime Detection");
                    } else if ("plugin".equals(fixType)) {
                        install.setEnabled(fix.getProperties().get(ProjectFix.CONNECTOR_ID) != null);
                        install.setToolTipText("Install required feature(s)");
                    }
                }
            }
        });
    }

    protected ProjectFix getSelectedProjectFix() {
        IStructuredSelection selection;
        Object object;
        ISelection sel = this.tableViewer.getSelection();
        if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ProjectFix) {
            return (ProjectFix)object;
        }
        return null;
    }

    protected List<DownloadRuntime> getDownloadRuntimes(ProjectFix fix) {
        DownloadRuntime dr;
        String downloadId;
        if ("wtpruntime".equals(fix.getType())) {
            DownloadRuntime[] downloadableRuntimes;
            NullProgressMonitor monitor = new NullProgressMonitor();
            String allDownloadRuntimeIds = fix.getProperties().get("allowed-types");
            if (allDownloadRuntimeIds != null && !"any".equals(allDownloadRuntimeIds) && (downloadableRuntimes = WTPRuntimeFix.getDownloadRuntimesFromPattern(allDownloadRuntimeIds, (IProgressMonitor)monitor)) != null && downloadableRuntimes.length > 0) {
                return Arrays.asList(downloadableRuntimes);
            }
        }
        if ((downloadId = fix.getProperties().get(ProjectFix.DOWNLOAD_ID)) != null && (dr = (DownloadRuntime)RuntimeCoreActivator.getDefault().getDownloadRuntimes().get(downloadId)) != null) {
            return Collections.singletonList(dr);
        }
        return null;
    }

    public ProjectExample getProjectExample() {
        return this.projectExample;
    }

    @Override
    public void setProjectExample(final ProjectExampleWorkingCopy projectExample) {
        this.projectExample = projectExample;
        this.setTitleAndDescription(projectExample);
        this.refreshFixes();
        if (this.link == null) {
            return;
        }
        if (projectExample != null && projectExample.getSourceLocation() != null && !projectExample.getSourceLocation().isEmpty()) {
            this.link.setVisible(true);
            this.link.setText("Found a bug? Or have improvements to this example? Help us develop it, source can be found at <a>Project Example Source</a>");
            this.link.getParent().pack(true);
            this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text = e.text;
                    if ("Project Example Source".equals(text)) {
                        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                        try {
                            URL url = new URL(projectExample.getSourceLocation());
                            support.getExternalBrowser().openURL(url);
                        }
                        catch (Exception e1) {
                            ProjectExamplesActivator.log(e1);
                        }
                    }
                }
            });
        } else {
            this.link.setVisible(false);
            this.link.setText("");
            this.link.getParent().pack(true);
        }
    }

    protected void refreshFixes() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.fixes = new ArrayList<ProjectFix>();
        this.unsatisfiedFixes = new ArrayList();
        if (this.projectExample == null) {
            return;
        }
        this.fixes = this.projectExample.getFixes();
        this.projectExample.setUnsatisfiedFixes(this.unsatisfiedFixes);
        for (ProjectFix fix : this.fixes) {
            if (ProjectExamplesActivator.canFix(this.projectExample, fix)) continue;
            this.unsatisfiedFixes.add(fix);
        }
        this.tableViewer.setInput(this.fixes);
    }

    private String getProjectFixDescription(ProjectFix projectFix) {
        return projectFix.getProperties().get("description");
    }

    protected void install(Set<String> connectorIds) throws InvocationTargetException, InterruptedException {
        final IStatus[] results = new IStatus[1];
        final ConnectorDiscovery[] connectorDiscoveries = new ConnectorDiscovery[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ConnectorDiscovery connectorDiscovery;
                connectorDiscoveries[0] = connectorDiscovery = DiscoveryUtil.createConnectorDiscovery();
                results[0] = connectorDiscoveries[0].performDiscovery(monitor);
                if (monitor.isCanceled()) {
                    results[0] = Status.CANCEL_STATUS;
                }
            }
        };
        this.getWizard().getContainer().run(true, true, runnable);
        if (results[0] == null) {
            return;
        }
        if (results[0].isOK()) {
            List connectors = connectorDiscoveries[0].getConnectors();
            ArrayList<ConnectorDescriptor> installableConnectors = new ArrayList<ConnectorDescriptor>();
            for (DiscoveryConnector connector : connectors) {
                if (!connectorIds.contains(connector.getId())) continue;
                installableConnectors.add((ConnectorDescriptor)connector);
            }
            JBossDiscoveryUi.install(installableConnectors, (IRunnableContext)this.getWizard().getContainer());
        } else {
            String message = results[0].toString();
            switch (results[0].getSeverity()) {
                case 4: {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)message);
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Information", (String)message);
                }
            }
        }
    }

    public void setDescriptionText(String longDescription) {
        if (this.descriptionText != null) {
            if (longDescription == null) {
                longDescription = "";
            }
            if (!longDescription.equals(this.descriptionText.getText())) {
                this.descriptionText.setText(longDescription);
            }
        }
    }

    public IWizardPage getNextPage() {
        IWizard wizard;
        if (this.projectExample != null && (wizard = this.getWizard()) instanceof NewProjectExamplesWizard2) {
            NewProjectExamplesWizard2 exampleWizard = (NewProjectExamplesWizard2)wizard;
            ProjectExample projectExample = exampleWizard.getSelectedProjectExample();
            if (projectExample != null && projectExample.getImportType() != null) {
                for (IProjectExamplesWizardPage page : exampleWizard.getContributedPages("extra")) {
                    if (!projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                    return page;
                }
            }
            return ((NewProjectExamplesWizard2)wizard).getLocationsPage();
        }
        return super.getNextPage();
    }

    @Override
    public void onWizardContextChange(String key, Object value) {
    }

    @Override
    public boolean finishPage() {
        return true;
    }

    @Override
    public String getProjectExampleType() {
        return "zip";
    }

    @Override
    public Map<String, Object> getPropertiesMap() {
        return null;
    }

    @Override
    public void setWizardContext(WizardContext context) {
        this.wizardContext = context;
    }

    @Override
    public String getPageType() {
        return "requirement";
    }

    private class FixContentProvider
    implements IStructuredContentProvider {
        private List<ProjectFix> fixes;

        public FixContentProvider(List<ProjectFix> fixes) {
            this.fixes = fixes;
        }

        public Object[] getElements(Object inputElement) {
            return this.fixes.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fixes = (List)newInput;
        }
    }

    private class FixLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public FixLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public boolean useNativeToolTip(Object object) {
            return super.useNativeToolTip(object);
        }

        public Image getImage(Object element) {
            if (this.columnIndex == 2 && element instanceof ProjectFix) {
                ProjectFix fix = (ProjectFix)element;
                if (!NewProjectExamplesRequirementsPage.this.unsatisfiedFixes.contains(fix)) {
                    return NewProjectExamplesRequirementsPage.this.checkboxOn;
                }
                return NewProjectExamplesRequirementsPage.this.checkboxOff;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ProjectFix) {
                ProjectFix fix = (ProjectFix)element;
                if (this.columnIndex == 0) {
                    if ("wtpruntime".equals(fix.getType())) {
                        return "server/runtime";
                    }
                    return fix.getType();
                }
                if (this.columnIndex == 1) {
                    return NewProjectExamplesRequirementsPage.this.getProjectFixDescription(fix);
                }
            }
            return null;
        }

        public String getToolTipText(Object element) {
            if ("win32".equals(Platform.getOS())) {
                return null;
            }
            if (element instanceof ProjectFix && this.columnIndex == 1) {
                return NewProjectExamplesRequirementsPage.this.getProjectFixDescription((ProjectFix)element);
            }
            return null;
        }
    }
}

