/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.preferences;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.model.SiteCategory;
import org.jboss.tools.project.examples.preferences.SiteDialog;
import org.jboss.tools.project.examples.preferences.Sites;

public class ProjectExamplesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.jboss.tools.project.examples.preferences.projectExamplesPreferencePage";
    private Button showExperimentalSites;
    private Button showRuntimeSites;
    private Sites sites;
    private TreeViewer viewer;
    private ProjectExampleSite selectedSite;
    private Button showInvalidSites;
    private Text outputDirectoryText;
    private Button isWorkspace;
    private Button showProjectReadyWizard;
    private Button showReadme;
    private Button showQuickFix;
    private RadioGroupFieldEditor showCheatSheetEditor;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Group outputDirectoryGroup = new Group(composite, 0);
        layout = new GridLayout(2, false);
        outputDirectoryGroup.setLayout((Layout)layout);
        outputDirectoryGroup.setText(Messages.ProjectExamplesPreferencePage_Output_directory);
        GridData gd = new GridData(4, 4, true, false);
        outputDirectoryGroup.setLayoutData((Object)gd);
        this.isWorkspace = new Button((Composite)outputDirectoryGroup, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.isWorkspace.setLayoutData((Object)gd);
        this.isWorkspace.setText(Messages.ProjectExamplesPreferencePage_Use_default_workspace_location);
        this.isWorkspace.setSelection(ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("projectExamplesDefaultLocation"));
        this.outputDirectoryText = new Text((Composite)outputDirectoryGroup, 2052);
        gd = new GridData(4, 4, true, false);
        gd.verticalAlignment = 0x1000000;
        this.outputDirectoryText.setLayoutData((Object)gd);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        String outputDirectoryValue = store.getString("projectExamplesOutputDirectory");
        this.outputDirectoryText.setText(outputDirectoryValue == null ? "" : outputDirectoryValue);
        final Button outputDirectoryBrowse = new Button((Composite)outputDirectoryGroup, 8);
        outputDirectoryBrowse.setText(Messages.Browse);
        outputDirectoryBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ProjectExamplesPreferencePage.this.getShell(), 4);
                String value = ProjectExamplesPreferencePage.this.outputDirectoryText.getText();
                if (value.trim().length() == 0) {
                    value = Platform.getLocation().toOSString();
                }
                dialog.setFilterPath(value);
                String result = dialog.open();
                if (result == null || result.trim().length() == 0) {
                    return;
                }
                ProjectExamplesPreferencePage.this.outputDirectoryText.setText(result);
            }
        });
        this.enableControls(outputDirectoryBrowse);
        this.isWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectExamplesPreferencePage.this.enableControls(outputDirectoryBrowse);
            }
        });
        this.showProjectReadyWizard = new Button(composite, 32);
        this.showProjectReadyWizard.setText("Show Project Ready wizard");
        this.showProjectReadyWizard.setSelection(store.getBoolean("showProjectRadyWizard"));
        this.showReadme = new Button(composite, 32);
        this.showReadme.setText("Show readme/cheatsheet file");
        this.showReadme.setSelection(store.getBoolean("showReadme"));
        this.showQuickFix = new Button(composite, 32);
        this.showQuickFix.setText("Show Quick Fix dialog");
        this.showQuickFix.setSelection(store.getBoolean("showQuickFix"));
        this.showExperimentalSites = new Button(composite, 32);
        this.showExperimentalSites.setText(Messages.ProjectExamplesPreferencePage_Show_experimental_sites);
        this.showExperimentalSites.setSelection(store.getBoolean("showExperimentalSites"));
        this.showRuntimeSites = new Button(composite, 32);
        this.showRuntimeSites.setText(Messages.ProjectExamplesPreferencePage_Show_runtime_sites);
        this.showRuntimeSites.setSelection(store.getBoolean("showRuntimeSites"));
        this.showInvalidSites = new Button(composite, 32);
        this.showInvalidSites.setText(Messages.ProjectExamplesPreferencePage_Show_invalid_sites);
        this.showInvalidSites.setSelection(store.getBoolean("invalidSites"));
        this.createShowCheatSheetControls(composite);
        Group sitesGroup = new Group(composite, 0);
        sitesGroup.setText(Messages.ProjectExamplesPreferencePage_Sites);
        GridLayout gl = new GridLayout(2, false);
        sitesGroup.setLayout((Layout)gl);
        sitesGroup.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer((Composite)sitesGroup, 2816);
        this.viewer.setContentProvider((IContentProvider)new SitesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.sites = new Sites();
        this.viewer.setInput((Object)this.sites);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.expandAll();
        Composite buttonComposite = new Composite((Composite)sitesGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(Messages.ProjectExamplesPreferencePage_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String name;
                SiteDialog dialog = new SiteDialog(ProjectExamplesPreferencePage.this.getShell(), null, ProjectExamplesPreferencePage.this.sites);
                int ok = dialog.open();
                if (ok == 0 && (name = dialog.getName()) != null) {
                    URL url = dialog.getURL();
                    ProjectExampleSite site = new ProjectExampleSite();
                    site.setUrl(url);
                    site.setName(name);
                    site.setEditable(true);
                    ProjectExamplesPreferencePage.this.sites.add(site);
                    ProjectExamplesPreferencePage.this.viewer.refresh();
                }
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setText(Messages.ProjectExamplesPreferencePage_Edit);
        editButton.setEnabled(false);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                if (ProjectExamplesPreferencePage.this.selectedSite == null) {
                    return;
                }
                SiteDialog dialog = new SiteDialog(ProjectExamplesPreferencePage.this.getShell(), ProjectExamplesPreferencePage.this.selectedSite, ProjectExamplesPreferencePage.this.sites);
                int ok = dialog.open();
                if (ok == 0 && (name = dialog.getName()) != null) {
                    URL url = dialog.getURL();
                    ProjectExampleSite site = ProjectExamplesPreferencePage.this.selectedSite;
                    site.setUrl(url);
                    site.setName(name);
                    site.setEditable(true);
                    ProjectExamplesPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(Messages.ProjectExamplesPreferencePage_Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectExamplesPreferencePage.this.selectedSite != null) {
                    ProjectExamplesPreferencePage.this.sites.remove(ProjectExamplesPreferencePage.this.selectedSite);
                    ProjectExamplesPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection treeSelection;
                Object object;
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
                ProjectExamplesPreferencePage.this.selectedSite = null;
                ISelection selection = event.getSelection();
                if (selection instanceof ITreeSelection && (object = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof ProjectExampleSite) {
                    ProjectExamplesPreferencePage.this.selectedSite = (ProjectExampleSite)object;
                    boolean editable = ((IProjectExampleSite)object).isEditable();
                    editButton.setEnabled(editable);
                    removeButton.setEnabled(editable);
                }
            }
        });
        return composite;
    }

    private void createShowCheatSheetControls(Composite parent) {
        String name = "showCheatsheets";
        String label = "Show included cheat sheet(s) when importing a new project";
        String[][] namesAndValues = new String[][]{{"Always show", "always"}, {"Never show", "never"}, {"Prompt", "prompt"}};
        this.showCheatSheetEditor = new RadioGroupFieldEditor(name, label, 3, namesAndValues, parent, true);
        this.showCheatSheetEditor.setPreferenceStore(ProjectExamplesActivator.getDefault().getPreferenceStore());
        this.showCheatSheetEditor.setPage((DialogPage)this);
        this.showCheatSheetEditor.load();
    }

    protected void enableControls(Button outputDirectoryBrowse) {
        this.outputDirectoryText.setEnabled(!this.isWorkspace.getSelection());
        outputDirectoryBrowse.setEnabled(!this.isWorkspace.getSelection());
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.showProjectReadyWizard.setSelection(true);
        this.showReadme.setSelection(true);
        this.showQuickFix.setSelection(true);
        this.showExperimentalSites.setSelection(false);
        this.showRuntimeSites.setSelection(false);
        this.showInvalidSites.setSelection(true);
        this.isWorkspace.setSelection(true);
        this.outputDirectoryText.setText("");
        this.sites.getUserSites().clear();
        this.sites.getRuntimeSites().clear();
        this.showCheatSheetEditor.loadDefault();
        this.storePreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.showCheatSheetEditor.store();
        this.storePreferences();
        return super.performOk();
    }

    private void storePreferences() {
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        store.setValue("showProjectRadyWizard", this.showProjectReadyWizard.getSelection());
        store.setValue("showReadme", this.showReadme.getSelection());
        store.setValue("showQuickFix", this.showQuickFix.getSelection());
        store.setValue("showExperimentalSites", this.showExperimentalSites.getSelection());
        store.setValue("showRuntimeSites", this.showRuntimeSites.getSelection());
        store.setValue("invalidSites", this.showInvalidSites.getSelection());
        store.setValue("projectExamplesDefaultLocation", this.isWorkspace.getSelection());
        String value = this.outputDirectoryText.getText();
        if (!value.isEmpty()) {
            store.setValue("projectExamplesOutputDirectory", value);
        }
        try {
            String userSites = ProjectExampleUtil.getAsXML(this.sites.getUserSites());
            store.setValue("userSites", userSites);
        }
        catch (Exception e) {
            ProjectExamplesActivator.log(e);
        }
    }

    class SitesContentProvider
    implements ITreeContentProvider {
        SitesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Sites) {
                return ((Sites)parentElement).getSiteCategories();
            }
            if (parentElement instanceof SiteCategory) {
                return ((SiteCategory)parentElement).getSites().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Sites || element instanceof SiteCategory;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SitesLabelProvider
    extends LabelProvider {
        SitesLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IProjectExampleSite) {
                return ((IProjectExampleSite)element).getName();
            }
            return super.getText(element);
        }
    }
}

