/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.offline.ExtractScriptJob;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.offline.OfflineUtil;

public class OfflineSupportPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static boolean VISIBLE;
    public static final String ID = "org.jboss.tools.project.examples.preferences.offlineSupportPreferencePage";
    private Text offlineDirectoryText;
    private Button enableOfflineSupport;
    private Button offlineDirectoryBrowse;

    public OfflineSupportPreferencePage() {
        try {
            ProjectExamplesActivator.getDefault().getImportProjectExample(null);
        }
        catch (Exception exception) {}
    }

    protected Control createContents(Composite parent) {
        ExtractScriptJob extractScriptJob = new ExtractScriptJob();
        extractScriptJob.schedule();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createEnableOfflineGroup(composite);
        this.createGoOfflineGroup(composite);
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        VISIBLE = visible;
    }

    private void enableControls() {
        this.offlineDirectoryText.setEnabled(this.enableOfflineSupport.getSelection());
        this.offlineDirectoryBrowse.setEnabled(this.enableOfflineSupport.getSelection());
        this.checkOfflineDirectory();
    }

    private void checkOfflineDirectory() {
        if (this.enableOfflineSupport.getSelection()) {
            File offlineDir = this.getOfflineDir();
            if (offlineDir == null) {
                this.setErrorMessage("You must set an offline directory");
            } else if (!offlineDir.exists()) {
                this.setMessage("The offline directory is empty, make sure you run the offline script", 2);
            } else if (offlineDir.listFiles().length == 0) {
                this.setMessage("The offline directory does not exist, make sure you run the offline script", 2);
            } else {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
        } else {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
    }

    private void createEnableOfflineGroup(Composite composite) {
        Composite enableOfflineSupportGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        enableOfflineSupportGroup.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        enableOfflineSupportGroup.setLayoutData((Object)gd);
        this.enableOfflineSupport = new Button(enableOfflineSupportGroup, 32);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 2;
        this.enableOfflineSupport.setLayoutData((Object)gd2);
        this.enableOfflineSupport.setText("Enable offline mode for project examples");
        this.enableOfflineSupport.setToolTipText("In offline mode, examples will be fetched from the offline directory");
        this.enableOfflineSupport.setSelection(ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("projectExamplesOfflineEnabled"));
        Label offlineDirectoryLabel = new Label(enableOfflineSupportGroup, 0);
        offlineDirectoryLabel.setText("Offline directory :");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)offlineDirectoryLabel);
        this.offlineDirectoryText = new Text(enableOfflineSupportGroup, 2052);
        GridData gd3 = new GridData(4, 4, true, false);
        gd3.verticalAlignment = 0x1000000;
        this.offlineDirectoryText.setLayoutData((Object)gd3);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        String offlineDirectoryValue = store.getString("projectExamplesOfflineDirectory");
        this.offlineDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                OfflineSupportPreferencePage.this.checkOfflineDirectory();
            }
        });
        this.offlineDirectoryText.setText(offlineDirectoryValue == null ? "" : offlineDirectoryValue);
        this.offlineDirectoryBrowse = new Button(enableOfflineSupportGroup, 8);
        this.offlineDirectoryBrowse.setText(Messages.Browse);
        this.offlineDirectoryBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(OfflineSupportPreferencePage.this.getShell(), 4);
                String value = OfflineSupportPreferencePage.this.offlineDirectoryText.getText();
                if (value.trim().length() == 0) {
                    value = Platform.getLocation().toOSString();
                }
                dialog.setFilterPath(value);
                String result = dialog.open();
                if (result == null || result.trim().length() == 0) {
                    return;
                }
                OfflineSupportPreferencePage.this.offlineDirectoryText.setText(result);
            }
        });
        this.enableOfflineSupport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OfflineSupportPreferencePage.this.enableControls();
            }
        });
        this.enableControls();
    }

    private void createGoOfflineGroup(Composite composite) {
        Group goOfflineGroup = new Group(composite, 0);
        GridLayout layout2 = new GridLayout(2, false);
        goOfflineGroup.setLayout((Layout)layout2);
        GridData gd2 = new GridData(4, 4, true, true);
        goOfflineGroup.setLayoutData((Object)gd2);
        goOfflineGroup.setText("Prepare offline data");
        Label description = new Label((Composite)goOfflineGroup, 64);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)description);
        description.setText("The following command generates an offline cache usable by the project examples.\n Pre-requisites :\n");
        Link groovylink = new Link((Composite)goOfflineGroup, 64);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)groovylink);
        groovylink.setText(" - <a>Groovy 2.1.x</a> must be set in your path");
        groovylink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OfflineSupportPreferencePage.openUrl("http://groovy.codehaus.org/Installing+Groovy");
            }
        });
        Link reposlink = new Link((Composite)goOfflineGroup, 64);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)reposlink);
        reposlink.setText(" - the JBoss Public and Red Hat Maven repositories must be <a>configured in your settings.xml</a>");
        reposlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OfflineSupportPreferencePage.openUrl("http://community.jboss.org/wiki/SettingUpTheJBossEnterpriseRepositories");
            }
        });
        final StyledText text = new StyledText((Composite)goOfflineGroup, 576);
        GridDataFactory.fillDefaults().grab(true, false).hint(90, 250).applyTo((Control)text);
        text.setEditable(false);
        Collection<String> descriptors = this.getDescriptors(ProjectExampleUtil.getPluginSites());
        Collection<String> categories = this.getAsStringCollection(ProjectExampleUtil.getCategoryURLs());
        StringBuilder command = new StringBuilder("groovy \"").append(OfflineUtil.getGoOfflineScript().getAbsolutePath()).append("\" ").append(StringUtils.join(categories, (String)" ")).append(" ").append(StringUtils.join(descriptors, (String)" ")).append(" -q -e");
        text.setText(command.toString());
        final Clipboard cb = new Clipboard(Display.getCurrent());
        Button copy = new Button((Composite)goOfflineGroup, 8);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)copy);
        copy.setText("Copy to clipboard");
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String textData = text.getText();
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{textData}, new Transfer[]{textTransfer});
            }
        });
        Label explanation = new Label((Composite)goOfflineGroup, 64);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)explanation);
        explanation.setText("The script will create an offline/ directory under the current directory.\nIt will attempt to download and build all project examples, populating a clean local maven repository.\n\n");
        Label instructions = new Label((Composite)goOfflineGroup, 64);
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)instructions.getFont());
        descriptor = descriptor.setStyle(1);
        instructions.setFont(descriptor.createFont((Device)instructions.getDisplay()));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)instructions);
        instructions.setText("- Make sure you copy the contents of offline/.jbosstools/cache to the final offline directory\n- Copy the contents offline/.m2/repository to your local maven repository location.");
    }

    private Collection<String> getDescriptors(Collection<IProjectExampleSite> pluginSites) {
        ArrayList<String> descriptorUrls = new ArrayList<String>(pluginSites.size());
        for (IProjectExampleSite site : pluginSites) {
            if (site.isExperimental()) continue;
            descriptorUrls.add(site.getUrl().toString());
        }
        return descriptorUrls;
    }

    private Collection<String> getAsStringCollection(Collection<URL> urls) {
        ArrayList<String> sUrls = new ArrayList<String>(urls.size());
        for (URL u : urls) {
            sUrls.add(u.toString());
        }
        return sUrls;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.offlineDirectoryText.setText(ProjectExamplesActivator.PROJECT_EXAMPLES_OFFLINE_DIRECTORY_VALUE);
        this.storePreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        this.storePreferences();
        return super.performOk();
    }

    private void storePreferences() {
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        File offlineDir = this.getOfflineDir();
        Boolean isOfflineEnabled = this.enableOfflineSupport.getSelection();
        if (offlineDir != null) {
            store.setValue("projectExamplesOfflineDirectory", offlineDir.getAbsolutePath());
        }
        store.setValue("projectExamplesOfflineEnabled", isOfflineEnabled.toString());
    }

    private File getOfflineDir() {
        String offlineDir = this.offlineDirectoryText.getText().trim();
        if (!offlineDir.isEmpty()) {
            return new File(offlineDir);
        }
        return null;
    }

    public static void openUrl(String location) {
        URL url = null;
        boolean asExternal = true;
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        try {
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1 || asExternal) {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                support.getExternalBrowser().openURL(url);
            } else {
                IWebBrowser browser = null;
                int flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.jboss.tools.project.examples" + System.currentTimeMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            Status status = new Status(4, "org.jboss.tools.project.examples", "Browser initialization failed");
            ProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)shell, (String)"Open Location", (String)status.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            Status status = new Status(4, "org.jboss.tools.project.examples", "Invalid URL");
            ProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)shell, (String)"Open Location", (String)status.getMessage());
        }
    }
}

