/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.tools.project.examples.model.ArchetypeModel;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.model.ProjectModelElement;

public class ProjectExample
implements ProjectModelElement,
Comparable<ProjectExample> {
    public static final String IMPORT_TYPE_ZIP = "zip";
    private static final String SEP = "/";
    private static String[] PREFIXES = new String[]{"file:", "http:", "https:", "ftp:"};
    private String name = "";
    private String headLine;
    private String shortDescription = "";
    private String description = "";
    private String url = "";
    private long size;
    private ProjectExampleCategory category;
    private List<String> includedProjects;
    private boolean welcome = false;
    private String type;
    private String welcomeURL;
    private boolean welcomeFixRequired = true;
    private List<ProjectFix> fixes = new ArrayList<ProjectFix>();
    private List<ProjectFix> unsatisfiedFixes;
    private String perspectiveId = null;
    private String importType = "zip";
    private String importTypeDescription;
    private ArchetypeModel archetypeModel;
    private File file;
    private IProjectExampleSite site;
    private String defaultProfiles = "";
    private int priority;
    private Set<String> tags;
    private Set<String> essentialEnterpriseDependencies;
    private String iconPath;
    private String sourceLocation;
    private String stacksId;
    private String stacksType;

    public ProjectExample() {
        this.setCategory(ProjectExampleCategory.OTHER);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        if (this.url == null) {
            return this.url;
        }
        this.url = this.url.trim();
        String[] stringArray = PREFIXES;
        int n = PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (this.url.startsWith(prefix)) {
                return this.url;
            }
            ++n2;
        }
        if (this.site == null) {
            return this.url;
        }
        URL siteURL = this.site.getUrl();
        if (siteURL == null) {
            return this.url;
        }
        String urlString = siteURL.toString();
        if (urlString.endsWith(SEP)) {
            urlString = urlString.substring(0, urlString.length() - 1);
        } else {
            int index = urlString.lastIndexOf(SEP);
            if (index > 0) {
                urlString = urlString.substring(0, index);
            }
        }
        if (this.url.startsWith(SEP)) {
            return String.valueOf(urlString) + this.url;
        }
        return String.valueOf(urlString) + SEP + this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public long getSize() {
        return this.size;
    }

    void setSize(long size) {
        this.size = size;
    }

    public ProjectExampleCategory getCategory() {
        return this.category;
    }

    void setCategory(ProjectExampleCategory category) {
        this.category = category;
    }

    public String getSizeAsText() {
        String sizeString = "";
        BigDecimal sizeDecimal = new BigDecimal(this.size);
        BigDecimal MB = new BigDecimal(0x100000);
        BigDecimal KB = new BigDecimal(1024);
        sizeString = sizeDecimal.compareTo(MB) > 0 ? String.format("%5.2fM", sizeDecimal.divide(MB)) : (sizeDecimal.compareTo(KB) > 0 ? String.format("%5.2fK", sizeDecimal.divide(KB)) : String.format("%d", this.size));
        return sizeString;
    }

    public List<String> getIncludedProjects() {
        return this.includedProjects;
    }

    void setIncludedProjects(List<String> includedProjects) {
        this.includedProjects = includedProjects;
    }

    public boolean isWelcome() {
        return this.welcome;
    }

    void setWelcome(boolean welcome) {
        this.welcome = welcome;
    }

    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    public String getWelcomeURL() {
        return this.welcomeURL == null ? "" : this.welcomeURL;
    }

    public void setWelcomeURL(String welcomeURL) {
        this.welcomeURL = welcomeURL;
    }

    @Override
    public IProjectExampleSite getSite() {
        return this.site;
    }

    void setSite(IProjectExampleSite site) {
        this.site = site;
    }

    public List<ProjectFix> getFixes() {
        return this.fixes;
    }

    void setFixes(List<ProjectFix> fixes) {
        this.fixes = fixes;
    }

    public List<ProjectFix> getUnsatisfiedFixes() {
        return this.unsatisfiedFixes;
    }

    public void setUnsatisfiedFixes(List<ProjectFix> unsatisfiedFixes) {
        this.unsatisfiedFixes = unsatisfiedFixes;
    }

    public String getPerspectiveId() {
        return this.perspectiveId;
    }

    void setPerspectiveId(String perspectiveId) {
        this.perspectiveId = perspectiveId;
    }

    public String getImportType() {
        return this.importType;
    }

    void setImportType(String importType) {
        this.importType = importType;
    }

    public String getImportTypeDescription() {
        return this.importTypeDescription;
    }

    void setImportTypeDescription(String importTypeDescription) {
        this.importTypeDescription = importTypeDescription;
    }

    void setArchetypeModel(ArchetypeModel archetypeModel) {
        this.archetypeModel = archetypeModel;
    }

    public ArchetypeModel getArchetypeModel() {
        if (this.archetypeModel == null) {
            this.archetypeModel = new ArchetypeModel();
        }
        return this.archetypeModel;
    }

    public boolean isURLRequired() {
        return !"mavenArchetype".equals(this.importType);
    }

    public File getFile() {
        return this.file;
    }

    void setFile(File file) {
        this.file = file;
    }

    public String getDefaultProfiles() {
        return this.defaultProfiles;
    }

    void setDefaultProfiles(String defaultProfiles) {
        this.defaultProfiles = defaultProfiles;
    }

    public String toString() {
        return this.getName();
    }

    void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Set<String> getTags() {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        return this.tags;
    }

    public boolean hasTags(String ... tags) {
        if (!this.getTags().isEmpty() && tags != null && tags.length > 0) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!this.getTags().contains(tag)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void setIconPath(String path) {
        this.iconPath = path;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public int getPriority() {
        return this.priority;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(ProjectExample o) {
        if (o == null) {
            return -1;
        }
        ProjectExampleCategory otherCategory = o.getCategory();
        if (otherCategory == null && this.category == null) {
            return 0;
        }
        if (this.category != null) {
            if (this.category.compareTo(otherCategory) != 0) {
                return this.category.compareTo(otherCategory);
            }
            int other = o.getPriority();
            if (other < this.priority) {
                return 1;
            }
            if (other > this.priority) {
                return -1;
            }
            if (this.name == null) {
                return -1;
            }
            return this.name.compareTo(o.getName());
        }
        return -1;
    }

    void setEssentialEnterpriseDependencyGavs(Set<String> gavs) {
        this.essentialEnterpriseDependencies = gavs;
    }

    public Set<String> getEssentialEnterpriseDependencyGavs() {
        return this.essentialEnterpriseDependencies;
    }

    public boolean isWelcomeFixRequired() {
        return this.welcomeFixRequired;
    }

    void setWelcomeFixRequired(boolean welcomeFixRequired) {
        this.welcomeFixRequired = welcomeFixRequired;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public String getStacksId() {
        return this.stacksId;
    }

    void setStacksId(String stacksId) {
        this.stacksId = stacksId;
    }

    public String getHeadLine() {
        if (this.headLine == null) {
            this.headLine = this.getShortDescription();
        }
        return this.headLine;
    }

    public void setHeadLine(String headLine) {
        this.headLine = headLine;
    }

    void setStacksType(String stacksType) {
        this.stacksType = stacksType;
    }

    public String getStacksType() {
        return this.stacksType;
    }

    public ProjectExampleWorkingCopy createWorkingCopy() {
        return new ProjectExampleWorkingCopy(this);
    }
}

