/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.discovery;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCertification;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.osgi.util.NLS;

public class ChainedDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private List<AbstractDiscoveryStrategy> strategies;
    private DataCollector dataCollector;

    public ChainedDiscoveryStrategy(DataCollector dataCollector) {
        this.dataCollector = dataCollector;
        this.strategies = new ArrayList<AbstractDiscoveryStrategy>();
    }

    public ChainedDiscoveryStrategy addStrategy(AbstractDiscoveryStrategy strategy) {
        this.strategies.add(strategy);
        return this;
    }

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (this.strategies.isEmpty()) {
            throw new IllegalStateException("At least one AbstractDiscoveryStrategy must be added");
        }
        MultiStatus status = new MultiStatus("org.jboss.tools.project.examples", 0, "All attempts to discover connectors have failed", null);
        for (AbstractDiscoveryStrategy ds : this.strategies) {
            try {
                ds.performDiscovery(monitor);
                this.dataCollector.collectData(ds);
                if (!this.dataCollector.isComplete()) continue;
                break;
            }
            catch (Exception e) {
                status.add((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"Failed to get connectors from {0}", (Object)ds.getClass().getSimpleName()), (Throwable)e));
            }
        }
        if (status.getChildren().length == this.strategies.size()) {
            throw new CoreException((IStatus)status);
        }
        if (status.getChildren().length > 0) {
            StatusHandler.log((IStatus)status);
        }
    }

    public void setCategories(List<DiscoveryCategory> categories) {
        for (AbstractDiscoveryStrategy ds : this.strategies) {
            ds.setCategories(categories);
        }
    }

    public void setConnectors(List<DiscoveryConnector> connectors) {
        for (AbstractDiscoveryStrategy ds : this.strategies) {
            ds.setConnectors(connectors);
        }
    }

    public void setCertifications(List<DiscoveryCertification> certifications) {
        for (AbstractDiscoveryStrategy ds : this.strategies) {
            ds.setCertifications(certifications);
        }
    }

    public static interface DataCollector {
        public void collectData(AbstractDiscoveryStrategy var1);

        public boolean isComplete();
    }

    public static final class DiscoveryConnectorCollector
    implements DataCollector {
        public static String ALLOW_DUPLICATE_DISCOVERY_CONNECTORS_KEY = "org.jboss.tools.discovery.allow.duplicate.connectors";
        private boolean isComplete;
        private boolean allowDuplicates;

        public DiscoveryConnectorCollector() {
            this(Boolean.getBoolean(ALLOW_DUPLICATE_DISCOVERY_CONNECTORS_KEY));
        }

        public DiscoveryConnectorCollector(boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
        }

        @Override
        public boolean isComplete() {
            return this.isComplete && !this.allowDuplicates;
        }

        @Override
        public void collectData(AbstractDiscoveryStrategy ds) {
            List collected = ds.getConnectors();
            this.isComplete = collected != null && !collected.isEmpty();
        }
    }
}

