/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.docbook.template;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ElementWithGeneratedOutputTemplate
extends VpeAbstractTemplate {
    private static final String BACKGROUND_COLOR = "rgb(236, 243, 255)";
    private static final String BORDER = "1px solid black";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement div = visualDocument.createElement("div");
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)div);
        nsIDOMCSSStyleDeclaration style = VpeStyleUtil.getStyle((nsIDOMElement)div);
        style.setProperty("background-color", this.getBackgroundColor(), "");
        style.setProperty("border", this.getBorder(), "");
        NodeList titleElements = sourceElement.getElementsByTagName("title");
        if (titleElements.getLength() == 0) {
            nsIDOMElement h1 = visualDocument.createElement("h1");
            h1.appendChild((nsIDOMNode)visualDocument.createTextNode(this.getGeneratedText()));
            div.appendChild((nsIDOMNode)h1);
        }
        return new VpeCreationData((nsIDOMNode)div);
    }

    protected abstract String getGeneratedText();

    protected String getBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    protected String getBorder() {
        return BORDER;
    }
}

