/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.docbook.template;

import java.text.MessageFormat;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocbookXrefTemplate
extends VpeAbstractTemplate {
    private static final String STR_EMPTY = "";
    private static final String STR_BLANK = " ";
    private static final String OPEN_TAG = "<";
    private static final String XREF_WITH_PARAM = "<xref linkend=\"{0}\"/>";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        String linkendElementId = this.obtainLinkendElementId(sourceNode);
        String elementText = this.obtainElementText(sourceNode, linkendElementId);
        String elementName = elementText.startsWith(OPEN_TAG) ? "span" : "a";
        nsIDOMElement newElement = visualDocument.createElement(elementName);
        if ("a".equals(elementName)) {
            newElement.setAttribute("href", "#" + linkendElementId);
        }
        newElement.appendChild((nsIDOMNode)visualDocument.createTextNode(elementText));
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)newElement);
        return creationData;
    }

    private String obtainLinkendElementId(Node sourceNode) {
        String linkendElementId = null;
        Element sourceElement = (Element)sourceNode;
        if (sourceElement.hasAttribute("endterm")) {
            linkendElementId = sourceElement.getAttribute("endterm");
        } else if (sourceElement.hasAttribute("linkend")) {
            linkendElementId = sourceElement.getAttribute("linkend");
        }
        return linkendElementId;
    }

    private String obtainElementText(Node sourceNode, String linkendElementId) {
        if (linkendElementId == null) {
            return MessageFormat.format(XREF_WITH_PARAM, STR_EMPTY);
        }
        Element linkendElement = sourceNode.getOwnerDocument().getElementById(linkendElementId);
        if (linkendElement == null) {
            return MessageFormat.format(XREF_WITH_PARAM, linkendElementId);
        }
        if (linkendElement.hasAttribute("xreflabel")) {
            return linkendElement.getAttribute("xreflabel");
        }
        NodeList titleNodes = linkendElement.getElementsByTagName("title");
        if (titleNodes.getLength() > 0) {
            Node titleNode = titleNodes.item(0);
            StringBuilder titleText = new StringBuilder();
            this.obtainTextFromChildNodes(titleNode, titleText);
            return titleText.toString();
        }
        if (linkendElement.getChildNodes().getLength() == 1 && 3 == linkendElement.getFirstChild().getNodeType()) {
            return linkendElement.getFirstChild().getNodeValue();
        }
        return MessageFormat.format(XREF_WITH_PARAM, linkendElementId);
    }

    private void obtainTextFromChildNodes(Node parentNode, StringBuilder titleText) {
        if (3 == parentNode.getNodeType()) {
            if (titleText.length() > 0) {
                titleText.append(STR_BLANK);
            }
            titleText.append(parentNode.getNodeValue());
            return;
        }
        NodeList childNodes = parentNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            this.obtainTextFromChildNodes(childNode, titleText);
            ++i;
        }
    }
}

