/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.internal.jobs;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;

public class DeleteExistingClasspathEntriesJob
extends Job {
    private IProject project;

    public DeleteExistingClasspathEntriesJob(IProject project) {
        super("Delete classpath entries" + (project == null ? "" : "for " + project.getName()));
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                return Status.OK_STATUS;
            }
        }
        catch (CoreException coreException) {
            return Status.OK_STATUS;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        if (javaProject != null) {
            try {
                ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (this.isKept(entry)) {
                        newEntries.add(entry);
                    }
                    ++n2;
                }
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), monitor);
            }
            catch (JavaModelException e) {
                Status error = new Status(4, "org.jboss.tools.maven.conversion.ui", "Unable to update classpath", (Throwable)e);
                return error;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean isKept(IClasspathEntry cpe) {
        return 3 == cpe.getEntryKind() || 5 == cpe.getEntryKind() && ("org.eclipse.jdt.launching.JRE_CONTAINER".equals(cpe.getPath().segment(0)) || MavenClasspathHelpers.isMaven2ClasspathContainer((IPath)cpe.getPath()));
    }
}

