/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.handlers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.maven.conversion.ui.dialog.ConversionWizardDialog;
import org.jboss.tools.maven.conversion.ui.dialog.ConvertToMavenDependencyWizard;

public class ConvertToMavenDependencyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Set<IClasspathEntry> entries = this.getSelectedClasspathEntries(selection);
        if (entries == null || entries.isEmpty()) {
            MessageDialogWithToggle.openInformation((Shell)window.getShell(), (String)"Convert to Maven Dependency", (String)"Nothing to convert");
            return null;
        }
        ConvertToMavenDependencyWizard wizard = new ConvertToMavenDependencyWizard(null, null);
        ConversionWizardDialog dialog = new ConversionWizardDialog(window.getShell(), (IWizard)wizard);
        dialog.open();
        return null;
    }

    private Set<IClasspathEntry> getSelectedClasspathEntries(ISelection selection) {
        LinkedHashSet<IClasspathEntry> files = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            files = new LinkedHashSet<IClasspathEntry>(structuredSelection.size());
            for (Object o : structuredSelection) {
                ClassPathContainer container;
                if (o instanceof IPackageFragmentRoot) {
                    ((IPackageFragmentRoot)o).getPath();
                    this.addClasspathEntry((IPackageFragmentRoot)o, files);
                    continue;
                }
                if (!(o instanceof ClassPathContainer) || !this.isValid(container = (ClassPathContainer)o)) continue;
                IPackageFragmentRoot[] iPackageFragmentRootArray = container.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
                    this.addClasspathEntry(pfr, files);
                    ++n2;
                }
            }
        }
        return files;
    }

    private boolean isValid(ClassPathContainer container) {
        return !MavenClasspathHelpers.isMaven2ClasspathContainer((IPath)container.getClasspathEntry().getPath());
    }

    private void addClasspathEntry(IPackageFragmentRoot pfr, Collection<IClasspathEntry> entries) {
        if (pfr.isArchive()) {
            pfr.getResource();
            try {
                IClasspathEntry cpe = pfr.getResolvedClasspathEntry();
                if (cpe != null && cpe.getEntryKind() == 1) {
                    entries.add(cpe);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }
}

