/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.jboss.tools.hibernate.proxy.ColumnProxy;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.spi.IColumn;
import org.jboss.tools.hibernate.spi.IPrimaryKey;
import org.jboss.tools.hibernate.spi.ITable;

public class PrimaryKeyProxy
implements IPrimaryKey {
    private PrimaryKey target = null;
    private List<IColumn> columns = null;
    private ITable table = null;

    public PrimaryKeyProxy(PrimaryKey primaryKey) {
        this.target = primaryKey;
    }

    public void addColumn(IColumn column) {
        assert (column instanceof ColumnProxy);
        this.target.addColumn(((ColumnProxy)column).getTarget());
    }

    PrimaryKey getTarget() {
        return this.target;
    }

    public int getColumnSpan() {
        return this.target.getColumnSpan();
    }

    public List<IColumn> getColumns() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns;
    }

    private void initializeColumns() {
        this.columns = new ArrayList<IColumn>();
        Iterator origin = this.target.getColumns().iterator();
        while (origin.hasNext()) {
            this.columns.add(new ColumnProxy((Column)origin.next()));
        }
    }

    public IColumn getColumn(int i) {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.get(i);
    }

    public ITable getTable() {
        if (this.table == null && this.target.getTable() != null) {
            this.table = new TableProxy(this.target.getTable());
        }
        return this.table;
    }

    public boolean containsColumn(IColumn column) {
        assert (column instanceof ColumnProxy);
        return this.target.containsColumn(((ColumnProxy)column).getTarget());
    }

    public Iterator<IColumn> columnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    public String getName() {
        return this.target.getName();
    }
}

