/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.jdbc.dialect.spi.DialectFactory;
import org.jboss.tools.hibernate.proxy.DialectProxy;
import org.jboss.tools.hibernate.proxy.MappingProxy;
import org.jboss.tools.hibernate.proxy.MappingsProxy;
import org.jboss.tools.hibernate.proxy.NamingStrategyProxy;
import org.jboss.tools.hibernate.proxy.PersistentClassProxy;
import org.jboss.tools.hibernate.proxy.ReverseEngineeringStrategyProxy;
import org.jboss.tools.hibernate.proxy.SessionFactoryProxy;
import org.jboss.tools.hibernate.proxy.SettingsProxy;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.spi.IConfiguration;
import org.jboss.tools.hibernate.spi.IDialect;
import org.jboss.tools.hibernate.spi.IMapping;
import org.jboss.tools.hibernate.spi.IMappings;
import org.jboss.tools.hibernate.spi.INamingStrategy;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IReverseEngineeringStrategy;
import org.jboss.tools.hibernate.spi.ISessionFactory;
import org.jboss.tools.hibernate.spi.ISettings;
import org.jboss.tools.hibernate.spi.ITable;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class ConfigurationProxy
implements IConfiguration {
    private Configuration target;
    private INamingStrategy namingStrategy;
    private HashSet<ITable> tableMappings = null;
    private HashMap<String, IPersistentClass> classMappings = null;
    private ServiceRegistry serviceRegistry = null;
    private IMapping mapping = null;
    private IDialect dialect = null;

    public ConfigurationProxy(Configuration configuration) {
        this.target = configuration;
    }

    public String getProperty(String propertyName) {
        return this.target.getProperty(propertyName);
    }

    public IConfiguration addFile(File file) {
        this.target.addFile(file);
        return this;
    }

    public void setProperty(String name, String value) {
        this.target.setProperty(name, value);
    }

    public IConfiguration setProperties(Properties properties) {
        this.target.setProperties(properties);
        return this;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.target.setEntityResolver(entityResolver);
    }

    public void setNamingStrategy(INamingStrategy namingStrategy) {
        assert (namingStrategy instanceof NamingStrategyProxy);
        this.namingStrategy = namingStrategy;
        this.target.setNamingStrategy(((NamingStrategyProxy)namingStrategy).getTarget());
    }

    public Properties getProperties() {
        return this.target.getProperties();
    }

    public void addProperties(Properties properties) {
        this.target.addProperties(properties);
    }

    public IConfiguration configure(Document document) {
        this.target.configure(document);
        return this;
    }

    public IConfiguration configure(File file) {
        this.target.configure(file);
        return this;
    }

    public IConfiguration configure() {
        this.target.configure();
        return this;
    }

    public void buildMappings() {
        this.target.buildMappings();
    }

    public ISessionFactory buildSessionFactory() {
        if (this.serviceRegistry == null) {
            this.buildServiceRegistry();
        }
        return new SessionFactoryProxy(this.target.buildSessionFactory(this.serviceRegistry));
    }

    public ISettings buildSettings() {
        if (this.serviceRegistry == null) {
            this.buildServiceRegistry();
        }
        return new SettingsProxy((Settings)this.buildSettings(this.serviceRegistry));
    }

    Configuration getConfiguration() {
        return this.target;
    }

    public IMappings createMappings() {
        return new MappingsProxy(this.target.createMappings());
    }

    public Iterator<IPersistentClass> getClassMappings() {
        if (this.classMappings == null) {
            this.initializeClassMappings();
        }
        return this.classMappings.values().iterator();
    }

    private void initializeClassMappings() {
        this.classMappings = new HashMap();
        Iterator origin = this.target.getClassMappings();
        while (origin.hasNext()) {
            PersistentClassProxy pc = new PersistentClassProxy((PersistentClass)origin.next());
            this.classMappings.put(pc.getEntityName(), pc);
        }
    }

    public void setPreferBasicCompositeIds(boolean preferBasicCompositeids) {
        if (this.target instanceof JDBCMetaDataConfiguration) {
            ((JDBCMetaDataConfiguration)this.target).setPreferBasicCompositeIds(preferBasicCompositeids);
        }
    }

    public void setReverseEngineeringStrategy(IReverseEngineeringStrategy res) {
        assert (res instanceof ReverseEngineeringStrategyProxy);
        if (this.target instanceof JDBCMetaDataConfiguration) {
            ((JDBCMetaDataConfiguration)this.target).setReverseEngineeringStrategy(((ReverseEngineeringStrategyProxy)res).getTarget());
        }
    }

    public void readFromJDBC() {
        if (this.target instanceof JDBCMetaDataConfiguration) {
            ((JDBCMetaDataConfiguration)this.target).readFromJDBC();
        }
    }

    public IMapping buildMapping() {
        Mapping m;
        if (this.mapping == null && (m = this.target.buildMapping()) != null) {
            this.mapping = new MappingProxy(m);
        }
        return this.mapping;
    }

    public IPersistentClass getClassMapping(String string) {
        if (this.classMappings == null) {
            this.initializeClassMappings();
        }
        return this.classMappings.get(string);
    }

    public INamingStrategy getNamingStrategy() {
        if (this.namingStrategy == null) {
            this.namingStrategy = new NamingStrategyProxy(this.target.getNamingStrategy());
        }
        return this.namingStrategy;
    }

    public EntityResolver getEntityResolver() {
        return this.target.getEntityResolver();
    }

    public Object buildSettings(Object serviceRegistry) {
        if (serviceRegistry instanceof ServiceRegistry) {
            return this.target.buildSettings((ServiceRegistry)serviceRegistry);
        }
        throw new RuntimeException("unknown service registry object");
    }

    public Iterator<ITable> getTableMappings() {
        Iterator<ITable> result = null;
        if (this.target instanceof JDBCMetaDataConfiguration) {
            if (this.tableMappings == null) {
                this.initializeTableMappings();
            }
            result = this.tableMappings.iterator();
        }
        return result;
    }

    private void initializeTableMappings() {
        Iterator iterator = ((JDBCMetaDataConfiguration)this.target).getTableMappings();
        while (iterator.hasNext()) {
            this.tableMappings.add(new TableProxy((Table)iterator.next()));
        }
    }

    public IDialect getDialect() {
        DialectFactory dialectFactory;
        Dialect d;
        if (this.dialect != null && (d = (dialectFactory = (DialectFactory)this.serviceRegistry.getService(DialectFactory.class)).buildDialect((Map)this.getProperties(), null)) != null) {
            this.dialect = new DialectProxy(d);
        }
        return this.dialect;
    }

    private void buildServiceRegistry() {
        ServiceRegistryBuilder builder = new ServiceRegistryBuilder();
        builder.applySettings((Map)this.target.getProperties());
        this.serviceRegistry = builder.buildServiceRegistry();
    }
}

