/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import org.hibernate.mapping.Column;
import org.jboss.tools.hibernate.proxy.DialectProxy;
import org.jboss.tools.hibernate.proxy.MappingProxy;
import org.jboss.tools.hibernate.proxy.ValueProxy;
import org.jboss.tools.hibernate.spi.IColumn;
import org.jboss.tools.hibernate.spi.IDialect;
import org.jboss.tools.hibernate.spi.IMapping;
import org.jboss.tools.hibernate.spi.IValue;

public class ColumnProxy
implements IColumn {
    private Column target = null;
    private IValue value = null;

    public ColumnProxy(Object column) {
        this.target = (Column)column;
    }

    public Column getTarget() {
        return this.target;
    }

    public String getName() {
        return this.target.getName();
    }

    public Integer getSqlTypeCode() {
        return this.target.getSqlTypeCode();
    }

    public String getSqlType() {
        return this.target.getSqlType();
    }

    public int getLength() {
        return this.target.getLength();
    }

    public int getDefaultLength() {
        return 255;
    }

    public int getPrecision() {
        return this.target.getPrecision();
    }

    public int getDefaultPrecision() {
        return 19;
    }

    public int getScale() {
        return this.target.getScale();
    }

    public int getDefaultScale() {
        return 2;
    }

    public boolean isNullable() {
        return this.target.isNullable();
    }

    public IValue getValue() {
        if (this.target.getValue() != null && this.value == null) {
            this.value = new ValueProxy(this.target.getValue());
        }
        return this.value;
    }

    public boolean isUnique() {
        return this.target.isUnique();
    }

    public String getSqlType(IDialect dialect, IMapping mapping) {
        assert (dialect instanceof DialectProxy);
        assert (mapping instanceof MappingProxy);
        return this.target.getSqlType(((DialectProxy)dialect).getTarget(), ((MappingProxy)mapping).getTarget());
    }

    public void setSqlType(String sqlType) {
        this.target.setSqlType(sqlType);
    }
}

