/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.ds.model;

import java.io.IOException;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XMLRecognizerContext;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.seam.xml.SeamXMLPlugin;
import org.jboss.tools.seam.xml.ds.model.DSConstants;

public class DSEntityRecognizer
implements EntityRecognizer,
DSConstants {
    static {
        try {
            Class<DSEntityRecognizer> c = DSEntityRecognizer.class;
            XMLEntityResolver.registerPublicEntity((String)"-//JBoss//DTD JBOSS JCA Config 1.5//EN", c, (String)"/meta/jboss-ds_1_5.dtd");
            XMLEntityResolver.registerPublicEntity((String)"-//JBoss//DTD JBOSS JCA Config 5.0//EN", c, (String)"/meta/jboss-ds_5_0.dtd");
        }
        catch (IOException e) {
            SeamXMLPlugin.log(e);
        }
    }

    public String getEntityName(EntityRecognizerContext context) {
        String body = context.getBody();
        if (body == null) {
            return null;
        }
        XMLRecognizerContext xml = context.getXMLContext();
        if (xml.isDTD()) {
            String publicId = xml.getPublicId();
            String root = xml.getRootName();
            if ("-//JBoss//DTD JBOSS JCA Config 1.5//EN".equals(publicId)) {
                if ("datasources".equals(root)) {
                    return "FileDSDatasources";
                }
                if ("connection-factories".equals(root)) {
                    return "FileDSConnectionFactories";
                }
            }
            if ("-//JBoss//DTD JBOSS JCA Config 5.0//EN".equals(publicId)) {
                if ("datasources".equals(root)) {
                    return "FileDSDatasources50d";
                }
                if ("connection-factories".equals(root)) {
                    return "FileDSConnectionFactories50d";
                }
            }
        } else {
            if (this.isDatasourcesSchema(body)) {
                return "FileDSDatasources50s";
            }
            if (this.isConnectionFactoriesSchema(body)) {
                return "FileDSConnectionFactories50s";
            }
        }
        return null;
    }

    private boolean isDatasourcesSchema(String body) {
        int i = body.indexOf("<datasources");
        if (i < 0) {
            return false;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return false;
        }
        String s = body.substring(i, j);
        return s.indexOf("http://www.jboss.org/j2ee/schema/jboss-ds_5_0.xsd") > 0;
    }

    private boolean isConnectionFactoriesSchema(String body) {
        int i = body.indexOf("<connection-factories");
        if (i < 0) {
            return false;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return false;
        }
        String s = body.substring(i, j);
        return s.indexOf("http://www.jboss.org/j2ee/schema/jboss-ds_5_0.xsd") > 0;
    }
}

