/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class TypeResolutionCache {
    private static TypeResolutionCache instance = new TypeResolutionCache();
    static Set<String> primitive = new HashSet<String>();
    static final String NULL = ";;;";
    Map<String, Resolved> resolved = new Hashtable<String, Resolved>();

    static {
        primitive.add("void");
        primitive.add("int");
        primitive.add("char");
        primitive.add("boolean");
        primitive.add("long");
        primitive.add("short");
        primitive.add("double");
        primitive.add("float");
        primitive.add("java.lang.Object");
        primitive.add("java.lang.Number");
        primitive.add("java.lang.Integer");
        primitive.add("java.lang.Character");
        primitive.add("java.lang.Boolean");
        primitive.add("java.lang.Long");
        primitive.add("java.lang.Short");
        primitive.add("java.lang.Double");
        primitive.add("java.lang.Float");
        primitive.add("java.lang.String");
        primitive.add("java.lang.StringBuffer");
        primitive.add("java.lang.Class");
        primitive.add("java.lang.Deprecated");
        primitive.add("java.lang.SuppressWarnings");
        primitive.add("java.lang.Throwable");
        primitive.add("java.lang.Exception");
        primitive.add("java.lang.RuntimeException");
        primitive.add("java.lang.Override");
    }

    public static TypeResolutionCache getInstance() {
        return instance;
    }

    private TypeResolutionCache() {
    }

    public String resolveType(IType type, String typeName) {
        if (type == null) {
            return null;
        }
        if (type.isBinary() || typeName == null || primitive.contains(typeName)) {
            return typeName;
        }
        String n = this.getKey(type);
        Resolved r = this.resolved.get(n);
        if (r == null) {
            r = new Resolved(type);
            this.resolved.put(n, r);
        } else if (r.type != type) {
            r.setType(type);
        }
        String result = r.types.get(typeName);
        if (result != null) {
            return result == NULL ? null : result;
        }
        result = r.resolveInImports(typeName);
        if (result != null) {
            return result;
        }
        result = this.__resolveType(type, typeName);
        r.types.put(typeName, result == null ? NULL : result);
        return result;
    }

    public void clean() {
        this.resolved = new Hashtable<String, Resolved>();
        EclipseJavaUtil.typeCache = new Hashtable<String, Map<String, IType>>();
    }

    private String __resolveType(IType type, String typeName) {
        try {
            String[][] resolvedArray = type.resolveType(typeName);
            if (resolvedArray == null) {
                return typeName;
            }
            typeName = "";
            int i = 0;
            while (i < resolvedArray[0].length) {
                typeName = String.valueOf(typeName) + (!"".equals(typeName) ? "." : "") + resolvedArray[0][i];
                ++i;
            }
            return typeName;
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getPluginLog().logError(e);
        }
        catch (IllegalArgumentException e) {
            CommonCorePlugin.getPluginLog().logError(e);
        }
        return null;
    }

    private String getKey(IType type) {
        String n = type.getFullyQualifiedName();
        IJavaProject jp = type.getJavaProject();
        if (jp == null) {
            return n;
        }
        IProject p = jp.getProject();
        if (p == null || !p.isAccessible()) {
            return n;
        }
        return String.valueOf(p.getName()) + ":" + n;
    }

    static class Resolved {
        IType type;
        Map<String, String> types = new Hashtable<String, String>();
        List<String> classImports = new ArrayList<String>();
        List<String> packageImports = new ArrayList<String>();

        Resolved(IType type) {
            this.type = type;
            this.readImports();
        }

        void setType(IType type) {
            this.type = type;
            this.types.clear();
            this.readImports();
        }

        void readImports() {
            ICompilationUnit unit = this.type.getCompilationUnit();
            if (unit == null) {
                return;
            }
            IImportDeclaration[] ds = null;
            try {
                ds = unit.getImports();
            }
            catch (JavaModelException e) {
                CommonCorePlugin.getDefault().logError(e);
                ds = new IImportDeclaration[]{};
            }
            try {
                IType[] ts;
                IType[] iTypeArray = ts = this.type.getTypes();
                int n = ts.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    this.types.put(t.getElementName(), t.getFullyQualifiedName('.'));
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                CommonCorePlugin.getDefault().logError(e);
            }
            IResource r = unit.getResource();
            if (r instanceof IFile && r.exists()) {
                ArrayList<String> newClassImports = new ArrayList<String>();
                ArrayList<String> newPackageImports = new ArrayList<String>();
                newPackageImports.add(String.valueOf(this.type.getPackageFragment().getElementName()) + ".");
                IImportDeclaration[] iImportDeclarationArray = ds;
                int n = ds.length;
                int n3 = 0;
                while (n3 < n) {
                    IImportDeclaration d = iImportDeclarationArray[n3];
                    String q = d.getElementName();
                    if (q.endsWith(".*")) {
                        q = q.substring(0, q.length() - 1);
                        newPackageImports.add(q);
                    } else {
                        newClassImports.add(q);
                    }
                    ++n3;
                }
                this.classImports = newClassImports;
                this.packageImports = newPackageImports;
            }
        }

        public String resolveInImports(String typeName) {
            String baseTypeName = typeName;
            int g = baseTypeName.indexOf("<");
            if (g > 0) {
                baseTypeName = baseTypeName.substring(0, g);
            }
            if (typeName.indexOf(".") >= 0) {
                try {
                    IType q = EclipseJavaUtil.findType(this.type.getJavaProject(), baseTypeName);
                    if (q != null) {
                        this.types.put(typeName, baseTypeName);
                        return baseTypeName;
                    }
                }
                catch (JavaModelException e) {
                    CommonCorePlugin.getDefault().logError(e);
                }
                return null;
            }
            for (String imp : this.classImports) {
                if (!imp.endsWith("." + baseTypeName)) continue;
                this.types.put(typeName, imp);
                return imp;
            }
            for (String imp : this.packageImports) {
                String result = String.valueOf(imp) + baseTypeName;
                try {
                    IType q = EclipseJavaUtil.findType(this.type.getJavaProject(), result);
                    if (q == null) continue;
                    this.types.put(typeName, result);
                    return result;
                }
                catch (JavaModelException e) {
                    CommonCorePlugin.getDefault().logError(e);
                }
            }
            String pr = "java.lang." + typeName;
            if (primitive.contains(pr)) {
                this.types.put(typeName, pr);
                return pr;
            }
            if (this.type.getTypeParameter(typeName).exists()) {
                this.types.put(typeName, typeName);
                return typeName;
            }
            return null;
        }
    }
}

