/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.libprov;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.Repository;
import org.eclipse.m2e.model.edit.pom.RepositoryPolicy;
import org.eclipse.m2e.model.edit.pom.util.PomResourceFactoryImpl;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.libprov.MavenLibraryProviderInstallOperationConfig;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class MavenLibraryProviderInstallOperation
extends LibraryProviderOperation {
    public void execute(LibraryProviderOperationConfig config, IProgressMonitor monitor) throws CoreException {
        IFacetedProjectBase facetedProject = config.getFacetedProject();
        IProject project = facetedProject.getProject();
        IFile pom = project.getFile("pom.xml");
        MavenLibraryProviderInstallOperationConfig mavenConfig = (MavenLibraryProviderInstallOperationConfig)config;
        if (mavenConfig.getModel() == null) {
            return;
        }
        if (pom.exists()) {
            Model libraryModel;
            block8: {
                PomResourceImpl resource = MavenLibraryProviderInstallOperation.loadResource(pom);
                Model projectModel = resource.getModel();
                libraryModel = mavenConfig.getModel();
                try {
                    try {
                        MavenCoreActivator.mergeModel(projectModel, libraryModel);
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        resource.save(options);
                    }
                    catch (IOException e) {
                        MavenCoreActivator.log(e);
                        resource.unload();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    resource.unload();
                    throw throwable;
                }
                resource.unload();
            }
            ILibraryProvider provider = config.getLibraryProvider();
            File providerFile = MavenCoreActivator.getProviderFile(provider);
            this.savePomModel(providerFile, libraryModel);
        } else {
            MavenCoreActivator.addLibraryProviderOperationConfig(config);
        }
    }

    private void savePomModel(File file, Model pomModel) throws CoreException {
        org.apache.maven.model.Model model = new org.apache.maven.model.Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(pomModel.getArtifactId());
        model.setArtifactId(pomModel.getArtifactId());
        model.setVersion(pomModel.getVersion());
        model.setPackaging(pomModel.getPackaging());
        if (pomModel.getName() != null && pomModel.getName().length() > 0) {
            model.setName(pomModel.getName());
        }
        if (pomModel.getDescription() != null && pomModel.getDescription().length() > 0) {
            model.setDescription(pomModel.getDescription());
        }
        if (pomModel.getDependencyManagement() != null && pomModel.getDependencyManagement().isSetDependencies()) {
            model.setDependencyManagement(new DependencyManagement());
            model.getDependencyManagement().setDependencies(this.convertDependencies((EList<Dependency>)pomModel.getDependencyManagement().getDependencies()));
        }
        model.setDependencies(this.convertDependencies((EList<Dependency>)pomModel.getDependencies()));
        EList pomRepositories = pomModel.getRepositories();
        List repositories = model.getRepositories();
        for (Repository pomRepository : pomRepositories) {
            org.apache.maven.model.Repository repository = new org.apache.maven.model.Repository();
            repository.setId(pomRepository.getId());
            repository.setLayout(pomRepository.getLayout());
            repository.setName(pomRepository.getName());
            RepositoryPolicy pomReleases = pomRepository.getReleases();
            repository.setReleases(this.getRepositoryPolicy(pomReleases));
            RepositoryPolicy pomSnapshots = pomRepository.getSnapshots();
            repository.setSnapshots(this.getRepositoryPolicy(pomSnapshots));
            repository.setLayout(pomRepository.getLayout());
            repository.setUrl(pomRepository.getUrl());
            repositories.add(repository);
        }
        this.createMavenModel(file, model);
    }

    private List<org.apache.maven.model.Dependency> convertDependencies(EList<Dependency> pomDependencies) {
        ArrayList<org.apache.maven.model.Dependency> dependencies = new ArrayList<org.apache.maven.model.Dependency>(pomDependencies.size());
        for (Dependency pomDependency : pomDependencies) {
            org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
            dependency.setArtifactId(pomDependency.getArtifactId());
            dependency.setGroupId(pomDependency.getGroupId());
            dependency.setVersion(pomDependency.getVersion());
            dependency.setType(pomDependency.getType());
            dependency.setScope(pomDependency.getScope());
            dependency.setClassifier(pomDependency.getClassifier());
            dependency.setOptional(pomDependency.getOptional());
            dependency.setSystemPath(pomDependency.getSystemPath());
            EList pomExclusions = pomDependency.getExclusions();
            List exclusions = dependency.getExclusions();
            for (org.eclipse.m2e.model.edit.pom.Exclusion pomExclusion : pomExclusions) {
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(pomExclusion.getGroupId());
                exclusion.setArtifactId(pomExclusion.getArtifactId());
                exclusions.add(exclusion);
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public void createMavenModel(File file, org.apache.maven.model.Model model) throws CoreException {
        try {
            Attr attr;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            MavenImpl maven = MavenPluginActivator.getDefault().getMaven();
            maven.writeModel(model, (OutputStream)buf);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(buf.toByteArray()));
            Element documentElement = document.getDocumentElement();
            NamedNodeMap attributes = documentElement.getAttributes();
            if (attributes == null || attributes.getNamedItem("xmlns") == null) {
                attr = document.createAttribute("xmlns");
                attr.setTextContent("http://maven.apache.org/POM/4.0.0");
                documentElement.setAttributeNode(attr);
            }
            if (attributes == null || attributes.getNamedItem("xmlns:xsi") == null) {
                attr = document.createAttribute("xmlns:xsi");
                attr.setTextContent("http://www.w3.org/2001/XMLSchema-instance");
                documentElement.setAttributeNode(attr);
            }
            if (attributes == null || attributes.getNamedItem("xsi:schemaLocation") == null) {
                attr = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
                attr.setTextContent("http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
                documentElement.setAttributeNode(attr);
            }
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            buf.reset();
            trans.transform(new DOMSource(document), new StreamResult(buf));
            FileOutputStream os = null;
            InputStream is = null;
            try {
                try {
                    os = new FileOutputStream(file);
                    is = new ByteArrayInputStream(buf.toByteArray());
                    MavenCoreActivator.copy(is, os);
                }
                catch (Exception e) {
                    MavenCoreActivator.log(e);
                    throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.core", -1, e.getMessage(), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
        }
        catch (RuntimeException ex) {
            String msg = "Can't create model " + file.getAbsolutePath();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.core", -1, msg, (Throwable)ex));
        }
        catch (Exception ex) {
            String msg = "Can't create model " + file.getAbsolutePath();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.core", -1, msg, (Throwable)ex));
        }
    }

    private org.apache.maven.model.RepositoryPolicy getRepositoryPolicy(RepositoryPolicy pomRepositoryPolicy) {
        if (pomRepositoryPolicy == null) {
            return null;
        }
        org.apache.maven.model.RepositoryPolicy repositoryPolicy = new org.apache.maven.model.RepositoryPolicy();
        repositoryPolicy.setChecksumPolicy(pomRepositoryPolicy.getChecksumPolicy());
        repositoryPolicy.setEnabled(pomRepositoryPolicy.getEnabled());
        repositoryPolicy.setUpdatePolicy(pomRepositoryPolicy.getUpdatePolicy());
        return repositoryPolicy;
    }

    public static PomResourceImpl loadResource(IFile pomFile) throws CoreException {
        String path = pomFile.getFullPath().toOSString();
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        try {
            Resource resource = new PomResourceFactoryImpl().createResource(uri);
            resource.load(new HashMap());
            return (PomResourceImpl)resource;
        }
        catch (Exception ex) {
            String msg = "Can't load model " + pomFile;
            MavenCoreActivator.log(ex);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.maven.core", -1, msg, (Throwable)ex));
        }
    }
}

