/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.internal.project.facet;

import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.Messages;
import org.jboss.tools.maven.core.ProjectUtil;
import org.jboss.tools.maven.core.libprov.MavenLibraryProviderInstallOperation;

public class MavenFacetInstallDelegate
implements IDelegate {
    private static final String SEAM_FACET_ID = "jst.seam";

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        IDataModel config = null;
        if (cfg == null) {
            throw new CoreException(MavenCoreActivator.getStatus(Messages.MavenFacetInstallDelegate_Internal_Error_creating_JBoss_Maven_Facet));
        }
        config = (IDataModel)cfg;
        IFile pom = project.getFile("pom.xml");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFacetedProjectWorkingCopy fpwc = null;
        try {
            IClasspathAttribute attribute;
            fpwc = (IFacetedProjectWorkingCopy)config.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            if (!pom.exists()) {
                IProjectFacetVersion earFacetVersion;
                IProjectFacetVersion ejbFacetVersion;
                IProjectFacetVersion webFacetVersion;
                Model model = new Model();
                model.setModelVersion("4.0.0");
                model.setGroupId(config.getStringProperty("groupId"));
                String artifactId = config.getStringProperty("artifactId");
                model.setArtifactId(artifactId);
                model.setVersion(config.getStringProperty("version"));
                model.setName(config.getStringProperty("name"));
                String packaging = config.getStringProperty("packaging");
                model.setPackaging(packaging);
                String description = config.getStringProperty("description");
                if (description != null && description.trim().length() > 0) {
                    model.setDescription(description);
                }
                Build build = new Build();
                model.setBuild(build);
                if (fpwc.hasProjectFacet(JavaFacet.FACET)) {
                    String sourceDirectory = MavenCoreActivator.getSourceDirectory(javaProject);
                    if (sourceDirectory != null && !"${basedir}/src/main/java".equals(sourceDirectory)) {
                        build.setSourceDirectory(sourceDirectory);
                    }
                    MavenCoreActivator.addResource(build, project, sourceDirectory);
                }
                if ((webFacetVersion = fpwc.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET)) != null && "war".equals(packaging)) {
                    MavenCoreActivator.addMavenWarPlugin(build, project, webFacetVersion);
                }
                if ((ejbFacetVersion = fpwc.getProjectFacetVersion(IJ2EEFacetConstants.EJB_FACET)) != null && "ejb".equals(packaging)) {
                    MavenCoreActivator.addMavenEjbPlugin(build, project, ejbFacetVersion);
                }
                if ((earFacetVersion = fpwc.getProjectFacetVersion(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) != null && "ear".equals(packaging)) {
                    MavenCoreActivator.addMavenEarPlugin(build, project, config, null, earFacetVersion, false);
                    MavenCoreActivator.createMavenProject(project.getName(), monitor, model, true);
                }
                IProjectFacet seamFacet = null;
                if (ProjectFacetsManager.isProjectFacetDefined((String)SEAM_FACET_ID)) {
                    seamFacet = ProjectFacetsManager.getProjectFacet((String)SEAM_FACET_ID);
                }
                if (!("pom".equals(packaging) || seamFacet != null && fpwc.hasProjectFacet(seamFacet))) {
                    MavenCoreActivator.addCompilerPlugin(build.getPlugins(), project);
                }
                if (!pom.exists()) {
                    MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
                    modelManager.createMavenModel(pom, model);
                }
            }
            MavenCoreActivator.addMavenNature(project, monitor);
            if (fpwc.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
                attribute = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
                MavenCoreActivator.addClasspathAttribute(javaProject, attribute, monitor);
            }
            attribute = JavaCore.newClasspathAttribute((String)"owner.project.facets", (String)"jboss.m2");
            MavenCoreActivator.addClasspathAttribute(javaProject, attribute, monitor);
            List<LibraryProviderOperationConfig> configs = MavenCoreActivator.getLibraryProviderOperationConfigs();
            if (configs.size() > 0) {
                MavenLibraryProviderInstallOperation operation = new MavenLibraryProviderInstallOperation();
                for (LibraryProviderOperationConfig libraryProviderOperationConfig : configs) {
                    operation.execute(libraryProviderOperationConfig, monitor);
                }
                configs.clear();
            }
            ProjectUtil.removeWTPContainers(config, project);
        }
        finally {
            if (fpwc != null) {
                fpwc.dispose();
            }
        }
    }
}

