/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.internal.identification;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.jboss.tools.maven.core.identification.ArtifactIdentifier;
import org.jboss.tools.maven.core.identification.IFileIdentificationManager;
import org.jboss.tools.maven.core.internal.identification.MavenCentralIdentifier;
import org.jboss.tools.maven.core.internal.identification.MavenPropertiesIdentifier;
import org.jboss.tools.maven.core.internal.identification.NexusIndexIdentifier;
import org.jboss.tools.maven.core.internal.identification.NexusRepositoryIdentifier;

public class FileIdentificationManager
implements IFileIdentificationManager {
    private List<ArtifactIdentifier> artifactIdentifiers;

    public FileIdentificationManager() {
        this.initArtifactIdentifiers();
    }

    public FileIdentificationManager(Collection<ArtifactIdentifier> identifiers) {
        for (ArtifactIdentifier identifier : identifiers) {
            this.addArtifactIdentifier(identifier);
        }
    }

    protected void initArtifactIdentifiers() {
        this.addArtifactIdentifier(new MavenPropertiesIdentifier());
        this.addArtifactIdentifier(new NexusIndexIdentifier());
        this.addArtifactIdentifier(new NexusRepositoryIdentifier());
        this.addArtifactIdentifier(new MavenCentralIdentifier());
    }

    public synchronized void addArtifactIdentifier(ArtifactIdentifier identifier) {
        Assert.isNotNull((Object)identifier, (String)"Artifact identifier can not be null");
        if (this.artifactIdentifiers == null) {
            this.artifactIdentifiers = new ArrayList<ArtifactIdentifier>();
        }
        this.artifactIdentifiers.add(identifier);
    }

    public synchronized void removeArtifactIdentifier(ArtifactIdentifier identifier) {
        if (identifier != null) {
            this.getArtifactIdentifiers().remove(identifier);
        }
    }

    protected List<ArtifactIdentifier> getArtifactIdentifiers() {
        if (this.artifactIdentifiers == null) {
            this.initArtifactIdentifiers();
        }
        return this.artifactIdentifiers;
    }

    @Override
    public ArtifactKey identify(File file, IProgressMonitor monitor) throws CoreException {
        if (file == null || !file.exists()) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArtifactKey artifactKey = null;
        for (ArtifactIdentifier identifier : this.artifactIdentifiers) {
            if (monitor.isCanceled()) {
                return null;
            }
            artifactKey = identifier.identify(file, monitor);
            if (artifactKey != null) break;
        }
        return artifactKey;
    }
}

