/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenGoalSelectionDialog
extends ElementTreeSelectionDialog {
    private static final Logger log = LoggerFactory.getLogger(MavenGoalSelectionDialog.class);
    Button isQualifiedNameButton;
    boolean isQualifiedName = true;

    public MavenGoalSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new GoalsLabelProvider(), (ITreeContentProvider)new GoalsContentProvider());
        this.setTitle(Messages.launchGoalsDialogTitle);
        this.setMessage(Messages.MavenGoalSelectionDialog_message);
        this.setValidator(new GoalsSelectionValidator());
        this.setInput(new Object());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label selectGoalLabel = new Label(composite, 0);
        selectGoalLabel.setText(Messages.MavenGoalSelectionDialog_lblSelect);
        final GoalsFilter filter = new GoalsFilter();
        final Text filterText = new Text(composite, 2048);
        GridData gd_filterText = new GridData(4, 0x1000000, true, false);
        gd_filterText.widthHint = 200;
        filterText.setLayoutData((Object)gd_filterText);
        filterText.setFocus();
        final TreeViewer treeViewer = this.createTreeViewer(composite);
        treeViewer.addFilter((ViewerFilter)filter);
        GridData data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 400;
        final Tree tree = treeViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = filterText.getText();
                filter.setFilter(text);
                treeViewer.refresh();
                if (text.trim().length() == 0) {
                    treeViewer.collapseAll();
                } else {
                    treeViewer.expandAll();
                }
            }
        });
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    tree.setFocus();
                    tree.setSelection(tree.getTopItem().getItem(0));
                    Object[] elements = ((ITreeContentProvider)treeViewer.getContentProvider()).getElements(null);
                    treeViewer.setSelection((ISelection)new StructuredSelection(elements[0]));
                }
            }
        });
        this.isQualifiedNameButton = new Button(composite, 32);
        this.isQualifiedNameButton.setText(Messages.MavenGoalSelectionDialog_btnQualified);
        this.isQualifiedNameButton.setSelection(true);
        this.isQualifiedNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenGoalSelectionDialog.this.isQualifiedName = MavenGoalSelectionDialog.this.isQualifiedNameButton.getSelection();
            }
        });
        return composite;
    }

    public boolean isQualifiedName() {
        return this.isQualifiedName;
    }

    public static class Entry {
        public final String prefix;
        public final String name;
        private final IndexedArtifactFile f;

        public Entry(String name, String prefix, IndexedArtifactFile f) {
            this.prefix = prefix;
            this.name = name;
            this.f = f;
        }

        public String getName() {
            return this.prefix == null ? this.name : String.valueOf(this.prefix) + ":" + this.name;
        }

        public String getQualifiedName() {
            return this.prefix == null ? this.name : String.valueOf(this.f.group) + ":" + this.f.artifact + ":" + this.f.version + ":" + this.name;
        }
    }

    static class GoalsContentProvider
    implements ITreeContentProvider {
        private static Object[] EMPTY = new Object[0];
        private final List<Group> groups = new ArrayList<Group>();

        public GoalsContentProvider() {
            IndexManager indexManager = MavenPlugin.getIndexManager();
            try {
                Map result = indexManager.getAllIndexes().search(null, "plugin");
                TreeMap<String, Group> map = new TreeMap<String, Group>();
                for (IndexedArtifact a : result.values()) {
                    IndexedArtifactFile f = (IndexedArtifactFile)a.getFiles().iterator().next();
                    if (f.prefix == null || f.prefix.length() <= 0 || f.goals == null) continue;
                    ArrayList<Entry> goals = new ArrayList<Entry>();
                    for (String goal : f.goals) {
                        if (goal.length() <= 0) continue;
                        goals.add(new Entry(goal, f.prefix, f));
                    }
                    if (goals.size() <= 0) continue;
                    map.put(String.valueOf(f.prefix) + ":" + f.group, new Group(f.prefix, f.group, f.artifact, goals));
                }
                this.groups.addAll(map.values());
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        private List<Entry> getLifecyclePhases(List<?> phases) {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            int i = 0;
            while (i < phases.size()) {
                entries.add(new Entry((String)phases.get(i), null, null));
                ++i;
            }
            return entries;
        }

        public Object[] getElements(Object inputElement) {
            return this.groups.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof Group) {
                return ((Group)parent).entries.toArray();
            }
            return EMPTY;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Group;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    static class GoalsFilter
    extends ViewerFilter {
        private String filter;

        GoalsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.filter == null || this.filter.trim().length() == 0) {
                return true;
            }
            if (element instanceof Group) {
                Group g = (Group)element;
                if (g.name.indexOf(this.filter) > -1) {
                    return true;
                }
                for (Entry e : g.entries) {
                    if (e.name.indexOf(this.filter) <= -1) continue;
                    return true;
                }
            } else if (element instanceof Entry) {
                Entry e = (Entry)element;
                return e.name.indexOf(this.filter) > -1 || e.prefix != null && e.prefix.indexOf(this.filter) > -1;
            }
            return false;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }
    }

    static class GoalsLabelProvider
    extends LabelProvider {
        GoalsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Group) {
                Group g = (Group)element;
                if (g.groupId == null) {
                    return g.name;
                }
                return String.valueOf(g.name) + " - " + g.groupId + ":" + g.artifactId;
            }
            if (element instanceof Entry) {
                return ((Entry)element).name;
            }
            return super.getText(element);
        }
    }

    static class GoalsSelectionValidator
    implements ISelectionStatusValidator {
        GoalsSelectionValidator() {
        }

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenGoalSelectionDialog_error, null);
            }
            int j = 0;
            while (j < selection.length) {
                if (!(selection[j] instanceof Entry)) {
                    return new Status(4, "org.eclipse.m2e.core", -1, "", null);
                }
                ++j;
            }
            return Status.OK_STATUS;
        }
    }

    static class Group {
        public final String name;
        public final String groupId;
        public final String artifactId;
        public final List<Entry> entries;

        public Group(String name, String groupId, String artifactId, List<Entry> entries) {
            this.name = name;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.entries = entries;
        }
    }
}

