/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.eclipse.callbacks;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.browsersim.eclipse.Messages;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessCallback;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.TransparentReader;

public class OpenFileCallback
implements ExternalProcessCallback {
    private static final String OPEN_FILE_COMMAND = "org.jboss.tools.vpe.browsersim.command.openFile:";

    @Override
    public String getCallbackId() {
        return OPEN_FILE_COMMAND;
    }

    @Override
    public void call(final String lastString, TransparentReader reader) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String stringToParse = lastString;
                String fileNameToOpen = (stringToParse = stringToParse.trim()).substring(OpenFileCallback.OPEN_FILE_COMMAND.length());
                File fileToOpen = new File(fileNameToOpen);
                if (fileToOpen.exists() && fileToOpen.isFile()) {
                    IWorkbenchPage page;
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
                    if (page != null) {
                        try {
                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        }
                        catch (PartInitException e) {
                            Activator.logError(e.getMessage(), e);
                        }
                    } else {
                        Exception e = new Exception(Messages.Callback_CANNOT_OBTAIN_PAGE);
                        Activator.logError(e.getMessage(), e);
                    }
                } else {
                    FileNotFoundException e = new FileNotFoundException(MessageFormat.format(Messages.OpenFileCallback_CANNOT_OPEN_FILE, fileNameToOpen));
                    Activator.logError(e.getMessage(), e);
                }
            }
        });
    }
}

