/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.properties.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.foundation.core.FoundationCorePlugin;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;
import org.jboss.tools.foundation.core.properties.internal.SimpleHierarchicalVersion;
import org.jboss.tools.foundation.core.properties.internal.VersionExtractor;

public class VersionPropertiesProvider
implements IPropertiesProvider,
IExecutableExtension {
    public static String VERSION_PROPERTIES_URI_KEY = "org.jboss.tools.foundation.core.config.properties.url";
    private static String DEFAULT_PROPERTIES_FILE = "ide-config.properties";
    private static String DEFAULT_PROPERTIES_URI = "http://download.jboss.org/jbosstools/configuration/" + DEFAULT_PROPERTIES_FILE;
    private static final long DEFAULT_TIMEOUT = 5000L;
    private volatile Properties volatileProperties;
    private String currentVersion = null;
    private URI propertiesURI;
    private String context;
    private String id;

    public VersionPropertiesProvider() {
        this((String)null, (String)null, (String)null);
    }

    VersionPropertiesProvider(String propertiesURI, String projectContext, String version) {
        this.initPropertiesUri(propertiesURI);
        this.context = projectContext;
        this.id = String.valueOf(this.context) + ".properties.provider";
        this.currentVersion = version;
    }

    VersionPropertiesProvider(Properties properties, String projectContext, String version) {
        this((String)null, projectContext, version);
        this.volatileProperties = properties;
    }

    protected String getCurrentVersion() {
        if (this.currentVersion == null) {
            this.currentVersion = VersionExtractor.getVersion(this.getVersionBundleName(), this.getClass().getClassLoader());
        }
        return this.currentVersion;
    }

    protected String getVersionBundleName() {
        return "org.jboss.tools.foundation.core.properties.internal.currentversion";
    }

    protected String getContext() {
        return this.context;
    }

    public String getId() {
        return this.id;
    }

    protected void initPropertiesUri(String propertiesURI) {
        try {
            this.propertiesURI = propertiesURI == null ? new URI(System.getProperty(VERSION_PROPERTIES_URI_KEY, DEFAULT_PROPERTIES_URI)) : new URI(propertiesURI);
        }
        catch (URISyntaxException e) {
            FoundationCorePlugin.pluginLog().logError("Invalid URI format (" + propertiesURI + ") for " + VERSION_PROPERTIES_URI_KEY + ". Falling back on " + DEFAULT_PROPERTIES_URI, e);
            this.propertiesURI = URI.create(DEFAULT_PROPERTIES_URI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(String key, String defaultValue) {
        String value;
        if (key == null) {
            return defaultValue;
        }
        Properties properties = this.volatileProperties;
        if (properties == null) {
            VersionPropertiesProvider versionPropertiesProvider = this;
            synchronized (versionPropertiesProvider) {
                properties = this.volatileProperties;
                if (properties == null) {
                    try {
                        properties = VersionPropertiesProvider.loadProperties(this.propertiesURI, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        FoundationCorePlugin.pluginLog().logError("Unable to load properties from " + this.propertiesURI + ". Falling back on embedded properties", e);
                    }
                    if (properties == null || properties.isEmpty()) {
                        properties = this.loadDefaultProperties();
                    }
                    String resolvedPropsAsString = this.dump(properties);
                    System.setProperty("org.jboss.tools.resolved.remote.properties", resolvedPropsAsString);
                    this.volatileProperties = properties;
                }
            }
        }
        return (value = VersionPropertiesProvider.lookupValue(key, this.getContext(), this.getCurrentVersion(), properties)) == null ? defaultValue : value;
    }

    String dump(Properties props) {
        if (props == null || props.isEmpty()) {
            return "!!Empty properties!!";
        }
        StringBuilder output = new StringBuilder();
        String crlf = System.getProperty("line.separator");
        HashSet<String> baseKeys = new HashSet<String>();
        for (Object key : props.keySet()) {
            baseKeys.add(key.toString().split("\\|")[0]);
        }
        SimpleHierarchicalVersion version = new SimpleHierarchicalVersion(this.getCurrentVersion());
        for (String key : baseKeys) {
            String matchingKey = VersionPropertiesProvider.lookupKey(key, this.getContext(), version, props);
            if (matchingKey == null) continue;
            output.append(matchingKey).append("=").append(props.getProperty(matchingKey)).append(crlf);
        }
        return output.toString();
    }

    protected Properties loadDefaultProperties() {
        try {
            return VersionPropertiesProvider.getProperties(VersionPropertiesProvider.class.getResourceAsStream(DEFAULT_PROPERTIES_FILE));
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(DEFAULT_PROPERTIES_FILE) + " can't be loaded from the org.jboss.tools.foundation.core plugin", e);
        }
    }

    @Override
    public String getValue(String key) {
        return this.getValue(key, null);
    }

    static String lookupValue(String key, String context, String version, Properties properties) {
        String originalKey = VersionPropertiesProvider.getFullKey(key, context, version);
        SimpleHierarchicalVersion v = new SimpleHierarchicalVersion(version);
        boolean proceed = true;
        String value = null;
        while (proceed) {
            String newKey = VersionPropertiesProvider.getFullKey(key, context, v == null ? null : v.toString());
            value = properties.getProperty(newKey);
            if (value != null) {
                if (!originalKey.equals(newKey)) {
                    properties.put(originalKey, value);
                }
                return value;
            }
            if (v == null) {
                proceed = false;
                continue;
            }
            v = v.getParentVersion();
        }
        value = properties.getProperty(key);
        if (value != null) {
            properties.put(originalKey, value);
        }
        return value;
    }

    private static String getFullKey(String key, String context, String version) {
        StringBuilder k = new StringBuilder(key);
        k.append("|").append(context);
        if (version != null && !version.isEmpty()) {
            k.append("|").append(version);
        }
        return k.toString();
    }

    static Properties loadProperties(URI propertiesURI, IProgressMonitor monitor) throws CoreException {
        if (propertiesURI == null) {
            throw new IllegalArgumentException("properties URL can not be null");
        }
        Object subMonitor = monitor == null ? new NullProgressMonitor() : new SubProgressMonitor(monitor, 1);
        URLTransportUtility transport = new URLTransportUtility();
        File propFile = transport.getCachedFileForURL(propertiesURI.toString(), "Loading IDE properties", 1, 5000, 5000L, (IProgressMonitor)subMonitor);
        if (propFile == null || !propFile.canRead() || propFile.length() == 0L) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.foundation.core", "Unable to retrieve properties from " + propertiesURI));
        }
        try {
            return VersionPropertiesProvider.getProperties(new FileInputStream(propFile));
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.foundation.core", "Unable to read properties from " + propertiesURI));
        }
    }

    private static Properties getProperties(InputStream is) throws IOException {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        finally {
            VersionPropertiesProvider.closeQuietly(is);
        }
        return props;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.context = config.getAttribute("context");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        String curVer = this.getCurrentVersion();
        result = 31 * result + (curVer == null ? 0 : curVer.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionPropertiesProvider other = (VersionPropertiesProvider)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        String curVer = this.getCurrentVersion();
        String otherVer = other.getCurrentVersion();
        if (curVer == null ? otherVer != null : !this.currentVersion.equals(otherVer)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "VersionPropertiesProvider [ id=" + this.id + ", propertiesURI=" + this.propertiesURI + ", context=" + this.getContext() + ", currentVersion=" + this.getCurrentVersion() + "]";
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String lookupKey(String key, String context, SimpleHierarchicalVersion version, Properties properties) {
        String value = null;
        String newKey = null;
        SimpleHierarchicalVersion v = version;
        boolean proceed = true;
        while (proceed) {
            newKey = VersionPropertiesProvider.getFullKey(key, context, v == null ? null : v.toString());
            value = properties.getProperty(newKey);
            if (value != null) {
                return newKey;
            }
            if (v == null) {
                proceed = false;
                continue;
            }
            v = v.getParentVersion();
        }
        value = properties.getProperty(key);
        if (value != null) {
            return key;
        }
        return null;
    }
}

