/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.eclipse.ide.internal.core.Trace;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.ITernScriptResource;
import tern.scriptpath.impl.AbstractTernScriptPath;
import tern.scriptpath.impl.JSFileScriptResource;

public class FolderScriptPath
extends AbstractTernScriptPath {
    private IContainer container;

    public FolderScriptPath(ITernProject project, IContainer container, String external) {
        super(project, ITernScriptPath.ScriptPathsType.FOLDER, external);
        this.container = container;
    }

    public List<ITernScriptResource> getScriptResources() {
        ScriptResourceProxyVisitor visitor = new ScriptResourceProxyVisitor();
        try {
            if (this.container.exists()) {
                this.container.accept((IResourceProxyVisitor)visitor, 0);
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while retrieving script resources from the folder script path " + this.container.getName(), e);
        }
        return visitor.resources;
    }

    public String getLabel() {
        StringBuilder text = new StringBuilder(this.container.getName()).append(" - ").append(this.container.getFullPath().makeRelative().toString());
        if (this.getExternalLabel() != null) {
            text.append(" (").append(this.getExternalLabel()).append(")");
        }
        return text.toString();
    }

    public String getPath() {
        return this.container.getProjectRelativePath().toString();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IContainer.class || clazz == IResource.class || clazz == IFolder.class) {
            return this.container;
        }
        if (clazz == IProject.class && this.container instanceof IProject) {
            return this.container;
        }
        return null;
    }

    public int hashCode() {
        return super.hashCode() * 17 + this.container.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FolderScriptPath) {
            return super.equals(obj) && this.container.equals((Object)((FolderScriptPath)((Object)obj)).container);
        }
        return false;
    }

    private class ScriptResourceProxyVisitor
    implements IResourceProxyVisitor {
        public List<ITernScriptResource> resources = new ArrayList<ITernScriptResource>();

        private ScriptResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            int type = proxy.getType();
            switch (type) {
                case 2: 
                case 4: {
                    return true;
                }
                case 1: {
                    IResource resource;
                    ITernFile file;
                    String filename = proxy.getName();
                    if (!TernResourcesManager.isJSFile((Object)filename) || (file = TernResourcesManager.getTernFile((Object)(resource = proxy.requestResource()))) == null) break;
                    this.resources.add((ITernScriptResource)new JSFileScriptResource(FolderScriptPath.this.getOwnerProject(), file));
                }
            }
            return false;
        }
    }
}

