/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.resources.IDETernProject;
import tern.eclipse.ide.internal.core.resources.RefreshTernProjectJob;

public class IDETernProjectSynchronizer
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static final IDETernProjectSynchronizer INSTANCE = new IDETernProjectSynchronizer();

    public static IDETernProjectSynchronizer getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    if (resource != null && resource.getType() == 4) {
                        IProject project = (IProject)resource;
                        this.disposeTernProject(project);
                    }
                    break;
                }
                case 1: {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) break;
                    delta.accept((IResourceDeltaVisitor)this);
                }
                default: {
                    break;
                }
            }
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "Error while tern file synchronization", e);
        }
    }

    private void disposeTernProject(IProject project) throws CoreException {
        IDETernProject ternProject = IDETernProject.getTernProject(project);
        if (ternProject != null) {
            ternProject.dispose();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                IProject project = (IProject)resource;
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        return false;
                    }
                }
                return IDETernProject.hasTernNature(project);
            }
            case 2: {
                return true;
            }
            case 1: {
                IDETernProject ternProject = IDETernProject.getTernProject(resource.getProject());
                if (ternProject == null) {
                    return false;
                }
                if (this.isTernProjectFile(resource)) {
                    switch (delta.getKind()) {
                        case 4: {
                            RefreshTernProjectJob configJob = new RefreshTernProjectJob(ternProject);
                            configJob.setRule((ISchedulingRule)ternProject.getProject().getWorkspace().getRoot());
                            configJob.schedule();
                            break;
                        }
                        case 2: {
                            ternProject.dispose();
                        }
                    }
                } else {
                    ternProject.getFileSynchronizer().refresh((Object)resource);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isTernProjectFile(IResource resource) {
        if (!".tern-project".equals(resource.getName())) {
            return false;
        }
        return resource.getParent() != null && resource.getParent().getType() == 4;
    }
}

