/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernConsoleConnector;
import tern.eclipse.ide.core.ITernProjectLifecycleListener;
import tern.eclipse.ide.core.ITernServerPreferencesListener;
import tern.eclipse.ide.core.ITernServerType;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.core.TernConsoleConnectorManager;
import tern.eclipse.ide.internal.core.TernNatureAdaptersManager;
import tern.eclipse.ide.internal.core.TernProjectLifecycleManager;
import tern.eclipse.ide.internal.core.TernRepositoryManager;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.builder.TernBuilder;
import tern.eclipse.ide.internal.core.preferences.TernCorePreferencesSupport;
import tern.eclipse.ide.internal.core.resources.IDETernFileUploader;
import tern.eclipse.ide.internal.core.resources.IDETernServerAsyncReqProcessor;
import tern.eclipse.ide.internal.core.scriptpath.FolderScriptPath;
import tern.repository.ITernRepository;
import tern.resources.TernFileSynchronizer;
import tern.resources.TernProject;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.impl.JSFileScriptPath;
import tern.scriptpath.impl.ProjectScriptPath;
import tern.scriptpath.impl.dom.DOMElementsScriptPath;
import tern.server.ITernModule;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.ITernServerRequestProcessor;
import tern.server.TernServerAdapter;
import tern.server.protocol.JsonHelper;
import tern.utils.IOUtils;
import tern.utils.TernModuleHelper;

public class IDETernProject
extends TernProject
implements IIDETernProject,
ITernServerPreferencesListener {
    private static final QualifiedName TERN_PROJECT = new QualifiedName("tern.eclipse.ide.core.sessionprops", "TernProject");
    private static final String PATH_JSON_FIELD = "path";
    private static final String TYPE_JSON_FIELD = "type";
    private static final String SCRIPT_PATHS_JSON_FIELD = "scriptPaths";
    private static final String IDE_JSON_FIELD = "ide";
    private static final long serialVersionUID = 1L;
    private final IProject project;
    private ITernServer ternServer;
    private Object serverLock = new Object();
    private final List<ITernScriptPath> scriptPaths;
    private final Map<String, Object> data;
    private final List<ITernServerListener> listeners;

    IDETernProject(IProject project) throws CoreException {
        super(project.getLocation().toFile());
        this.project = project;
        this.scriptPaths = new ArrayList<ITernScriptPath>();
        this.data = new HashMap<String, Object>();
        this.listeners = new ArrayList<ITernServerListener>();
        TernCorePlugin.getTernServerTypeManager().addServerPreferencesListener(this);
        project.setSessionProperty(TERN_PROJECT, (Object)this);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.project.getName();
    }

    public File getProjectDir() {
        return this.project.getLocation().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITernServer getTernServer() {
        Object object = this.serverLock;
        synchronized (object) {
            if (this.isServerDisposed()) {
                try {
                    ITernServerType type = TernCorePreferencesSupport.getInstance().getServerType();
                    this.ternServer = type.createServer(this);
                    this.ternServer.setLoadingLocalPlugins(TernCorePreferencesSupport.getInstance().isLoadingLocalPlugins(this.project));
                    this.ternServer.addServerListener((ITernServerListener)new TernServerAdapter(){

                        public void onStop(ITernServer server) {
                            IDETernProject.this.getFileSynchronizer().cleanIndexedFiles();
                        }
                    });
                    if (!TernCorePreferencesSupport.getInstance().isDisableAsynchronousReques(this.project)) {
                        this.ternServer.setRequestProcessor((ITernServerRequestProcessor)new IDETernServerAsyncReqProcessor(this.ternServer));
                    }
                    this.copyListeners();
                    this.configureConsole();
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error while creating tern server", e);
                }
            }
            return this.ternServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServerDisposed() {
        Object object = this.serverLock;
        synchronized (object) {
            return this.ternServer == null || this.ternServer.isDisposed();
        }
    }

    public static boolean hasTernNature(IProject project) {
        return TernNatureAdaptersManager.getManager().hasTernNature(project);
    }

    protected void doLoad() throws IOException {
        try {
            this.disposeServer();
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onLoadBefore);
            super.doLoad();
            try {
                TernBuilder.addTernBuilder(this.project);
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error while adding tern builder", e);
            }
            this.loadIDEInfos();
            this.initAdaptedNaturesInfos();
        }
        finally {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onLoadAfter);
        }
    }

    private void loadIDEInfos() {
        JsonArray jsonScripts;
        this.scriptPaths.clear();
        JsonObject ide = (JsonObject)super.get(IDE_JSON_FIELD);
        if (ide != null && (jsonScripts = (JsonArray)ide.get(SCRIPT_PATHS_JSON_FIELD)) != null) {
            JsonObject jsonScript = null;
            String type = null;
            String path = null;
            for (Object object : jsonScripts) {
                IResource resource;
                jsonScript = (JsonObject)object;
                type = JsonHelper.getString((JsonObject)jsonScript, (String)TYPE_JSON_FIELD);
                path = JsonHelper.getString((JsonObject)jsonScript, (String)PATH_JSON_FIELD);
                if (type == null || path == null) continue;
                ITernScriptPath.ScriptPathsType pathType = ITernScriptPath.ScriptPathsType.getType((String)type);
                if (pathType == null) {
                    pathType = ITernScriptPath.ScriptPathsType.FILE;
                }
                if (pathType == null || (resource = this.getResource(path, pathType)) == null || !resource.exists()) continue;
                this.scriptPaths.add(this.createScriptPath(resource, pathType));
            }
        }
    }

    private void initAdaptedNaturesInfos() {
        try {
            TernNatureAdaptersManager.getManager().addDefaultModules(this);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while configuring default tern project modules", e);
            return;
        }
        try {
            this.save();
        }
        catch (IOException e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
    }

    private IResource getResource(String path, ITernScriptPath.ScriptPathsType pathType) {
        switch (pathType) {
            case FILE: {
                return this.getProject().getFile(path);
            }
            case FOLDER: {
                return this.getProject().getFolder(path);
            }
            case PROJECT: {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(path);
            }
        }
        throw new UnsupportedOperationException("Cannot retrieve resource from the type=" + pathType + " of the path=" + path);
    }

    @Override
    public IFile getIDEFile(String name) {
        ITernFile tf = this.getFile(name);
        if (tf != null) {
            return (IFile)tf.getAdapter(IFile.class);
        }
        return null;
    }

    protected void doSave() throws IOException {
        block11: {
            try {
                TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onSaveBefore);
                this.saveIDEInfos();
                if (!this.isDirty()) break block11;
                IFile file = this.project.getFile(".tern-project");
                InputStream content = null;
                try {
                    try {
                        content = IOUtils.toInputStream((String)super.toString(), (String)(file.exists() ? file.getCharset() : "UTF-8"));
                        if (!file.exists()) {
                            file.create(content, 0, null);
                        } else {
                            file.setContents(content, true, false, null);
                        }
                    }
                    catch (CoreException e) {
                        throw new IOException("Cannot save .tern-project", e);
                    }
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        IOUtils.closeQuietly(content);
                    }
                    throw throwable;
                }
                if (content != null) {
                    IOUtils.closeQuietly((InputStream)content);
                }
                this.disposeServer();
            }
            finally {
                TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onSaveAfter);
            }
        }
    }

    public void handleException(Throwable t) {
        Trace.trace((byte)3, t.getMessage(), t);
    }

    private void saveIDEInfos() {
        JsonObject ide = new JsonObject();
        if (this.scriptPaths.size() > 0) {
            JsonArray jsonScripts = new JsonArray();
            for (ITernScriptPath scriptPath : this.scriptPaths) {
                if (scriptPath.isExternal()) continue;
                JsonObject jsonScript = new JsonObject();
                jsonScript.add(TYPE_JSON_FIELD, scriptPath.getType().name());
                jsonScript.add(PATH_JSON_FIELD, scriptPath.getPath());
                jsonScripts.add((JsonValue)jsonScript);
            }
            ide.add(SCRIPT_PATHS_JSON_FIELD, (JsonValue)jsonScripts);
        }
        super.set(IDE_JSON_FIELD, (JsonValue)ide);
    }

    public List<ITernScriptPath> getScriptPaths() {
        return this.scriptPaths;
    }

    @Override
    public ITernScriptPath createScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type) {
        return this.createScriptPath(resource, type, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ITernScriptPath createScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type, String external) {
        switch (type) {
            case FOLDER: {
                return new FolderScriptPath(this, (IContainer)((IFolder)resource), external);
            }
            case FILE: {
                ITernFile file = this.getFile(resource);
                if (file == null) throw new UnsupportedOperationException("Cannot create script path for the given type " + type);
                if (!TernResourcesManager.isJSFile((Object)file)) return new DOMElementsScriptPath((ITernProject)this, file, external);
                return new JSFileScriptPath((ITernProject)this, file, external);
            }
            case PROJECT: {
                try {
                    IIDETernProject project = TernCorePlugin.getTernProject((IProject)resource);
                    if (project == null) throw new UnsupportedOperationException("Cannot create script path for the given type " + type);
                    return new ProjectScriptPath((ITernProject)project, (ITernProject)this, external);
                }
                catch (CoreException e) {
                    Trace.trace((byte)3, "Project " + resource.getName() + " is not a Tern project", e);
                }
            }
        }
        throw new UnsupportedOperationException("Cannot create script path for the given type " + type);
    }

    @Override
    public void setScriptPaths(List<ITernScriptPath> scriptPaths) throws IOException {
        this.scriptPaths.clear();
        this.scriptPaths.addAll(scriptPaths);
        this.save();
    }

    @Override
    public ITernScriptPath addExternalScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type, String external) throws IOException {
        ITernScriptPath path = this.createScriptPath(resource, type, external);
        this.scriptPaths.add(path);
        return path;
    }

    @Override
    public void removeExternalScriptPaths(String external) {
        ArrayList<ITernScriptPath> initialScriptPaths = new ArrayList<ITernScriptPath>(this.scriptPaths);
        for (ITernScriptPath scriptPath : initialScriptPaths) {
            if (!external.equals(scriptPath.getExternalLabel())) continue;
            this.scriptPaths.remove(scriptPath);
        }
    }

    public Object getAdapter(Class adapterClass) {
        if (adapterClass == IProject.class || adapterClass == IContainer.class || adapterClass == IResource.class) {
            return this.project;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object value) {
        if (value instanceof IDETernProject) {
            return ((IDETernProject)value).getProject().equals((Object)this.getProject());
        }
        return super.equals(value);
    }

    @Override
    public ITernScriptPath getScriptPath(String path) {
        for (ITernScriptPath scriptPath : this.scriptPaths) {
            if (!scriptPath.getPath().equals(path)) continue;
            return scriptPath;
        }
        return null;
    }

    public boolean isTraceOnConsole() {
        return TernCorePreferencesSupport.getInstance().isTraceOnConsole(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureConsole() {
        Object object = this.serverLock;
        synchronized (object) {
            ITernConsoleConnector connector;
            if (this.ternServer != null && (connector = TernConsoleConnectorManager.getManager().getConnector(this.ternServer)) != null) {
                if (this.isTraceOnConsole()) {
                    connector.connectToConsole(this.ternServer, this);
                } else {
                    connector.disconnectToConsole(this.ternServer, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeServer() {
        Object object = this.serverLock;
        synchronized (object) {
            if (!this.isServerDisposed() && this.ternServer != null) {
                ((IDETernFileUploader)((TernFileSynchronizer)this.getFileSynchronizer()).getTernFileUploader()).serverToBeDisposed();
                this.ternServer.dispose();
                this.ternServer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getData(String key) {
        Map<String, Object> map = this.data;
        synchronized (map) {
            return (T)this.data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String key, Object value) {
        Map<String, Object> map = this.data;
        synchronized (map) {
            this.data.put(key, value);
        }
    }

    @Override
    public void serverPreferencesChanged(IProject project) {
        if (project == null || this.getProject().equals((Object)project)) {
            this.disposeServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        this.copyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerListener(ITernServerListener listener) {
        Object object = this.listeners;
        synchronized (object) {
            this.listeners.remove(listener);
        }
        object = this.serverLock;
        synchronized (object) {
            if (this.ternServer != null) {
                this.ternServer.removeServerListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyListeners() {
        Object object = this.serverLock;
        synchronized (object) {
            if (this.ternServer != null) {
                for (ITernServerListener listener : this.listeners) {
                    this.ternServer.addServerListener(listener);
                }
            }
        }
    }

    @Override
    public List<ITernModule> getProjectModules() {
        final ArrayList<ITernModule> modules = new ArrayList<ITernModule>();
        if (this.project.isAccessible() && TernCorePreferencesSupport.getInstance().isLoadingLocalPlugins(this.project)) {
            try {
                this.project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        switch (resource.getType()) {
                            case 4: {
                                return true;
                            }
                            case 1: {
                                ITernModule module = TernModuleHelper.getModule((String)resource.getName());
                                if (module != null) {
                                    modules.add(module);
                                }
                                return false;
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error while collecting tern plugin from the project root", e);
            }
        }
        return modules;
    }

    public ITernRepository getRepository() {
        return TernRepositoryManager.getManager().getRepository(this.getProject());
    }

    public void dispose() throws CoreException {
        try {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onDisposeBefore);
            this.disposeServer();
            this.getFileSynchronizer().dispose();
            if (this.project.isAccessible()) {
                this.project.setSessionProperty(TERN_PROJECT, null);
            }
        }
        finally {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onDisposeAfter);
        }
    }

    protected static IDETernProject getTernProject(IProject project) throws CoreException {
        return (IDETernProject)project.getSessionProperty(TERN_PROJECT);
    }
}

