/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.StringButtonComboFieldEditor;

public class FileComboFieldEditor
extends StringButtonComboFieldEditor {
    private String[] extensions = null;
    private File filterPath = null;
    private boolean enforceAbsolute = false;

    protected FileComboFieldEditor(String[] items) {
        super(items);
    }

    public FileComboFieldEditor(String name, String labelText, String[] items, Composite parent) {
        this(name, labelText, false, items, parent);
    }

    public FileComboFieldEditor(String name, String labelText, boolean enforceAbsolute, String[] items, Composite parent) {
        this(name, labelText, enforceAbsolute, 1, items, parent);
    }

    public FileComboFieldEditor(String name, String labelText, boolean enforceAbsolute, int validationStrategy, String[] items, Composite parent) {
        super(items);
        this.init(name, labelText);
        this.enforceAbsolute = enforceAbsolute;
        this.setErrorMessage(JFaceResources.getString((String)"FileFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(validationStrategy);
        this.createControl(parent);
    }

    @Override
    protected String changePressed() {
        File d;
        File f = new File(this.getTextControl().getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getFile(f)) == null) {
            return null;
        }
        return d.getAbsolutePath();
    }

    @Override
    protected boolean checkState() {
        String msg = null;
        String path = this.getTextControl().getText();
        path = path != null ? path.trim() : "";
        if (path.length() == 0) {
            if (!this.isEmptyStringAllowed()) {
                msg = this.getErrorMessage();
            }
        } else if (!path.equals("node")) {
            File file = new File(path);
            if (file.isFile()) {
                if (this.enforceAbsolute && !file.isAbsolute()) {
                    msg = JFaceResources.getString((String)"FileFieldEditor.errorMessage2");
                }
            } else {
                msg = this.getErrorMessage();
            }
        }
        if (msg != null) {
            this.showErrorMessage(msg);
            return false;
        }
        if (this.doCheckState()) {
            this.clearErrorMessage();
            return true;
        }
        msg = this.getErrorMessage();
        if (msg != null) {
            this.showErrorMessage(msg);
        }
        return false;
    }

    private File getFile(File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        } else if (this.filterPath != null) {
            dialog.setFilterPath(this.filterPath.getPath());
        }
        if (this.extensions != null) {
            dialog.setFilterExtensions(this.extensions);
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public void setFileExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public void setFilterPath(File path) {
        this.filterPath = path;
    }
}

