/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.helpers.LibrarySets;
import org.jboss.tools.jst.web.project.version.ProjectVersions;

public class AddVersionSupport
extends SpecialWizardSupport {
    ProjectVersions versions;
    String defaultLocation;
    protected DefaultWizardDataValidator validator = new ProjectVersionValidator();
    String FORBIDDEN_INDICES = "\"\n\t*\\/:<>?|";

    public static String run(ProjectVersions versions, String entity) {
        XModel model = PreferenceModelUtilities.getPreferenceModel();
        String actionPath = "CreateActions.CreateProjectVersion";
        Properties p = new Properties();
        p.put("versions", versions);
        XActionInvoker.invoke((String)entity, (String)actionPath, (XModelObject)model.getRoot(), (Properties)p);
        return p.getProperty("name");
    }

    public void reset() {
        this.versions = (ProjectVersions)this.getProperties().get("versions");
        this.setLists();
        this.setDefaultLocation();
    }

    void setLists() {
        String[] s = LibrarySets.getInstance().getLibrarySetList();
        this.setValueList(0, "core library", s);
    }

    void setDefaultLocation() {
        String location = this.defaultLocation = this.versions.getPath();
        this.setAttributeValue(0, "templates location", location);
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    protected void execute() throws XModelException {
        String name = this.extractStepData(0).getProperty("name");
        this.versions.addVersion(this.extractStepData(0));
        this.getProperties().setProperty("name", name);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    class ProjectVersionValidator
    extends DefaultWizardDataValidator {
        ProjectVersionValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty("name");
            if (AddVersionSupport.this.versions.getVersion(name) != null) {
                this.message = NLS.bind((String)WebUIMessages.IMPLEMENTATION_ALREADY_EXISTS, (Object)name);
                return;
            }
        }
    }
}

