/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.jst.web.tld.IWebProject;
import org.jboss.tools.jst.web.tld.TLDVersionHelper;
import org.jboss.tools.jst.web.tld.TaglibMapping;

public class WebProject
implements IWebProject {
    private XModel model;
    private TaglibMapping taglibs;
    private String webRoot;
    public static final String JSF_NATURE_ID = "org.jboss.tools.jsf.jsfnature";

    public static WebProject getInstance(XModel model) {
        WebProject instance = (WebProject)model.getManager("WebProject");
        if (instance == null) {
            instance = new WebProject();
            instance.model = model;
            instance.taglibs = new TaglibMapping(model);
            model.addManager("WebProject", (Object)instance);
        }
        instance.update();
        return instance;
    }

    public XModel getModel() {
        return this.model;
    }

    @Override
    public String getWebRootLocation() {
        if (this.webRoot != null) {
            return this.webRoot;
        }
        XModelObject fs = FileSystemsHelper.getWebRoot((XModel)this.model);
        if (fs == null) {
            XModelObject m = this.model.getByPath("Web");
            fs = m == null ? null : FileSystemsHelper.getFileSystem((XModel)this.model, (String)m.getAttributeValue("root file system"));
        }
        return !(fs instanceof FileSystemImpl) ? null : ((FileSystemImpl)fs).getAbsoluteLocation();
    }

    public String getWebInfLocation() {
        XModelObject fs = FileSystemsHelper.getWebInf((XModel)this.model);
        return fs == null || !(fs instanceof FileSystemImpl) ? String.valueOf(this.getWebRootLocation()) + "/WEB-INF" : ((FileSystemImpl)fs).getAbsoluteLocation();
    }

    public String getAbsoluteLocation(String uri, String base) {
        String location;
        if (uri.startsWith("/")) {
            if (uri.startsWith("/WEB-INF/")) {
                return String.valueOf(this.getWebInfLocation().replace('\\', '/')) + uri.substring(8);
            }
            return String.valueOf(this.getWebRootLocation().replace('\\', '/')) + uri;
        }
        if (uri.indexOf(":/") > 1) {
            return uri;
        }
        int ind = -1;
        if (base != null) {
            base = base.replace('\\', '/');
            ind = base.lastIndexOf(47);
        }
        String string = location = ind >= 0 ? String.valueOf(base.substring(0, ind + 1)) + uri : uri;
        if (!new File(location).isAbsolute()) {
            location = String.valueOf(this.getWebRootLocation()) + "/" + location;
        }
        return location.replace('\\', '/');
    }

    @Override
    public TaglibMapping getTaglibMapping() {
        return this.taglibs;
    }

    public void update() {
    }

    public void setWebRootLocation(String webRoot) {
        this.webRoot = webRoot;
    }

    @Override
    public String getPathInWebRoot(XModelObject file) {
        String webRoot = this.getWebRootLocation().replace('\\', '/');
        if (!webRoot.endsWith("/")) {
            webRoot = String.valueOf(webRoot) + "/";
        }
        if (file == null || !file.isActive()) {
            return null;
        }
        String path = null;
        if (!(file instanceof FileAnyImpl)) {
            IResource r = (IResource)file.getAdapter(IResource.class);
            if (r == null || r.getLocation() == null) {
                return null;
            }
            path = String.valueOf(r.getLocation().toString().replace('\\', '/')) + "/";
        } else {
            path = ((FileAnyImpl)file).getAbsolutePath();
        }
        if (path == null) {
            return null;
        }
        if (!path.toLowerCase().startsWith(webRoot.toLowerCase())) {
            return null;
        }
        return path.substring(webRoot.length() - 1);
    }

    public static String getTldVersion(String uri, String prefix, IDocument document, XModel xm) {
        XModelObject xmo;
        String version = TLDVersionHelper.getTldVersion(uri, prefix, document);
        if (version == null && xm != null && (xmo = WebProject.getInstance(xm).getTaglibMapping().getTaglibObject(uri)) != null) {
            version = xmo.getAttributeValue("tlibversion");
        }
        return version;
    }
}

