/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.web.WebUtils;

public class InnerModelHelper {
    public static XModel createXModel(IProject project) {
        IModelNature n = EclipseResourceUtil.getModelNature((IProject)project.getProject());
        if (n != null) {
            return n.getModel();
        }
        XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)project.getProject());
        if (o == null) {
            return null;
        }
        XModel model = o.getModel();
        XModelObject webinf = model.getByPath("FileSystems/WEB-INF");
        if (webinf != null) {
            return model;
        }
        IPath webInfPath = InnerModelHelper.getWebInfPath(project);
        if (webInfPath == null) {
            return model;
        }
        IFolder webInfFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(webInfPath);
        model.getProperties().setProperty(XModelConstants.WORKSPACE, webInfFolder.getLocation().toString());
        model.getProperties().setProperty(XModelConstants.WORKSPACE_OLD, webInfFolder.getLocation().toString());
        XModelObject fs = model.getByPath("FileSystems");
        webinf = model.createModelObject("FileSystemFolder", null);
        webinf.setAttributeValue("name", "WEB-INF");
        webinf.setAttributeValue("location", XModelConstants.WORKSPACE_REF);
        fs.addChild(webinf);
        String webInfLocation = XModelObjectUtil.expand((String)XModelConstants.WORKSPACE_REF, (XModel)model, null);
        String webRootLocation = InnerModelHelper.getWebRootPath(project, webInfLocation);
        XModelObject webroot = model.createModelObject("FileSystemFolder", null);
        webroot.setAttributeValue("name", "WEB-ROOT");
        webroot.setAttributeValue("location", webRootLocation);
        fs.addChild(webroot);
        if (webInfFolder.getFolder("lib").exists()) {
            XModelObject lib = model.createModelObject("FileSystemFolder", null);
            lib.setAttributeValue("name", "lib");
            lib.setAttributeValue("location", String.valueOf(XModelConstants.WORKSPACE_REF) + "/lib");
            fs.addChild(lib);
        }
        return model;
    }

    public static IPath getWebInfPath(IProject project) {
        IContainer[] cs;
        IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders((IProject)project, (boolean)true);
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder f;
            IContainer c = iContainerArray[n2];
            if (c.exists() && (f = c.getFolder((IPath)new Path("WEB-INF"))).exists()) {
                return f.getFullPath();
            }
            ++n2;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        IVirtualFolder webInfDir = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF"));
        IPath modulePath = webInfDir.getWorkspaceRelativePath();
        return !webInfDir.exists() ? null : modulePath;
    }

    public static IPath getFirstWebContentPath(IProject project) {
        IContainer[] cs;
        IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders((IProject)project, (boolean)true);
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            if (c.exists()) {
                return c.getFullPath();
            }
            ++n2;
        }
        return null;
    }

    static String getWebRootPath(IProject project, String webInfLocation) {
        IPath p;
        String webRootLocation = String.valueOf(XModelConstants.WORKSPACE_REF) + "/..";
        IPath wrp = InnerModelHelper.getFirstWebContentPath(project);
        IPath wip = InnerModelHelper.getWebInfPath(project);
        if (wrp == null || wip == null) {
            return webRootLocation;
        }
        IResource wrpc = ResourcesPlugin.getWorkspace().getRoot().findMember(wrp);
        IResource wipc = ResourcesPlugin.getWorkspace().getRoot().findMember(wip);
        if (wrpc != null && wipc != null && wipc.isLinked() && (p = wrpc.getLocation()) != null) {
            try {
                webRootLocation = p.toFile().getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {}
            String relative = FileUtil.getRelativePath((String)webInfLocation, (String)webRootLocation);
            if (relative != null) {
                webRootLocation = String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
            }
        }
        return webRootLocation;
    }
}

