/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.internal.util.XMLUtil;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.CordovaPluginXMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlistConfigFileAction
implements IPluginInstallationAction {
    private final File target;
    private final String key;
    private final String xml;

    public PlistConfigFileAction(File target, String parent, String xml) {
        this.target = target;
        this.key = parent;
        this.xml = xml;
    }

    public String[] filesToOverwrite() {
        return new String[0];
    }

    public void install() throws CoreException {
        try {
            NSObject valueObject = this.getValueObject();
            NSDictionary dict = (NSDictionary)PropertyListParser.parse((File)this.target);
            if (dict.containsKey(this.key)) {
                NSObject existingObj = dict.get((Object)this.key);
                if (existingObj instanceof NSArray && valueObject instanceof NSArray) {
                    NSArray existingArray = (NSArray)existingObj;
                    NSArray valueArray = (NSArray)valueObject;
                    valueObject = this.concatArrays(existingArray, valueArray);
                }
                if (existingObj instanceof NSDictionary && valueObject instanceof NSDictionary) {
                    NSDictionary existingDict = (NSDictionary)existingObj;
                    NSDictionary valueDict = (NSDictionary)valueObject;
                    valueDict.putAll((Map)existingDict);
                }
            }
            dict.put(this.key, valueObject);
            PropertyListParser.saveAsXML((NSObject)dict, (File)this.target);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error updating plist file", (Throwable)e));
        }
    }

    public void unInstall() throws CoreException {
        try {
            NSDictionary dict = (NSDictionary)PropertyListParser.parse((File)this.target);
            if (dict.containsKey(this.key)) {
                NSObject valueObject = this.getValueObject();
                NSObject existingObj = dict.get((Object)this.key);
                if (existingObj instanceof NSArray && valueObject instanceof NSArray) {
                    NSArray existingArray = (NSArray)existingObj;
                    NSArray valueArray = (NSArray)valueObject;
                    int i = 0;
                    while (i < valueArray.count()) {
                        int removeIndex = existingArray.indexOfObject(valueArray.objectAtIndex(i));
                        if (removeIndex > 0) {
                            existingArray.remove(removeIndex);
                        }
                        ++i;
                    }
                    if (existingArray.count() == 0) {
                        dict.remove(this.key);
                    }
                } else if (existingObj instanceof NSDictionary && valueObject instanceof NSDictionary) {
                    String[] keysToRemove;
                    NSDictionary existingDict = (NSDictionary)existingObj;
                    NSDictionary valueDict = (NSDictionary)valueObject;
                    String[] stringArray = keysToRemove = valueDict.allKeys();
                    int n = keysToRemove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        existingDict.remove(key);
                        ++n2;
                    }
                } else {
                    dict.remove(this.key);
                }
                PropertyListParser.saveAsXML((NSObject)dict, (File)this.target);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error updating plist file", (Throwable)e));
        }
    }

    private NSObject getValueObject() throws Exception {
        Document newNode = XMLUtil.loadXML((String)this.xml);
        NodeList childNodes = newNode.getDocumentElement().getChildNodes();
        Element insertNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1) {
                insertNode = (Element)childNodes.item(i);
            }
            ++i;
        }
        if (insertNode == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error updating plist file"));
        }
        String value = "<plist>" + CordovaPluginXMLHelper.stringifyNode(insertNode) + "</plist>";
        return PropertyListParser.parse((byte[])value.getBytes());
    }

    private NSArray concatArrays(NSArray array1, NSArray array2) {
        NSObject[] theArray2;
        ArrayList<NSObject> concatList = new ArrayList<NSObject>();
        NSObject[] theArray1 = array1.getArray();
        concatList.addAll(Arrays.asList(theArray1));
        NSObject[] nSObjectArray = theArray2 = array2.getArray();
        int n = theArray2.length;
        int n2 = 0;
        while (n2 < n) {
            NSObject nsObject = nSObjectArray[n2];
            if (!concatList.contains(nsObject)) {
                concatList.add(nsObject);
            }
            ++n2;
        }
        NSObject[] theConcatArray = concatList.toArray(new NSObject[concatList.size()]);
        return new NSArray(theConcatArray);
    }
}

