/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.wizard;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.console.ConnectionProfileUtil;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.util.xpl.StringHelper;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.ui.HibernateJptUIPlugin;
import org.jboss.tools.hibernate.jpt.ui.wizard.Messages;
import org.jboss.tools.hibernate.spi.ServiceLookup;

public abstract class GenerateInitWizardPage
extends WizardPage {
    private static final String AUTODETECT = Messages.GenerateInitWizardPage_autodetect;
    private DriverClassHelpers helper = new DriverClassHelpers();
    private StringButtonDialogField outputdir;
    private ComboDialogField hibernateVersion;
    private ComboDialogField connectionProfileName;
    private StringButtonDialogField schemaName;
    private ComboDialogField consoleConfigurationName;
    private ComboDialogField dialectName;
    private Button useConsoleConfiguration;
    private Group dbGroup;
    private HibernateJpaProject jpaProject;
    protected int numColumns = 3;
    protected IDialogFieldListener fieldlistener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            GenerateInitWizardPage.this.dialogChanged();
        }
    };

    public GenerateInitWizardPage(HibernateJpaProject jpaProject) {
        super("", Messages.GenerateInitWizardPage_title, null);
        this.jpaProject = jpaProject;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = this.numColumns;
        layout.verticalSpacing = 10;
        this.outputdir = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                IPath[] paths = DialogSelectionHelper.chooseFolderEntries((Shell)GenerateInitWizardPage.this.getShell(), (IPath)PathHelper.pathOrNull((String)GenerateInitWizardPage.this.outputdir.getText()), (String)HibernateConsoleMessages.CodeGenerationSettingsTab_select_output_dir, (String)HibernateConsoleMessages.CodeGenerationSettingsTab_choose_dir_for_generated_files, (boolean)false);
                if (paths != null && paths.length == 1) {
                    GenerateInitWizardPage.this.outputdir.setText(paths[0].toOSString());
                }
            }
        });
        this.outputdir.setText(this.getDefaultOutput());
        this.outputdir.setDialogFieldListener(this.fieldlistener);
        this.outputdir.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_output_dir);
        this.outputdir.setButtonLabel(HibernateConsoleMessages.CodeGenerationSettingsTab_browse);
        Control[] controls = this.outputdir.doFillIntoGrid(container, this.numColumns);
        ((GridData)controls[1].getLayoutData()).grabExcessHorizontalSpace = true;
        this.setPageComplete(!StringHelper.isEmpty((String)this.getOutputDir()));
        this.createChildControls(container);
        this.useConsoleConfiguration = new Button(container, 32);
        this.useConsoleConfiguration.setText(Messages.GenerateInitWizardPage_use_console_configuration);
        this.useConsoleConfiguration.setSelection(true);
        this.useConsoleConfiguration.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GenerateInitWizardPage.this.consoleConfigurationName.setEnabled(GenerateInitWizardPage.this.useConsoleConfiguration.getSelection());
                GenerateInitWizardPage.this.hibernateVersion.setEnabled(!GenerateInitWizardPage.this.useConsoleConfiguration.getSelection());
                GenerateInitWizardPage.this.connectionProfileName.setEnabled(!GenerateInitWizardPage.this.useConsoleConfiguration.getSelection());
                GenerateInitWizardPage.this.schemaName.setEnabled(!GenerateInitWizardPage.this.useConsoleConfiguration.getSelection());
                GenerateInitWizardPage.this.dialectName.setEnabled(!GenerateInitWizardPage.this.useConsoleConfiguration.getSelection());
                GenerateInitWizardPage.this.dialogChanged();
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.numColumns;
        this.useConsoleConfiguration.setLayoutData((Object)gd);
        this.consoleConfigurationName = new ComboDialogField(8);
        this.consoleConfigurationName.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_console_configuration);
        ConsoleConfiguration[] cfg = LaunchHelper.findFilteredSortedConsoleConfigs();
        String[] names = new String[cfg.length];
        int i = 0;
        while (i < cfg.length) {
            ConsoleConfiguration configuration = cfg[i];
            names[i] = configuration.getName();
            ++i;
        }
        this.consoleConfigurationName.setItems(names);
        this.consoleConfigurationName.setText(this.jpaProject.getDefaultConsoleConfigurationName());
        this.consoleConfigurationName.setDialogFieldListener(this.fieldlistener);
        this.consoleConfigurationName.doFillIntoGrid(container, this.numColumns);
        this.hibernateVersion = new ComboDialogField(8);
        this.hibernateVersion.setLabelText(HibernateConsoleMessages.ConsoleConfigurationMainTab_0);
        this.hibernateVersion.setItems(ServiceLookup.getVersions());
        this.hibernateVersion.selectItem(0);
        this.hibernateVersion.setDialogFieldListener(this.fieldlistener);
        this.hibernateVersion.doFillIntoGrid(container, this.numColumns);
        this.hibernateVersion.setEnabled(false);
        this.createDBGroup(container, this.numColumns);
        this.setControl((Control)container);
        if (StringHelper.isEmpty((String)this.consoleConfigurationName.getText())) {
            this.setPageComplete(false);
        }
    }

    protected abstract void createChildControls(Composite var1);

    private void createDBGroup(Composite container, int numColumns) {
        this.dbGroup = new Group(container, 4);
        this.dbGroup.setLayout((Layout)new FillLayout());
        GridLayout layout = new GridLayout();
        this.dbGroup.setLayout((Layout)layout);
        layout.numColumns = numColumns;
        layout.verticalSpacing = 10;
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.dbGroup.setLayoutData((Object)gd);
        this.dbGroup.setText(Messages.GenerateInitWizardPage_databaseSettings);
        this.connectionProfileName = new ComboDialogField(8);
        this.connectionProfileName.setLabelText(Messages.GenerateInitWizardPage_databaseSettings_connection);
        this.connectionProfileName.setItems(this.dtpConnectionProfileNames());
        String connectionName = this.getProjectConnectionProfileName();
        if (!this.isEmpty(connectionName)) {
            this.connectionProfileName.selectItem(connectionName);
        }
        this.connectionProfileName.doFillIntoGrid((Composite)this.dbGroup, numColumns);
        this.connectionProfileName.setDialogFieldListener(this.fieldlistener);
        this.connectionProfileName.setEnabled(!this.useConsoleConfiguration.getSelection());
        this.dialectName = new ComboDialogField(0);
        this.dialectName.setLabelText(HibernateConsoleMessages.NewConfigurationWizardPage_database_dialect);
        this.dialectName.setItems(this.getDialectNames());
        this.dialectName.selectItem(0);
        this.dialectName.doFillIntoGrid((Composite)this.dbGroup, numColumns);
        this.dialectName.setEnabled(false);
        this.dialectName.setDialogFieldListener(this.fieldlistener);
        this.schemaName = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
            }
        });
        this.schemaName.setLabelText(Messages.GenerateInitWizardPage_databaseShema);
        this.schemaName.setButtonLabel(Messages.GenerateInitWizardPage_refresh);
        Control[] controls = this.schemaName.doFillIntoGrid((Composite)this.dbGroup, numColumns);
        ((GridData)controls[1].getLayoutData()).grabExcessHorizontalSpace = true;
        this.schemaName.setEnabled(!this.useConsoleConfiguration.getSelection());
    }

    protected boolean isUseConsoleConfiguration() {
        return this.useConsoleConfiguration.getSelection();
    }

    protected String getHibernateVersion() {
        return this.hibernateVersion.getText();
    }

    protected void dialogChanged() {
        String msg = PathHelper.checkDirectory((String)this.getOutputDir(), (String)HibernateConsoleMessages.CodeGenerationSettingsTab_output_directory, (boolean)false);
        if (msg != null) {
            this.setErrorMessage(msg);
            this.setPageComplete(false);
            return;
        }
        if (this.useConsoleConfiguration.getSelection() && StringHelper.isEmpty((String)this.getConfigurationName())) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.GenerateInitWizardPage_err_msg_select_console_configuration);
            return;
        }
        if (!this.useConsoleConfiguration.getSelection() && StringHelper.isEmpty((String)this.getConnectionProfileName())) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.GenerateInitWizardPage_err_msg_select_connection_profile);
            return;
        }
        this.setPageComplete(true);
    }

    public String getOutputDir() {
        return this.outputdir.getText();
    }

    private String[] dtpConnectionProfileNames() {
        ArrayList<String> list = new ArrayList<String>();
        IConnectionProfile[] cps = ProfileManager.getInstance().getProfiles();
        int i = 0;
        while (i < cps.length) {
            list.add(cps[i].getName());
            ++i;
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    private String getProjectConnectionProfileName() {
        return this.jpaProject.getDataSource().getConnectionProfileName();
    }

    public String getConfigurationName() {
        if (this.useConsoleConfiguration.getSelection()) {
            return this.consoleConfigurationName.getText();
        }
        return this.createConsoleConfiguration();
    }

    public String getConnectionProfileName() {
        return this.connectionProfileName.getText();
    }

    private String createConsoleConfiguration() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String dialect = this.determineDialect();
        String ccName = launchManager.generateLaunchConfigurationName(HibernateConsoleMessages.AddConfigurationAction_hibernate);
        EclipseConsoleConfigurationPreferences prefs = new EclipseConsoleConfigurationPreferences(ccName, ConsoleConfigurationPreferences.ConfigurationMode.JPA, this.getHibernateVersion(), this.jpaProject.getName(), true, null, null, null, new IPath[0], new IPath[0], null, null, this.getConnectionProfileName(), dialect);
        ConsoleConfiguration cc = new ConsoleConfiguration((ConsoleConfigurationPreferences)prefs);
        KnownConfigurations.getInstance().addConfiguration(cc, false);
        return ccName;
    }

    public boolean isTemporaryConfiguration() {
        return !this.useConsoleConfiguration.getSelection();
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    public void setWarningMessage(String warning) {
        this.setMessage(warning, 2);
    }

    protected String getDefaultOutput() {
        block9: {
            block8: {
                block7: {
                    if (this.getJpaProject() != null) break block7;
                    return "";
                }
                if (this.getJpaProject().getJavaProject() != null) break block8;
                return "";
            }
            if (this.getJpaProject().getJavaProject().exists()) break block9;
            return "";
        }
        try {
            IPackageFragmentRoot[] roots = this.getJpaProject().getJavaProject().getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getClass() == PackageFragmentRoot.class && root.exists()) {
                    return root.getResource().getFullPath().toOSString();
                }
                ++i;
            }
            return this.getJpaProject().getJavaProject().getResource().getFullPath().toOSString();
        }
        catch (JavaModelException e) {
            HibernateJptUIPlugin.logException(e);
            return "";
        }
    }

    private String[] getDialectNames() {
        String[] dialectNames1 = this.helper.getDialectNames();
        String[] dialectNames2 = new String[dialectNames1.length + 1];
        dialectNames2[0] = AUTODETECT;
        System.arraycopy(dialectNames1, 0, dialectNames2, 1, dialectNames1.length);
        return dialectNames2;
    }

    private String determineDialect() {
        if (!AUTODETECT.equals(this.dialectName.getText())) {
            return this.helper.getDialectClass(this.dialectName.getText());
        }
        if (!this.useConsoleConfiguration.getSelection()) {
            String driver = ConnectionProfileUtil.getDriverClass((String)this.getConnectionProfileName());
            return this.helper.getDialect(driver);
        }
        return null;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

