/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.NamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.jboss.tools.hibernate.jpt.core.internal.context.CacheModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.FlushModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateQuery;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

public class HibernateQueryPropertyComposite<T extends HibernateQuery>
extends Pane<T> {
    public HibernateQueryPropertyComposite(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.NAMED_QUERY_COMPOSITE_NAME_TEXT_LABEL);
        this.addText(container, this.buildNameTextHolder());
        this.addLabel(container, JptJpaUiDetailsMessages.NAMED_QUERY_PROPERTY_COMPOSITE_QUERY);
        this.addMultiLineText(container, this.buildQueryHolder(), 4);
        this.addTriStateCheckBoxWithDefault(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_readOnly, this.buildReadOnlyHolder(), this.buildReadOnlyStringHolder(), null);
        this.addLabel(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_flushMode);
        this.addFlushModeTypeCombo(container);
        this.addTriStateCheckBoxWithDefault(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheable, this.buildCacheableHolder(), this.buildCacheableStringHolder(), null);
        this.addLabel(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheMode);
        this.addCacheModeTypeCombo(container);
        this.addLabel(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheRegion);
        this.addText(container, this.buildCacheRegionTextHolder());
        this.addLabel(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_fetchSize);
        this.addSpinner(container, this.buildFetchSizeHolder(), -1, -1, Integer.MAX_VALUE, JpaHelpContextIds.MAPPING_COLUMN_LENGTH);
        this.addLabel(container, HibernateUIMappingMessages.NamedQueryPropertyComposite_timeout);
        this.addSpinner(container, this.buildTimeoutHolder(), -1, -1, Integer.MAX_VALUE, JpaHelpContextIds.MAPPING_COLUMN_LENGTH);
    }

    protected ModifiablePropertyValueModel<String> buildNameTextHolder() {
        return new PropertyAspectAdapter<HibernateQuery, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((HibernateQuery)this.subject).getName();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setName(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildQueryHolder() {
        return new PropertyAspectAdapter<HibernateQuery, String>(this.getSubjectHolder(), new String[]{"query"}){

            protected String buildValue_() {
                String queryText = "";
                if (this.subject instanceof NamedQuery) {
                    queryText = ((NamedQuery)this.subject).getQuery();
                } else if (this.subject instanceof NamedNativeQuery) {
                    queryText = ((NamedNativeQuery)this.subject).getQuery();
                }
                return queryText;
            }

            protected void setValue_(String value) {
                if (this.subject instanceof NamedQuery) {
                    ((NamedQuery)this.subject).setQuery(value);
                }
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildCacheableHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Boolean>(this.getSubjectHolder(), new String[]{"defaultCacheable", "specifiedCacheable"}){

            protected Boolean buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedCacheable();
            }

            protected void setValue_(Boolean value) {
                ((HibernateQuery)this.subject).setSpecifiedCacheable(value);
            }
        };
    }

    private PropertyValueModel<String> buildCacheableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildCacheableHolder()){

            protected String transform(Boolean value) {
                if (HibernateQueryPropertyComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateQuery)HibernateQueryPropertyComposite.this.getSubject()).isDefaultCacheable();
                    String defaultStringValue = defaultValue ? JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_TRUE : JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_FALSE;
                    return NLS.bind((String)HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheableWithDefault, (Object)defaultStringValue);
                }
                return HibernateUIMappingMessages.NamedQueryPropertyComposite_cacheable;
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildReadOnlyHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Boolean>(this.getSubjectHolder(), new String[]{"defaultReadOnly", "specifiedReadOnly"}){

            protected Boolean buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedReadOnly();
            }

            protected void setValue_(Boolean value) {
                ((HibernateQuery)this.subject).setSpecifiedReadOnly(value);
            }
        };
    }

    private PropertyValueModel<String> buildReadOnlyStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildReadOnlyHolder()){

            protected String transform(Boolean value) {
                if (HibernateQueryPropertyComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((HibernateQuery)HibernateQueryPropertyComposite.this.getSubject()).isDefaultReadOnly();
                    String defaultStringValue = defaultValue ? JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_TRUE : JptJpaUiDetailsMessages.OPTIONAL_COMPOSITE_FALSE;
                    return NLS.bind((String)HibernateUIMappingMessages.NamedQueryPropertyComposite_readOnlyWithDefault, (Object)defaultStringValue);
                }
                return HibernateUIMappingMessages.NamedQueryPropertyComposite_readOnly;
            }
        };
    }

    private EnumFormComboViewer<HibernateQuery, FlushModeType> addFlushModeTypeCombo(Composite container) {
        return new EnumFormComboViewer<HibernateQuery, FlushModeType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultFlushMode");
                propertyNames.add("specifiedFlushMode");
            }

            protected FlushModeType[] getChoices() {
                return FlushModeType.values();
            }

            protected FlushModeType getDefaultValue() {
                return ((HibernateQuery)this.getSubject()).getDefaultFlushMode();
            }

            protected String displayString(FlushModeType value) {
                return value.toString();
            }

            protected FlushModeType getValue() {
                return ((HibernateQuery)this.getSubject()).getSpecifiedFlushMode();
            }

            protected void setValue(FlushModeType value) {
                ((HibernateQuery)this.getSubject()).setSpecifiedFlushMode(value);
            }
        };
    }

    private EnumFormComboViewer<HibernateQuery, CacheModeType> addCacheModeTypeCombo(Composite container) {
        return new EnumFormComboViewer<HibernateQuery, CacheModeType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCacheMode");
                propertyNames.add("specifiedCacheMode");
            }

            protected CacheModeType[] getChoices() {
                return CacheModeType.values();
            }

            protected CacheModeType getDefaultValue() {
                return ((HibernateQuery)this.getSubject()).getDefaultCacheMode();
            }

            protected String displayString(CacheModeType value) {
                return value.toString();
            }

            protected CacheModeType getValue() {
                return ((HibernateQuery)this.getSubject()).getSpecifiedCacheMode();
            }

            protected void setValue(CacheModeType value) {
                ((HibernateQuery)this.getSubject()).setSpecifiedCacheMode(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildCacheRegionTextHolder() {
        return new PropertyAspectAdapter<HibernateQuery, String>(this.getSubjectHolder(), new String[]{"defaultCacheRegion", "specifiedCacheRegion"}){

            protected String buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedCacheRegion();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setSpecifiedCacheRegion(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Integer> buildFetchSizeHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Integer>(this.getSubjectHolder(), new String[]{"specifiedFetchSize"}){

            protected Integer buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedFetchSize();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setSpecifiedFetchSize(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Integer> buildTimeoutHolder() {
        return new PropertyAspectAdapter<HibernateQuery, Integer>(this.getSubjectHolder(), new String[]{"specifiedTimeout"}){

            protected Integer buildValue_() {
                return ((HibernateQuery)this.subject).getSpecifiedTimeout();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((HibernateQuery)this.subject).setSpecifiedTimeout(value);
            }
        };
    }

    protected void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
    }
}

