/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.verification.vrules.VAction;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VResultTemplate;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.impl.VResultFactoryImpl;
import org.jboss.tools.common.verification.vrules.impl.VRuleImpl;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;
import org.jboss.tools.common.verification.vrules.layer.VModelImpl;
import org.jboss.tools.common.verification.vrules.model.VActionWrapper;
import org.jboss.tools.common.verification.vrules.model.VResultTemplateModel;

public class VRuleModel
extends RegularObjectImpl
implements PropertyChangeListener {
    private static final long serialVersionUID = 721113473428485561L;
    protected VRuleImpl rule;

    public VRule getRule(VRuleSet ruleSet) {
        if (this.rule == null) {
            String p;
            this.rule = new VRuleImpl();
            this.rule.setRuleSet(ruleSet);
            this.rule.setName(this.getAttributeValue("name"));
            this.rule.setDescription(this.getAttributeValue("description"));
            this.rule.setCategory(this.getAttributeValue("category"));
            this.rule.setEnabled(Boolean.valueOf(this.getAttributeValue("enabled")));
            String defaultEnabled = this.get("default-enabled");
            if ("false".equals(defaultEnabled)) {
                this.rule.setDefaultEnabled(false);
            }
            this.rule.setResults(new VResult[0]);
            VEntity[] entities = this.getEntities(this.getAttributeValue("entities"));
            this.rule.setEntities(entities);
            String act = this.getAttributeValue("action");
            this.rule.setAction(this.getAction(act));
            try {
                this.rule.setSignificance(Integer.parseInt(this.getAttributeValue("significance")));
            }
            catch (NumberFormatException numberFormatException) {
                this.rule.setSignificance(10);
            }
            VResultTemplate[] templates = this.getTemplates();
            VResultFactoryImpl factory = (VResultFactoryImpl)this.rule.getResultFactory();
            int sign = -1;
            int i = 0;
            while (i < templates.length) {
                factory.addTemplate(templates[i]);
                sign = Math.max(sign, templates[i].getSignificance());
                ++i;
            }
            if (sign > 0) {
                this.rule.setSignificance(sign);
            }
            if ((p = this.getAttributeValue("properties")) != null && p.length() > 0) {
                StringTokenizer st = new StringTokenizer(p, ",");
                Properties properties = new Properties();
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    int i2 = t.indexOf(61);
                    if (i2 < 0) continue;
                    String n = t.substring(0, i2);
                    String v = t.substring(i2 + 1);
                    properties.setProperty(n, v);
                }
                if (properties.size() > 0) {
                    this.rule.setProperties(properties);
                }
            }
            this.rule.addPropertyChangeListener(this);
        }
        return this.rule;
    }

    private VResultTemplate[] getTemplates() {
        XModelObject[] c = this.getChildren();
        VResultTemplate[] templates = new VResultTemplate[c.length];
        int i = 0;
        while (i < c.length) {
            templates[i] = ((VResultTemplateModel)c[i]).getTemplate(this.rule);
            ++i;
        }
        return templates;
    }

    public VEntity[] getEntities(String list) {
        StringTokenizer tok = new StringTokenizer(list, ",");
        int count = tok.countTokens();
        VEntity[] entities = new VEntity[count];
        VModel model = VModelFactory.getModel(this.getModel());
        int i = 0;
        while (i < count) {
            String entity = tok.nextToken().trim();
            entities[i] = model.getEntity(entity);
            ++i;
        }
        return entities;
    }

    public VAction getAction(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        return new VActionWrapper(className);
    }

    public void set(String name, String value) {
        super.set(name, value);
        if (this.rule != null && "default-enabled".equals(name) && "false".equals(value)) {
            this.rule.setDefaultEnabled(false);
        }
    }

    public String setAttributeValue(String name, String value) {
        String result = super.setAttributeValue(name, value);
        if (this.rule != null) {
            if ("enabled".equals(name)) {
                this.rule.setEnabled(Boolean.valueOf(result));
            } else if ("name".equals(name)) {
                String oldName = this.rule.getName();
                this.rule.setName(result);
                VModel vmodel = VModelFactory.getModel(this.getModel());
                ((VModelImpl)vmodel).updateRuleAction(this.rule, oldName);
            } else if ("action".equals(name)) {
                this.rule.setAction(this.getAction(result));
            } else if ("significance".equals(name)) {
                try {
                    this.rule.setSignificance(Integer.parseInt(result));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("entities".equals(name)) {
                VEntity[] oldEntities = this.rule.getEntities();
                VEntity[] newEntities = this.getEntities(result);
                this.rule.setEntities(newEntities);
                HashMap<String, VEntity> oldMap = new HashMap<String, VEntity>();
                int i = 0;
                while (i < oldEntities.length) {
                    oldMap.put(oldEntities[i].getName(), oldEntities[i]);
                    ++i;
                }
                i = 0;
                while (i < newEntities.length) {
                    if (oldMap.remove(newEntities[i].getName()) == null) {
                        newEntities[i].addRule(this.rule);
                    }
                    ++i;
                }
                for (VEntity entity : oldMap.values()) {
                    entity.removeRule(this.rule);
                }
            }
        }
        return result;
    }

    public boolean addChild(XModelObject child) {
        boolean res = super.addChild(child);
        if (res && this.rule != null && child instanceof VResultTemplateModel) {
            VResultTemplate template = ((VResultTemplateModel)child).getTemplate(this.rule);
            VResultFactoryImpl factory = (VResultFactoryImpl)this.rule.getResultFactory();
            factory.addTemplate(template);
        }
        return res;
    }

    public void removeChild(XModelObject child) {
        super.removeChild(child);
        if (this.rule != null && child instanceof VResultTemplateModel) {
            VResultTemplate template = ((VResultTemplateModel)child).getTemplate(this.rule);
            VResultFactoryImpl factory = (VResultFactoryImpl)this.rule.getResultFactory();
            factory.removeTemplate(template);
        }
    }

    public XModelObject[] getChildrenForSave() {
        return this.getChildren("VResultTemplate");
    }

    protected Comparator<XModelObject> createComparator() {
        return super.createComparator();
    }

    public boolean isObjectEditable() {
        return super.isObjectEditable();
    }

    public boolean isAttributeEditable(String name) {
        return "enabled".equals(name) || super.isAttributeEditable(name);
    }

    public String getPathPart() {
        return this.getAttributeValue("name");
    }

    public String getPresentationString() {
        return this.getAttributeValue("name");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        String value = "" + evt.getNewValue();
        if ("enabled".equals(name) && !value.equals(this.getAttributeValue(name))) {
            this.setAttributeValue(name, value);
            this.setModified(true);
        }
    }
}

