/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model;

import java.io.IOException;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XMLRecognizerContext;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.seam.pages.xml.SeamPagesXMLPlugin;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;

public class SeamPagesEntityRecognizer
implements EntityRecognizer,
SeamPagesConstants {
    static {
        try {
            Class<SeamPagesEntityRecognizer> c = SeamPagesEntityRecognizer.class;
            XMLEntityResolver.registerPublicEntity((String)"-//JBoss/Seam Pages Configuration DTD 1.2//EN", c, (String)"/meta/pages-1.2.dtd");
        }
        catch (IOException e) {
            SeamPagesXMLPlugin.getDefault().logError(e);
        }
    }

    public String getEntityName(EntityRecognizerContext context) {
        String body = context.getBody();
        if (body == null) {
            return null;
        }
        XMLRecognizerContext xml = context.getXMLContext();
        if (xml.isDTD()) {
            String publicId = xml.getPublicId();
            String name = xml.getRootName();
            if ("-//JBoss/Seam Pages Configuration DTD 1.2//EN".equals(publicId)) {
                if ("page".equals(name)) {
                    return "FileSeamPage12";
                }
                if ("pages".equals(name)) {
                    return "FileSeamPages12";
                }
            }
            return null;
        }
        Parser p = new Parser(body);
        if (!p.recognized) {
            return null;
        }
        if (p.isOrg) {
            return p.isSingle ? "FileSeamPage23" : "FileSeamPages23";
        }
        if (p.is20) {
            return p.isSingle ? "FileSeamPage20" : "FileSeamPages20";
        }
        if (p.is21) {
            return p.isSingle ? "FileSeamPage21" : "FileSeamPages21";
        }
        return p.isSingle ? "FileSeamPage22" : "FileSeamPages22";
    }

    class Parser {
        boolean recognized = false;
        boolean isSingle = false;
        boolean is20 = false;
        boolean is21 = false;
        boolean isOrg = false;

        Parser(String body) {
            int j;
            int i = body.indexOf("<page");
            if (i < 0) {
                return;
            }
            int i2 = body.indexOf("<pages");
            if (i2 < 0) {
                this.isSingle = true;
            }
            if ((j = body.indexOf(">", i)) < 0) {
                return;
            }
            String s = body.substring(i, j);
            if (s.indexOf("\"http://jboss.org/schema/seam/pages\"") >= 0) {
                this.isOrg = true;
            } else if (s.indexOf("\"http://jboss.com/products/seam/pages\"") < 0) {
                return;
            }
            if (s.indexOf("2.0") >= 0) {
                this.is20 = true;
            }
            if (s.indexOf("2.1") >= 0) {
                this.is21 = true;
            }
            this.recognized = true;
        }
    }
}

