/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.wizard.BeansXMLAccess;
import org.jboss.tools.cdi.ui.wizard.CheckBoxEditorWrapper;
import org.jboss.tools.cdi.ui.wizard.InterceptorBindingSelectionProvider;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;
import org.jboss.tools.cdi.ui.wizard.StereotypesSelectionProvider;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ListFieldEditor;

public class NewStereotypeWizardPage
extends NewCDIAnnotationWizardPage {
    protected CheckBoxEditorWrapper alternative = null;
    protected boolean mayBeRegisteredInBeansXML = true;
    protected BeansXMLAccess registerInBeansXML = new BeansXMLAccess((NewTypeWizardPage)this, "Alternatives", "CDIStereotype", "stereotype");
    protected CheckBoxEditorWrapper named = null;
    protected ITaggedFieldEditor scope = null;
    protected Map<String, String> scopes = new TreeMap<String, String>();
    protected StereotypesSelectionProvider stereotypesProvider = new StereotypesSelectionProvider();
    protected InterceptorBindingSelectionProvider interceptorBindingsProvider = new InterceptorBindingSelectionProvider();
    protected ListFieldEditor stereotypes = null;
    protected ListFieldEditor interceptorBindings = null;
    boolean isAlternativeInitialValue = false;
    protected StatusInfo targetStatus = new StatusInfo();

    public NewStereotypeWizardPage() {
        this.setTitle(CDIUIMessages.NEW_STEREOTYPE_WIZARD_PAGE_NAME);
    }

    public void setMayBeRegisteredInBeansXML(boolean b) {
        this.mayBeRegisteredInBeansXML = b;
    }

    @Override
    protected void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        this.addStereotypeAnnotation(imports, sb, lineDelimiter);
        this.addInheritedAnnotation(imports, sb, lineDelimiter);
        this.addAlternativeAnnotation(imports, sb, lineDelimiter);
        this.addScopeAnnotation(imports, sb, lineDelimiter);
        this.addNamedAnnotation(imports, sb, lineDelimiter);
        this.addInterceptorBindingAnnotations(imports, sb, lineDelimiter);
        this.addSuperStereotypeAnnotations(imports, sb, lineDelimiter);
        this.addTargetAnnotation(imports, sb, lineDelimiter, this.getTargets());
        this.addRetentionAnnotation(imports, sb, lineDelimiter);
        this.addDocumentedAnnotation(imports, sb, lineDelimiter);
    }

    protected void addStereotypeAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        NewStereotypeWizardPage.addAnnotation("javax.enterprise.inject.Stereotype", imports, sb, lineDelimiter);
    }

    protected void addAlternativeAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.alternative != null && this.alternative.composite.getValue() == Boolean.TRUE) {
            NewStereotypeWizardPage.addAnnotation("javax.enterprise.inject.Alternative", imports, sb, lineDelimiter);
        }
    }

    protected void addNamedAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.named != null && this.named.composite.getValue() == Boolean.TRUE) {
            NewStereotypeWizardPage.addAnnotation("javax.inject.Named", imports, sb, lineDelimiter);
        }
    }

    protected void addScopeAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.scope != null && this.scope.getValue() != null && this.scope.getValue().toString().length() > 0) {
            String scopeName = this.scope.getValue().toString();
            String qScopeName = this.scopes.get(scopeName);
            NewStereotypeWizardPage.addAnnotation(qScopeName, imports, sb, lineDelimiter);
        }
    }

    protected void addSuperStereotypeAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.stereotypes != null) {
            List list = (List)this.stereotypes.getValue();
            for (Object o : list) {
                if (!(o instanceof ICDIAnnotation)) continue;
                ICDIAnnotation a = (ICDIAnnotation)o;
                String typeName = a.getSourceType().getFullyQualifiedName();
                NewStereotypeWizardPage.addAnnotation(typeName, imports, sb, lineDelimiter);
            }
        }
    }

    protected void addInterceptorBindingAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.interceptorBindings != null) {
            List list = (List)this.interceptorBindings.getValue();
            for (Object o : list) {
                if (!(o instanceof ICDIAnnotation)) continue;
                ICDIAnnotation a = (ICDIAnnotation)o;
                String typeName = a.getSourceType().getFullyQualifiedName();
                NewStereotypeWizardPage.addAnnotation(typeName, imports, sb, lineDelimiter);
            }
        }
    }

    @Override
    protected void createCustomFields(Composite composite) {
        this.createInheritedField(composite, false);
        this.createAlternativeField(composite);
        this.createRegisterInBeansXML(composite);
        this.createNamedField(composite);
        this.createScopeField(composite);
        this.createTargetField(composite);
        this.createInterceptorBindingField(composite);
        this.createStereotypeField(composite);
    }

    protected void createAlternativeField(Composite composite) {
        String label = "Add @Alternative";
        this.alternative = this.createCheckBoxField(composite, "isAlternative", label, this.isAlternativeInitialValue);
        if (this.mayBeRegisteredInBeansXML) {
            this.alternative.checkBox.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isAlternative = "true".equals(NewStereotypeWizardPage.this.alternative.checkBox.getValueAsString());
                    NewStereotypeWizardPage.this.registerInBeansXML.setEnabled(isAlternative);
                }
            });
        }
    }

    protected void createRegisterInBeansXML(Composite composite) {
        if (!this.mayBeRegisteredInBeansXML) {
            return;
        }
        this.registerInBeansXML.create(composite, this.isAlternativeInitialValue);
        this.registerInBeansXML.setEnabled(this.isAlternativeInitialValue);
    }

    protected void createNamedField(Composite composite) {
        String label = "Add @Named";
        this.named = this.createCheckBoxField(composite, "isNamed", label, false);
    }

    protected void createScopeField(Composite composite) {
        ArrayList<String> vs = new ArrayList<String>();
        vs.add("");
        this.scope = this.createComboField("scope", CDIUIMessages.FIELD_EDITOR_SCOPE_LABEL, composite, vs);
        this.setScopes(this.getPackageFragmentRoot());
    }

    protected void createTargetField(Composite composite) {
        ArrayList<String> targetOptions = new ArrayList<String>();
        targetOptions.add("TYPE,METHOD,FIELD");
        targetOptions.add("METHOD,FIELD");
        targetOptions.add("TYPE");
        targetOptions.add("METHOD");
        targetOptions.add("FIELD");
        this.createTargetField(composite, targetOptions);
        this.target.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewStereotypeWizardPage.this.validateTargetAndStereotype();
            }
        });
    }

    protected void createInterceptorBindingField(Composite composite) {
        this.interceptorBindings = new ListFieldEditor("interceptorBindings", CDIUIMessages.FIELD_EDITOR_INTERCEPTOR_BINDINGS_LABEL, new ArrayList());
        this.interceptorBindings.setProvider((ListFieldEditor.ListFieldEditorProvider)this.interceptorBindingsProvider);
        this.interceptorBindingsProvider.setEditorField((IFieldEditor)this.interceptorBindings);
        this.interceptorBindings.doFillIntoGrid((Object)composite);
        this.setInterceptorBindings(this.getPackageFragmentRoot());
        this.interceptorBindings.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o instanceof List && !((List)o).isEmpty()) {
                    NewStereotypeWizardPage.this.target.setValue((Object)"TYPE");
                    NewStereotypeWizardPage.this.target.setEnabled(false);
                } else {
                    NewStereotypeWizardPage.this.target.setEnabled(true);
                }
            }
        });
    }

    protected void createStereotypeField(Composite composite) {
        this.stereotypes = new ListFieldEditor("stereotypes", CDIUIMessages.FIELD_EDITOR_STEREOTYPES_LABEL, new ArrayList());
        this.stereotypes.setProvider((ListFieldEditor.ListFieldEditorProvider)this.stereotypesProvider);
        this.stereotypesProvider.setEditorField((IFieldEditor)this.stereotypes);
        this.stereotypes.doFillIntoGrid((Object)composite);
        this.setStereotypes(this.getPackageFragmentRoot());
        this.stereotypes.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewStereotypeWizardPage.this.validateTargetAndStereotype();
            }
        });
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        super.setPackageFragmentRoot(root, canBeModified);
        this.setScopes(root);
    }

    void setScopes(IPackageFragmentRoot root) {
        if (root != null) {
            IJavaProject jp = root.getJavaProject();
            ICDIProject cdi = NewStereotypeWizardPage.getCDIProject(jp);
            if (cdi != null) {
                this.setScopes(cdi.getScopeNames().toArray(new String[0]));
            } else {
                this.setScopes(new String[]{""});
            }
        } else {
            this.setScopes(new String[]{""});
        }
    }

    void setInterceptorBindings(IPackageFragmentRoot root) {
        IJavaProject jp;
        ICDIProject cdi;
        this.interceptorBindingsProvider.setProject(null);
        if (root != null && (cdi = NewStereotypeWizardPage.getCDIProject(jp = root.getJavaProject())) != null) {
            this.interceptorBindingsProvider.setProject(cdi);
        }
    }

    void setStereotypes(IPackageFragmentRoot root) {
        IJavaProject jp;
        ICDIProject cdi;
        this.stereotypesProvider.setProject(null);
        if (root != null && (cdi = CDICorePlugin.getCDIProject((IProject)(jp = root.getJavaProject()).getProject(), (boolean)true)) != null) {
            this.stereotypesProvider.setProject(cdi);
        }
    }

    void setScopes(String[] tags) {
        this.scopes.clear();
        this.scopes.put("", "");
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.length() != 0) {
                int i = tag.lastIndexOf(46);
                String name = "@" + tag.substring(i + 1);
                this.scopes.put(name, tag);
            }
            ++n2;
        }
        if (this.scope != null) {
            this.scope.setTags(this.scopes.keySet().toArray(new String[0]));
            this.scope.setValue((Object)"");
        }
    }

    public void setNamed(boolean b) {
        if (this.named != null) {
            this.named.composite.setValue((Object)b);
        }
    }

    void validateTargetAndStereotype() {
        try {
            this.getTargetAndStereotypeError();
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        IStatus[] ns = new IStatus[status.length + 1];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.targetStatus;
        status = ns;
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    void getTargetAndStereotypeError() throws JavaModelException {
        this.targetStatus = new StatusInfo();
        if (this.stereotypes != null && this.target != null) {
            String value = (String)this.target.getValue();
            boolean hasMethodOrField = value != null && (value.indexOf("METHOD") >= 0 || value.indexOf("FIELD") >= 0);
            List list = (List)this.stereotypes.getValue();
            for (Object o : list) {
                String message;
                IStereotype a;
                IAnnotationDeclaration target;
                if (!(o instanceof IStereotype) || (target = (a = (IStereotype)o).getAnnotationDeclaration("java.lang.annotation.Target")) == null) continue;
                Set targets = CDIUtil.getTargetAnnotationValues((IAnnotationDeclaration)target);
                if (targets != null && targets.size() == 1 && targets.contains("TYPE") && hasMethodOrField) {
                    message = NLS.bind((String)CDIUIMessages.MESSAGE_STEREOTYPE_IS_NOT_COMPATIBLE, (Object)a.getSourceType().getElementName());
                    this.targetStatus.setWarning(message);
                }
                if (targets == null || targets.contains("TYPE")) continue;
                message = NLS.bind((String)CDIUIMessages.MESSAGE_STEREOTYPE_CANNOT_BE_APPLIED_TO_TYPE, (Object)a.getSourceType().getElementName());
                this.targetStatus.setError(message);
                return;
            }
        }
    }

    public void addStereotype(IStereotype s) {
        List vs = (List)this.stereotypes.getValue();
        ArrayList<IStereotype> nvs = new ArrayList<IStereotype>();
        if (vs != null) {
            nvs.addAll(vs);
        }
        nvs.add(s);
        this.stereotypes.setValue(nvs);
    }

    public void setAlternative(boolean value) {
        if (this.alternative != null) {
            this.alternative.composite.setValue((Object)value);
        } else {
            this.isAlternativeInitialValue = value;
        }
    }

    public void setToBeRegisteredInBeansXML(boolean value) {
        if (this.registerInBeansXML != null) {
            this.registerInBeansXML.check.composite.setValue((Object)value);
        }
    }

    public boolean isToBeRegisteredInBeansXML() {
        if (this.registerInBeansXML != null && this.alternative != null) {
            return this.alternative.composite.getValue() == Boolean.TRUE && this.registerInBeansXML.isSelected();
        }
        return false;
    }

    protected IStatus packageChanged() {
        IStatus result = super.packageChanged();
        this.registerInBeansXML.validate();
        return result;
    }

    protected IStatus typeNameChanged() {
        IStatus result = super.typeNameChanged();
        this.registerInBeansXML.validate();
        return result;
    }
}

