/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotyped;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.marker.AddAnnotationMarkerResolution;
import org.jboss.tools.cdi.ui.marker.AddLocalBeanMarkerResolution;
import org.jboss.tools.cdi.ui.marker.AddNameMarkerResolution;
import org.jboss.tools.cdi.ui.marker.AddRetentionAnnotationMarkerResolution;
import org.jboss.tools.cdi.ui.marker.AddSerializableInterfaceMarkerResolution;
import org.jboss.tools.cdi.ui.marker.AddTargetAnnotationMarkerResolution;
import org.jboss.tools.cdi.ui.marker.CDIQuickFixExtensionManager;
import org.jboss.tools.cdi.ui.marker.ChangeAnnotationMarkerResolution;
import org.jboss.tools.cdi.ui.marker.CreateBeansXMLMarkerResolution;
import org.jboss.tools.cdi.ui.marker.CreateCDIElementMarkerResolution;
import org.jboss.tools.cdi.ui.marker.DeleteAllDisposerDuplicantMarkerResolution;
import org.jboss.tools.cdi.ui.marker.DeleteAllInjectedConstructorsMarkerResolution;
import org.jboss.tools.cdi.ui.marker.DeleteAllOtherAnnotationsFromParametersMarkerResolution;
import org.jboss.tools.cdi.ui.marker.DeleteAnnotationMarkerResolution;
import org.jboss.tools.cdi.ui.marker.ICDIMarkerResolutionGeneratorExtension;
import org.jboss.tools.cdi.ui.marker.MakeBeanScopedDependentMarkerResolution;
import org.jboss.tools.cdi.ui.marker.MakeFieldProtectedMarkerResolution;
import org.jboss.tools.cdi.ui.marker.MakeFieldStaticMarkerResolution;
import org.jboss.tools.cdi.ui.marker.MakeInjectedPointUnambiguousMarkerResolution;
import org.jboss.tools.cdi.ui.marker.MakeMethodBusinessMarkerResolution;
import org.jboss.tools.cdi.ui.marker.MakeMethodPublicMarkerResolution;
import org.jboss.tools.cdi.ui.marker.SelectBeanMarkerResolution;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.quickfix.IQuickFixGenerator;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.validation.java.TempJavaProblemAnnotation;

public class CDIProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator2,
IQuickFixGenerator {
    private static final String JAVA_EXTENSION = "java";
    private static final String XML_EXTENSION = "xml";
    private static final int MARKER_RESULUTION_NUMBER_LIMIT = 7;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            return this.findResolutions(marker);
        }
        catch (CoreException ex) {
            CDIUIPlugin.getDefault().logError(ex);
            return new IMarkerResolution[0];
        }
    }

    private int getMessageID(IMarker marker) throws CoreException {
        Integer attribute = (Integer)marker.getAttribute("Message_id");
        if (attribute != null) {
            return attribute;
        }
        return -1;
    }

    private int getMessageID(TemporaryAnnotation annotation) {
        Integer attribute;
        if (annotation.getAttributes() != null && (attribute = (Integer)annotation.getAttributes().get("Message_id")) != null) {
            return attribute;
        }
        return -1;
    }

    private IQuickFix[] findXMLResolutions(IFile file, int messageId, int start, int end, boolean asYouType) throws JavaModelException {
        IJavaElement element;
        String text;
        IJavaProject javaProject;
        block23: {
            javaProject = EclipseUtil.getJavaProject((IProject)file.getProject());
            FileEditorInput input = new FileEditorInput(file);
            IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)input);
            try {
                provider.connect((Object)input);
            }
            catch (CoreException e) {
                CDIUIPlugin.getDefault().logError(e);
            }
            IDocument document = provider.getDocument((Object)input);
            text = "";
            try {
                try {
                    text = document.get(start, end - start);
                }
                catch (BadLocationException e) {
                    CDIUIPlugin.getDefault().logError(e);
                    provider.disconnect((Object)input);
                    break block23;
                }
            }
            catch (Throwable throwable) {
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
        }
        boolean correctTypeName = JavaConventionsUtil.validatePackageName((String)text, (IJavaElement)javaProject).isOK();
        if (messageId == 43) {
            IJavaElement element2 = this.findJavaElementByQualifiedName(javaProject, text);
            if (element2 == null && correctTypeName) {
                return new IQuickFix[]{new CreateCDIElementMarkerResolution(file.getProject(), text, 1)};
            }
        } else if (messageId == 44) {
            IJavaElement element3 = this.findJavaElementByQualifiedName(javaProject, text);
            if (element3 == null && correctTypeName) {
                return new IQuickFix[]{new CreateCDIElementMarkerResolution(file.getProject(), text, 2)};
            }
        } else if (messageId == 45) {
            IType element4 = this.getTypeToAddAlternativeToBean(javaProject, text, asYouType);
            if (element4 != null) {
                return new IQuickFix[]{new AddAnnotationMarkerResolution((IJavaElement)element4, "javax.enterprise.inject.Alternative")};
            }
        } else if (messageId == 46) {
            IType element5 = this.getTypeToAddAlternativeToStereotype(javaProject, text, asYouType);
            if (element5 != null) {
                return new IQuickFix[]{new AddAnnotationMarkerResolution((IJavaElement)element5, "javax.enterprise.inject.Alternative")};
            }
        } else if (messageId == 47) {
            IJavaElement element6 = this.findJavaElementByQualifiedName(javaProject, text);
            if (element6 == null && correctTypeName) {
                return new IQuickFix[]{new CreateCDIElementMarkerResolution(file.getProject(), text, 4)};
            }
        } else if (messageId == 48 && (element = this.findJavaElementByQualifiedName(javaProject, text)) == null && correctTypeName) {
            return new IQuickFix[]{new CreateCDIElementMarkerResolution(file.getProject(), text, 3)};
        }
        return new IQuickFix[0];
    }

    private IQuickFix[] findJavaResolutions(ICompilationUnit compilationUnit, int problemId, int offset, ICDIMarkerResolutionGeneratorExtension[] extensions, boolean asYouType) throws JavaModelException {
        if (problemId == 1) {
            IField field = this.findNonStaticField(compilationUnit, offset);
            if (field != null) {
                return new IQuickFix[]{new MakeFieldStaticMarkerResolution(field)};
            }
        } else if (problemId == 2 || problemId == 3 || problemId == 4) {
            IMethod method = this.findMethod(compilationUnit, offset);
            if (method != null) {
                List<IType> types = this.findLocalAnnotattedInterfaces(method);
                if (types.size() == 0 && !Flags.isPublic((int)method.getFlags())) {
                    return new IQuickFix[]{new MakeMethodPublicMarkerResolution(method)};
                }
                IQuickFix[] resolutions = new IQuickFix[types.size() + 1];
                int i = 0;
                while (i < types.size()) {
                    resolutions[i] = new MakeMethodBusinessMarkerResolution(method, types.get(i));
                    ++i;
                }
                resolutions[types.size()] = new AddLocalBeanMarkerResolution(method);
                return resolutions;
            }
        } else if (problemId == 5) {
            IMethod method = this.findMethod(compilationUnit, offset);
            if (method != null) {
                return new IQuickFix[]{new DeleteAllDisposerDuplicantMarkerResolution(method)};
            }
        } else if (problemId == 6) {
            IMethod method = this.findMethod(compilationUnit, offset);
            if (method != null) {
                return new IQuickFix[]{new DeleteAllInjectedConstructorsMarkerResolution(method)};
            }
        } else {
            if (problemId == 8 || problemId == 7) {
                ArrayList<IQuickFix> resolutions = new ArrayList<IQuickFix>();
                IInjectionPoint injectionPoint = this.findInjectionPoint(compilationUnit, offset, asYouType);
                if (injectionPoint != null) {
                    List<IBean> beans = problemId == 8 ? this.findBeans(injectionPoint) : this.findLegalBeans(injectionPoint);
                    int i = beans.size() - 1;
                    while (i >= 0) {
                        IBean bean = beans.get(i);
                        ICDIMarkerResolutionGeneratorExtension[] iCDIMarkerResolutionGeneratorExtensionArray = extensions;
                        int n = extensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICDIMarkerResolutionGeneratorExtension extension = iCDIMarkerResolutionGeneratorExtensionArray[n2];
                            if (extension.shouldBeExtended(problemId, bean)) {
                                List<IQuickFix> addings = extension.getResolutions(problemId, bean);
                                resolutions.addAll(addings);
                                beans.remove(bean);
                                break;
                            }
                            ++n2;
                        }
                        --i;
                    }
                    if (beans.size() < 7) {
                        i = 0;
                        while (i < beans.size()) {
                            resolutions.add(new MakeInjectedPointUnambiguousMarkerResolution(injectionPoint, beans, i));
                            ++i;
                        }
                    } else {
                        resolutions.add(new SelectBeanMarkerResolution(injectionPoint, beans));
                    }
                }
                return resolutions.toArray(new IQuickFix[0]);
            }
            if (problemId == 9) {
                IType type = this.findTypeWithNoSerializable(compilationUnit, offset);
                if (type != null) {
                    return new IQuickFix[]{new AddSerializableInterfaceMarkerResolution(type)};
                }
            } else if (problemId == 10) {
                Collection beans;
                ICDIProject cdiProject;
                IField field = this.findPublicField(compilationUnit, offset);
                CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)field.getUnderlyingResource().getProject());
                if (cdiNature != null && (cdiProject = CDIUtil.getCDIProject((IFile)((IFile)compilationUnit.getUnderlyingResource()), (CDICoreNature)cdiNature, (boolean)asYouType)) != null && !(beans = cdiProject.getBeans(field.getUnderlyingResource().getFullPath())).isEmpty()) {
                    IBean bean = (IBean)beans.iterator().next();
                    if (field != null) {
                        return new IQuickFix[]{new MakeFieldProtectedMarkerResolution(field), new MakeBeanScopedDependentMarkerResolution(compilationUnit, bean)};
                    }
                }
            } else if (problemId == 11 || problemId == 13 || problemId == 12) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "java.lang.annotation.Retention");
                if (ta != null) {
                    if (ta.annotation == null) {
                        return new IQuickFix[]{new AddRetentionAnnotationMarkerResolution(ta.type)};
                    }
                    return new IQuickFix[]{new ChangeAnnotationMarkerResolution(ta.annotation, "java.lang.annotation.RetentionPolicy.RUNTIME")};
                }
            } else if (problemId == 14) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "java.lang.annotation.Target");
                if (ta != null) {
                    if (ta.annotation == null) {
                        return new IQuickFix[]{new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.TYPE", "java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD", "java.lang.annotation.ElementType.PARAMETER"}), new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.FIELD", "java.lang.annotation.ElementType.PARAMETER"})};
                    }
                    return new IQuickFix[]{new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.TYPE", "java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD", "java.lang.annotation.ElementType.PARAMETER"}), new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.FIELD", "java.lang.annotation.ElementType.PARAMETER"})};
                }
            } else if (problemId == 15) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "java.lang.annotation.Target");
                if (ta != null) {
                    if (ta.annotation == null) {
                        return new IQuickFix[]{new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.TYPE", "java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD"}), new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD"}), new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.TYPE"}), new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.METHOD"}), new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.FIELD"})};
                    }
                    return new IQuickFix[]{new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.TYPE", "java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD"}), new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD"}), new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.TYPE"}), new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.METHOD"}), new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.FIELD"})};
                }
            } else if (problemId == 16) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "java.lang.annotation.Target");
                if (ta != null) {
                    if (ta.annotation == null) {
                        return new IQuickFix[]{new AddTargetAnnotationMarkerResolution(ta.type, new String[]{"java.lang.annotation.ElementType.TYPE", "java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD"})};
                    }
                    return new IQuickFix[]{new ChangeAnnotationMarkerResolution(ta.annotation, new String[]{"java.lang.annotation.ElementType.TYPE", "java.lang.annotation.ElementType.METHOD", "java.lang.annotation.ElementType.FIELD"})};
                }
            } else if (problemId == 19 || problemId == 17 || problemId == 20 || problemId == 18) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IAnnotation annotation = this.getAnnotation(element, "javax.enterprise.util.Nonbinding");
                    if (element instanceof IMember && annotation == null) {
                        return new IQuickFix[]{new AddAnnotationMarkerResolution((IJavaElement)((IMember)element), "javax.enterprise.util.Nonbinding")};
                    }
                }
            } else if (problemId == 23) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IJavaElement injectElement = this.findJavaElementByAnnotation(element, "javax.inject.Inject");
                    IJavaElement disposesElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Disposes");
                    if (injectElement != null && disposesElement != null) {
                        return new IQuickFix[]{new DeleteAnnotationMarkerResolution(injectElement, "javax.inject.Inject"), new DeleteAnnotationMarkerResolution(disposesElement, "javax.enterprise.inject.Disposes")};
                    }
                }
            } else if (problemId == 21) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IJavaElement injectElement = this.findJavaElementByAnnotation(element, "javax.inject.Inject");
                    IJavaElement produsesElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Produces");
                    if (injectElement != null && produsesElement != null) {
                        return new IQuickFix[]{new DeleteAnnotationMarkerResolution(injectElement, "javax.inject.Inject"), new DeleteAnnotationMarkerResolution(produsesElement, "javax.enterprise.inject.Produces")};
                    }
                }
            } else if (problemId == 22) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IJavaElement injectElement = this.findJavaElementByAnnotation(element, "javax.inject.Inject");
                    IJavaElement observerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.event.Observes");
                    if (injectElement != null && observerElement != null) {
                        return new IQuickFix[]{new DeleteAnnotationMarkerResolution(injectElement, "javax.inject.Inject"), new DeleteAnnotationMarkerResolution(observerElement, "javax.enterprise.event.Observes")};
                    }
                }
            } else if (problemId == 24) {
                IJavaElement observerElement;
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null && (observerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.event.Observes")) != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution(observerElement, "javax.enterprise.event.Observes")};
                }
            } else if (problemId == 28 || problemId == 29 || problemId == 25) {
                IJavaElement disposerElement;
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null && (disposerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Disposes")) != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution(disposerElement, "javax.enterprise.inject.Disposes")};
                }
            } else if (problemId == 26 || problemId == 27) {
                IJavaElement producerElement;
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null && (producerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Produces")) != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution(producerElement, "javax.enterprise.inject.Produces")};
                }
            } else if (problemId == 30) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "javax.inject.Named");
                if (ta != null && ta.annotation != null && ta.type != null) {
                    return new IQuickFix[]{new ChangeAnnotationMarkerResolution(ta.annotation), new DeleteAnnotationMarkerResolution((IJavaElement)ta.type, "javax.inject.Named")};
                }
            } else if (problemId == 31 || problemId == 32) {
                CDICoreNature cdiNature;
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "javax.inject.Named");
                if (ta != null && ta.type != null && (cdiNature = CDIUtil.getCDINatureWithProgress((IProject)ta.type.getUnderlyingResource().getProject())) != null) {
                    ICDIProject cdiProject = CDIUtil.getCDIProject((IFile)((IFile)compilationUnit.getUnderlyingResource()), (CDICoreNature)cdiNature, (boolean)asYouType);
                    IType declarationType = this.findNamedDeclarationType(cdiProject, ta.type, problemId == 32);
                    ArrayList<DeleteAnnotationMarkerResolution> resolutions = new ArrayList<DeleteAnnotationMarkerResolution>();
                    if (declarationType != null) {
                        IAnnotation annotation = this.getAnnotation((IJavaElement)declarationType, "javax.inject.Named");
                        if (annotation != null) {
                            resolutions.add(new DeleteAnnotationMarkerResolution((IJavaElement)declarationType, "javax.inject.Named"));
                        }
                        if (!declarationType.equals(ta.type) && (annotation = this.getAnnotation((IJavaElement)ta.type, declarationType.getFullyQualifiedName())) != null) {
                            resolutions.add(new DeleteAnnotationMarkerResolution((IJavaElement)ta.type, declarationType.getFullyQualifiedName()));
                        }
                    }
                    if (!resolutions.isEmpty()) {
                        return resolutions.toArray(new IQuickFix[0]);
                    }
                }
            } else if (problemId == 33) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "javax.enterprise.inject.Typed");
                if (ta != null && ta.annotation != null && ta.type != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution((IJavaElement)ta.type, "javax.enterprise.inject.Typed")};
                }
            } else if (problemId == 34 || problemId == 35) {
                TypeAndAnnotation ta = this.findTypeAndAnnotation(compilationUnit, offset, "javax.enterprise.inject.Specializes");
                if (ta != null && ta.annotation != null && ta.type != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution((IJavaElement)ta.type, "javax.enterprise.inject.Specializes")};
                }
            } else if (problemId == 36) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IJavaElement producerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Produces");
                    IJavaElement disposerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Disposes");
                    if (producerElement != null && disposerElement != null) {
                        return new IQuickFix[]{new DeleteAnnotationMarkerResolution(producerElement, "javax.enterprise.inject.Produces"), new DeleteAnnotationMarkerResolution(disposerElement, "javax.enterprise.inject.Disposes")};
                    }
                }
            } else if (problemId == 37) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IJavaElement producerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Produces");
                    IJavaElement observerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.event.Observes");
                    if (producerElement != null && observerElement != null) {
                        return new IQuickFix[]{new DeleteAnnotationMarkerResolution(producerElement, "javax.enterprise.inject.Produces"), new DeleteAnnotationMarkerResolution(observerElement, "javax.enterprise.event.Observes")};
                    }
                }
            } else if (problemId == 38) {
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null) {
                    IJavaElement disposerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.inject.Disposes");
                    IJavaElement observerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.event.Observes");
                    if (disposerElement != null && observerElement != null) {
                        return new IQuickFix[]{new DeleteAnnotationMarkerResolution(disposerElement, "javax.enterprise.inject.Disposes"), new DeleteAnnotationMarkerResolution(observerElement, "javax.enterprise.event.Observes")};
                    }
                }
            } else if (problemId == 39 || problemId == 40) {
                IJavaElement observerElement;
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null && (observerElement = this.findJavaElementByAnnotation(element, "javax.enterprise.event.Observes")) != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution(observerElement, "javax.enterprise.event.Observes")};
                }
            } else if (problemId == 41) {
                IJavaElement interceptorElement;
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null && (interceptorElement = this.findJavaElementByAnnotation(element, "javax.interceptor.Interceptor")) != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution(interceptorElement, "javax.interceptor.Interceptor")};
                }
            } else if (problemId == 42) {
                IJavaElement decoratorElement;
                IJavaElement element = this.findJavaElement(compilationUnit, offset);
                if (element != null && (decoratorElement = this.findJavaElementByAnnotation(element, "javax.decorator.Decorator")) != null) {
                    return new IQuickFix[]{new DeleteAnnotationMarkerResolution(decoratorElement, "javax.decorator.Decorator")};
                }
            } else {
                ILocalVariable parameter;
                if (problemId == 51) {
                    List<IMarkerResolution> resolutions = this.getAddNameResolutions(compilationUnit, offset, asYouType);
                    return resolutions.toArray(new IQuickFix[0]);
                }
                if (problemId == 52) {
                    ILocalVariable parameter2 = this.findParameter(compilationUnit, offset);
                    if (parameter2 != null) {
                        return new IQuickFix[]{new DeleteAllOtherAnnotationsFromParametersMarkerResolution("javax.enterprise.inject.Disposes", parameter2, (IFile)parameter2.getUnderlyingResource())};
                    }
                } else if (problemId == 53 && (parameter = this.findParameter(compilationUnit, offset)) != null) {
                    return new IQuickFix[]{new DeleteAllOtherAnnotationsFromParametersMarkerResolution("javax.enterprise.event.Observes", parameter, (IFile)parameter.getUnderlyingResource())};
                }
            }
        }
        return new IQuickFix[0];
    }

    private IMarkerResolution[] findResolutions(IMarker marker) throws CoreException {
        int messageId = this.getMessageID(marker);
        if (messageId == -1) {
            return new IMarkerResolution[0];
        }
        if (marker.getResource() instanceof IFile) {
            IFile file = (IFile)marker.getResource();
            Integer attribute = (Integer)marker.getAttribute("charStart");
            if (attribute == null) {
                return new IMarkerResolution[0];
            }
            int start = attribute;
            attribute = (Integer)marker.getAttribute("charEnd");
            if (attribute == null) {
                return new IMarkerResolution[0];
            }
            int end = attribute;
            ICDIMarkerResolutionGeneratorExtension[] extensions = CDIQuickFixExtensionManager.getInstances();
            if (JAVA_EXTENSION.equals(file.getFileExtension())) {
                ICompilationUnit compilationUnit = EclipseUtil.getCompilationUnit((IFile)file);
                return this.findJavaResolutions(compilationUnit, messageId, start, extensions, false);
            }
            if (XML_EXTENSION.equals(file.getFileExtension())) {
                return this.findXMLResolutions(file, messageId, start, end, false);
            }
        } else if (marker.getResource() instanceof IProject && messageId == 54) {
            return new IMarkerResolution[]{new CreateBeansXMLMarkerResolution((IProject)marker.getResource())};
        }
        return new IMarkerResolution[0];
    }

    private List<IMarkerResolution> getAddNameResolutions(ICompilationUnit compilationUnit, int start, boolean asYouType) throws JavaModelException {
        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
        ILocalVariable parameter = this.findParameter(compilationUnit, start);
        if (parameter != null) {
            IAnnotation namedAnnotation = this.getAnnotation((IJavaElement)parameter, "javax.inject.Named");
            if (namedAnnotation != null) {
                CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)compilationUnit.getUnderlyingResource().getProject());
                if (cdiNature == null) {
                    return resolutions;
                }
                ICDIProject cdiProject = CDIUtil.getCDIProject((IFile)((IFile)compilationUnit.getUnderlyingResource()), (CDICoreNature)cdiNature, (boolean)asYouType);
                if (cdiProject == null) {
                    return resolutions;
                }
                Collection allBeans = CDIUtil.getFilteredBeans((ICDIProject)cdiProject, (IPath)compilationUnit.getUnderlyingResource().getFullPath());
                IInjectionPoint ip = CDIUtil.findInjectionPoint((Collection)allBeans, (IJavaElement)parameter, (int)start);
                if (ip != null) {
                    List<IBean> beans = this.findLegalBeans(ip);
                    if (beans.size() == 0) {
                        beans = this.findBeans(ip);
                    }
                    if (beans.size() < 7) {
                        for (IBean bean : beans) {
                            if (bean.getName() == null || bean.getName().isEmpty()) continue;
                            resolutions.add((IMarkerResolution)new AddNameMarkerResolution(namedAnnotation, bean.getName()));
                        }
                    }
                }
            }
            if (resolutions.size() == 0) {
                resolutions.add((IMarkerResolution)new AddNameMarkerResolution(namedAnnotation, parameter.getElementName()));
            }
        }
        return resolutions;
    }

    private IType getTypeToAddAlternativeToBean(IJavaProject javaProject, String qualifiedName, boolean asYouType) throws JavaModelException {
        IClassBean classBean;
        ICDIProject cdiProject;
        CDICoreNature cdiNature;
        IType type = null;
        try {
            type = javaProject.findType(qualifiedName);
        }
        catch (JavaModelException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
        if (type != null && (cdiNature = CDIUtil.getCDINatureWithProgress((IProject)javaProject.getProject())) != null && (cdiProject = CDIUtil.getCDIProject((IFile)((IFile)type.getUnderlyingResource()), (CDICoreNature)cdiNature, (boolean)asYouType)) != null && (classBean = cdiProject.getBeanClass(type)) != null && !classBean.isAlternative()) {
            return type;
        }
        return null;
    }

    private IType getTypeToAddAlternativeToStereotype(IJavaProject javaProject, String qualifiedName, boolean asYouType) throws JavaModelException {
        IStereotype stereotype;
        ICDIProject cdiProject;
        CDICoreNature cdiNature;
        IType type = null;
        try {
            type = javaProject.findType(qualifiedName);
        }
        catch (JavaModelException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
        if (type != null && (cdiNature = CDIUtil.getCDINatureWithProgress((IProject)javaProject.getProject())) != null && (cdiProject = CDIUtil.getCDIProject((IFile)((IFile)type.getUnderlyingResource()), (CDICoreNature)cdiNature, (boolean)asYouType)) != null && (stereotype = cdiProject.getStereotype(qualifiedName)) != null && !stereotype.isAlternative()) {
            return type;
        }
        return null;
    }

    private IJavaElement findJavaElementByQualifiedName(IJavaProject javaProject, String qualifiedName) {
        try {
            return javaProject.findType(qualifiedName);
        }
        catch (JavaModelException ex) {
            CDIUIPlugin.getDefault().logError(ex);
            return null;
        }
    }

    private IType findNamedDeclarationType(ICDIProject cdiProject, IType type, boolean isItDecorator) {
        IType declarationType = null;
        Object bean = null;
        IAnnotationDeclaration declaration = null;
        bean = isItDecorator ? this.findDecoratorByType(cdiProject.getDecorators(), type) : this.findInterceptorByType(cdiProject.getInterceptors(), type);
        if (bean != null && (declaration = this.findNamedDeclaration((IStereotyped)bean)) != null) {
            declarationType = declaration.getType();
        }
        return declarationType;
    }

    private IDecorator findDecoratorByType(IDecorator[] decorators, IType type) {
        IDecorator[] iDecoratorArray = decorators;
        int n = decorators.length;
        int n2 = 0;
        while (n2 < n) {
            IDecorator decorator = iDecoratorArray[n2];
            if (decorator.getBeanClass().equals(type)) {
                return decorator;
            }
            ++n2;
        }
        return null;
    }

    private IInterceptor findInterceptorByType(IInterceptor[] interceptors, IType type) {
        IInterceptor[] iInterceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInterceptor interceptor = iInterceptorArray[n2];
            if (interceptor.getBeanClass().equals(type)) {
                return interceptor;
            }
            ++n2;
        }
        return null;
    }

    private IAnnotationDeclaration findNamedDeclaration(IStereotyped stereotyped) {
        IAnnotationDeclaration declaration = stereotyped.getAnnotation("javax.inject.Named");
        if (declaration == null) {
            declaration = CDIUtil.getNamedStereotypeDeclaration((IStereotyped)stereotyped);
        }
        return declaration;
    }

    private List<IBean> findLegalBeans(IInjectionPoint injectionPoint) {
        IBean[] bs = injectionPoint.getCDIProject().getBeans();
        String injectionPointTypeName = injectionPoint.getClassBean().getBeanClass().getFullyQualifiedName();
        String injectionPointPackage = null;
        int dotLastIndex = injectionPointTypeName.lastIndexOf(".");
        injectionPointPackage = dotLastIndex < 0 ? "" : injectionPointTypeName.substring(0, dotLastIndex);
        ArrayList<IBean> beans = new ArrayList<IBean>();
        IBean[] iBeanArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            IBean bean = iBeanArray[n2];
            if (CDIProject.containsType((Collection)bean.getLegalTypes(), (IParametedType)injectionPoint.getType())) {
                boolean isPublic = true;
                try {
                    isPublic = Flags.isPublic((int)bean.getBeanClass().getFlags());
                }
                catch (JavaModelException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                }
                String beanTypeName = bean.getBeanClass().getFullyQualifiedName();
                String beanPackage = null;
                dotLastIndex = beanTypeName.lastIndexOf(".");
                beanPackage = dotLastIndex < 0 ? "" : beanTypeName.substring(0, dotLastIndex);
                if ((isPublic || injectionPointPackage.equals(beanPackage)) && bean.getBeanClass().getResource() != null) {
                    beans.add(bean);
                }
            }
            ++n2;
        }
        return beans;
    }

    private IInjectionPoint findInjectionPoint(ICompilationUnit compilationUnit, int start, boolean asYouType) throws JavaModelException {
        IJavaElement element = this.findJavaElement(compilationUnit, start);
        if (element == null) {
            return null;
        }
        CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)compilationUnit.getUnderlyingResource().getProject());
        if (cdiNature == null) {
            return null;
        }
        ICDIProject cdiProject = CDIUtil.getCDIProject((IFile)((IFile)compilationUnit.getUnderlyingResource()), (CDICoreNature)cdiNature, (boolean)asYouType);
        if (cdiProject == null) {
            return null;
        }
        Collection allBeans = CDIUtil.getFilteredBeans((ICDIProject)cdiProject, (IPath)compilationUnit.getUnderlyingResource().getFullPath());
        IInjectionPoint ip = CDIUtil.findInjectionPoint((Collection)allBeans, (IJavaElement)element, (int)start);
        return ip;
    }

    private List<IBean> findBeans(IInjectionPoint injectionPoint) {
        ICDIProject cdiProject = injectionPoint.getCDIProject();
        List beans = CDIUtil.getSortedBeans((ICDIProject)cdiProject, (boolean)false, (IInjectionPoint)injectionPoint);
        int i = beans.size() - 1;
        while (i >= 0) {
            if (((IBean)beans.get(i)).getBeanClass().getResource() == null) {
                beans.remove(i);
            }
            --i;
        }
        return beans;
    }

    private IMethod findMethod(ICompilationUnit compilationUnit, int start) {
        IMethod method;
        IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
        if (javaElement instanceof IMethod && !(method = (IMethod)javaElement).isBinary()) {
            return method;
        }
        return null;
    }

    private IType findTypeWithNoSerializable(ICompilationUnit compilationUnit, int start) throws JavaModelException {
        IType type;
        IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
        if (javaElement instanceof IType && !(type = (IType)javaElement).isBinary()) {
            String[] interfaces;
            String shortName = CDIMarkerResolutionUtils.getShortName((String)"java.io.Serializable");
            String[] stringArray = interfaces = type.getSuperInterfaceNames();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(shortName)) {
                    return null;
                }
                ++n2;
            }
            return type;
        }
        return null;
    }

    private TypeAndAnnotation findTypeAndAnnotation(ICompilationUnit compilationUnit, int start, String annotationQualifiedName) throws JavaModelException {
        IType type;
        IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
        if (javaElement instanceof IType && !(type = (IType)javaElement).isBinary()) {
            IAnnotation annotation = this.getAnnotation((IJavaElement)type, annotationQualifiedName);
            if (annotation != null) {
                return new TypeAndAnnotation(type, annotation);
            }
            return new TypeAndAnnotation(type);
        }
        return null;
    }

    private IJavaElement findJavaElement(ICompilationUnit compilationUnit, int start) {
        try {
            return compilationUnit == null ? null : compilationUnit.getElementAt(start);
        }
        catch (JavaModelException ex) {
            CDIUIPlugin.getDefault().logError(ex);
            return null;
        }
    }

    private ILocalVariable findParameter(ICompilationUnit compilationUnit, int start) {
        IJavaElement element = this.findJavaElement(compilationUnit, start);
        if (element instanceof IMethod) {
            try {
                ILocalVariable[] iLocalVariableArray = ((IMethod)element).getParameters();
                int n = iLocalVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalVariable parameter = iLocalVariableArray[n2];
                    if (parameter.getSourceRange().getOffset() <= start && parameter.getSourceRange().getOffset() + parameter.getSourceRange().getLength() > start) {
                        return parameter;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException ex) {
                CDIUIPlugin.getDefault().logError(ex);
            }
        }
        return null;
    }

    private List<IType> findLocalAnnotattedInterfaces(IMethod method) throws JavaModelException {
        ArrayList<IType> types = new ArrayList<IType>();
        if (method.getTypeParameters().length > 0) {
            return types;
        }
        IType type = method.getDeclaringType();
        String[] is = type.getSuperInterfaceNames();
        int i = 0;
        while (i < is.length) {
            IAnnotation localAnnotation;
            String f = EclipseJavaUtil.resolveType((IType)type, (String)is[i]);
            IType t = EclipseResourceUtil.getValidType((IProject)type.getJavaProject().getProject(), (String)f);
            if (t != null && t.isInterface() && (localAnnotation = EclipseJavaUtil.findAnnotation((IType)t, (IAnnotatable)t, (String)"javax.ejb.Local")) != null) {
                if (this.isMethodExists(t, method)) {
                    types.clear();
                    return types;
                }
                types.add(t);
            }
            ++i;
        }
        return types;
    }

    private boolean isMethodExists(IType interfaceType, IMethod method) {
        IMethod existingMethod = interfaceType.getMethod(method.getElementName(), method.getParameterTypes());
        return existingMethod.exists();
    }

    private IField findNonStaticField(ICompilationUnit compilationUnit, int start) {
        try {
            IField field;
            IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
            if (javaElement instanceof IField && !Flags.isStatic((int)(field = (IField)javaElement).getFlags()) && !field.isBinary()) {
                return field;
            }
        }
        catch (JavaModelException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
        return null;
    }

    private IField findPublicField(ICompilationUnit compilationUnit, int start) {
        try {
            IField field;
            IJavaElement javaElement = this.findJavaElement(compilationUnit, start);
            if (javaElement instanceof IField && Flags.isPublic((int)(field = (IField)javaElement).getFlags()) && !field.isBinary()) {
                return field;
            }
        }
        catch (JavaModelException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
        return null;
    }

    public boolean hasResolutions(IMarker marker) {
        if (marker.exists()) {
            try {
                return this.getMessageID(marker) >= 0;
            }
            catch (CoreException ex) {
                CDIUIPlugin.getDefault().logError(ex);
            }
        }
        return false;
    }

    private IAnnotation getAnnotation(IJavaElement element, String annotationQualifiedName) {
        if (element instanceof IAnnotatable) {
            String shortName = CDIMarkerResolutionUtils.getShortName((String)annotationQualifiedName);
            try {
                IAnnotation[] annotations;
                IAnnotation[] iAnnotationArray = annotations = ((IAnnotatable)element).getAnnotations();
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    if (annotation.getElementName().equals(annotationQualifiedName) || annotation.getElementName().equals(shortName)) {
                        return annotation;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                CDIUIPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    private IJavaElement findJavaElementByAnnotation(IJavaElement element, String qualifiedName) throws JavaModelException {
        IAnnotation annotation = this.getAnnotation(element, qualifiedName);
        if (annotation != null) {
            return element;
        }
        if (element instanceof IMethod) {
            ILocalVariable[] iLocalVariableArray = ((IMethod)element).getParameters();
            int n = iLocalVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable parameter = iLocalVariableArray[n2];
                annotation = this.getAnnotation((IJavaElement)parameter, qualifiedName);
                if (annotation != null) {
                    return parameter;
                }
                ++n2;
            }
        } else if (element instanceof ILocalVariable) {
            IJavaElement parent = element.getParent();
            if (parent != null && (annotation = this.getAnnotation(parent, qualifiedName)) != null) {
                return parent;
            }
        } else if (element instanceof IType) {
            IField[] iFieldArray = ((IType)element).getFields();
            int n = iFieldArray.length;
            int n3 = 0;
            while (n3 < n) {
                IField field = iFieldArray[n3];
                annotation = this.getAnnotation((IJavaElement)field, qualifiedName);
                if (annotation != null) {
                    return field;
                }
                ++n3;
            }
            iFieldArray = ((IType)element).getMethods();
            n = iFieldArray.length;
            n3 = 0;
            while (n3 < n) {
                IField method = iFieldArray[n3];
                annotation = this.getAnnotation((IJavaElement)method, qualifiedName);
                if (annotation != null) {
                    return method;
                }
                ILocalVariable[] iLocalVariableArray = method.getParameters();
                int n4 = iLocalVariableArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    ILocalVariable parameter = iLocalVariableArray[n5];
                    annotation = this.getAnnotation((IJavaElement)parameter, qualifiedName);
                    if (annotation != null) {
                        return parameter;
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        if (element instanceof IMember && (annotation = this.getAnnotation((IJavaElement)((IMember)element).getDeclaringType(), qualifiedName)) != null) {
            return ((IMember)element).getDeclaringType();
        }
        return null;
    }

    public boolean hasProposals(Annotation annotation, Position position) {
        return annotation instanceof TempJavaProblemAnnotation || annotation instanceof TemporaryAnnotation;
    }

    public IJavaCompletionProposal[] getProposals(Annotation annotation, Position position) {
        if (annotation instanceof TempJavaProblemAnnotation) {
            TempJavaProblemAnnotation javaAnnotation = (TempJavaProblemAnnotation)annotation;
            int messageId = javaAnnotation.getId() - -2013265920;
            ICompilationUnit compilationUnit = javaAnnotation.getCompilationUnit();
            if (compilationUnit != null) {
                int start = position.getOffset();
                ICDIMarkerResolutionGeneratorExtension[] extensions = CDIQuickFixExtensionManager.getInstances();
                try {
                    return this.findJavaResolutions(compilationUnit, messageId, start, extensions, true);
                }
                catch (JavaModelException e) {
                    CDIUIPlugin.getDefault().logError(e);
                }
            }
        } else if (annotation instanceof TemporaryAnnotation) {
            TemporaryAnnotation tempAnnotation = (TemporaryAnnotation)annotation;
            IFile file = MarkerResolutionUtils.getFile();
            int messageId = this.getMessageID(tempAnnotation);
            int start = tempAnnotation.getPosition().getOffset();
            int end = start + tempAnnotation.getPosition().getLength();
            try {
                return this.findXMLResolutions(file, messageId, start, end, true);
            }
            catch (JavaModelException e) {
                CDIUIPlugin.getDefault().logError(e);
            }
        }
        return new IJavaCompletionProposal[0];
    }

    class TypeAndAnnotation {
        IType type;
        IAnnotation annotation;

        public TypeAndAnnotation(IType type) {
            this.type = type;
        }

        public TypeAndAnnotation(IType type, IAnnotation annotation) {
            this(type);
            this.annotation = annotation;
        }
    }
}

