/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.wizards;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.jobs.RefreshTutorialsJob;
import org.jboss.tools.central.wizards.ErrorPage;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;

public abstract class AbstractJBossCentralProjectWizard
extends NewProjectExamplesWizard2 {
    private String exampleName = null;

    public AbstractJBossCentralProjectWizard(String exampleName) {
        Assert.isNotNull((Object)exampleName, (String)"Project name is null");
        this.exampleName = exampleName;
        ProjectExample example = this.lookupProjectExample();
        this.initializeProjectExample(example);
    }

    protected ProjectExample lookupProjectExample() {
        ProjectExample example = null;
        RefreshTutorialsJob refreshTutorialsJob = RefreshTutorialsJob.INSTANCE;
        List<ProjectExample> wizardProjects = refreshTutorialsJob.getWizardProjects();
        if (wizardProjects == null || wizardProjects.isEmpty()) {
            RunnableLookup lookup = new RunnableLookup();
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)lookup);
            }
            catch (Exception e) {
                JBossCentralActivator.log(e);
            }
            wizardProjects = refreshTutorialsJob.getWizardProjects();
        }
        if (wizardProjects != null) {
            for (ProjectExample expl : wizardProjects) {
                if (!this.matches(expl)) continue;
                example = expl;
                break;
            }
        }
        return example;
    }

    private boolean matches(ProjectExample expl) {
        return expl != null && this.exampleName.equals(expl.getName());
    }

    public void addPages() {
        if (this.getProjectExample() == null) {
            this.addPage((IWizardPage)new ErrorPage("Failed to load Wizard", "Wizard metadata could not be loaded"));
        } else {
            super.addPages();
        }
    }

    protected void initializeDefaultPageImageDescriptor() {
        String imagePath = this.getWizardBackgroundImagePath();
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jboss.tools.central", (String)imagePath);
        this.setDefaultPageImageDescriptor(desc);
    }

    protected String getWizardBackgroundImagePath() {
        return "icons/new_wiz.gif";
    }

    class RunnableLookup
    implements IRunnableWithProgress {
        RunnableLookup() {
        }

        public void run(IProgressMonitor monitor) {
            monitor.setTaskName("Refreshing project examples");
            RefreshTutorialsJob refreshTutorialsJob = RefreshTutorialsJob.INSTANCE;
            int jobState = refreshTutorialsJob.getState();
            try {
                if (jobState == 0) {
                    refreshTutorialsJob.schedule();
                }
                refreshTutorialsJob.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

