/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.model.ProjectFix;

public class RefreshTutorialsJob
extends Job {
    private Exception exception;
    private Map<ProjectExampleCategory, List<ProjectExample>> tutorialCategories;
    private List<ProjectExample> wizardProjects;
    public static RefreshTutorialsJob INSTANCE = new RefreshTutorialsJob();

    private RefreshTutorialsJob() {
        super("Refreshing JBoss Tutorials...");
        this.setPriority(30);
    }

    public IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        List categories = ProjectExampleUtil.getProjects((IProgressMonitor)monitor);
        this.wizardProjects = ProjectExampleUtil.getProjectsByTags((Collection)categories, (String[])new String[]{"wizard"});
        List tutorials = ProjectExampleUtil.getProjectsByTags((Collection)categories, (String[])new String[]{"central"});
        if (this.tutorialCategories == null) {
            this.tutorialCategories = new HashMap<ProjectExampleCategory, List<ProjectExample>>();
        } else {
            this.tutorialCategories.clear();
        }
        for (ProjectExample project : tutorials) {
            if (!this.canBeImported(project)) continue;
            ArrayList<ProjectFix> unsatisfiedFixes = new ArrayList<ProjectFix>();
            List fixes = project.getFixes();
            project.setUnsatisfiedFixes(unsatisfiedFixes);
            for (ProjectFix fix : fixes) {
                if (ProjectExamplesActivator.canFix((ProjectExample)project, (ProjectFix)fix)) continue;
                unsatisfiedFixes.add(fix);
            }
            ProjectExampleCategory category = project.getCategory();
            List<ProjectExample> projects = this.tutorialCategories.get(category);
            if (projects == null) {
                projects = new ArrayList<ProjectExample>();
                this.tutorialCategories.put(category, projects);
            }
            projects.add(project);
        }
        return Status.OK_STATUS;
    }

    private boolean canBeImported(ProjectExample project) {
        return ProjectExamplesActivator.getDefault().getImportProjectExample(project.getImportType()) != null;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Map<ProjectExampleCategory, List<ProjectExample>> getTutorialCategories() {
        return this.tutorialCategories;
    }

    public List<ProjectExample> getWizardProjects() {
        return this.wizardProjects;
    }

    public boolean belongsTo(Object family) {
        return family == JBossCentralActivator.JBOSS_CENTRAL_FAMILY;
    }
}

