/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.jobs;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.model.FeedsEntry;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.project.examples.ProjectExamplesActivator;

public abstract class AbstractRefreshJob
extends Job {
    private static final int TIME_OUT = 2000;
    protected List<FeedsEntry> entries = new ArrayList<FeedsEntry>();
    protected Throwable exception;
    protected long cacheModified;
    private String urlString;
    private File cacheFile;
    private boolean forcedDownload = false;
    private boolean needsRefresh = true;

    @Deprecated
    public AbstractRefreshJob(String name, String urlString) {
        this(name);
        this.urlString = urlString;
    }

    public AbstractRefreshJob(String name) {
        super(name);
        this.setPriority(30);
        this.cacheFile = this.getCacheFile();
        if (this.cacheFile.exists()) {
            this.cacheModified = this.cacheFile.lastModified();
            try {
                this.getEntries(this.cacheFile);
            }
            catch (FileNotFoundException e) {
                JBossCentralActivator.log(e);
            }
            catch (IllegalArgumentException e) {
                JBossCentralActivator.log(e);
            }
            catch (FeedException e) {
                JBossCentralActivator.log(e);
            }
            catch (IOException e) {
                JBossCentralActivator.log(e);
            }
        }
    }

    public abstract File getCacheFile();

    public abstract File getValidCacheFile();

    protected void getEntries(File file) throws IOException, IllegalArgumentException, FeedException {
        this.entries.clear();
        this.needsRefresh = true;
        FileInputStream in = new FileInputStream(file);
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)in));
        List feeds = syndFeed.getEntries();
        if (feeds == null || feeds.size() == 0) {
            return;
        }
        int i = 0;
        for (SyndEntry feed : feeds) {
            FeedsEntry entry = this.adaptEntry(feed);
            if (entry == null) continue;
            if (i++ > 100) break;
            this.entries.add(entry);
        }
    }

    private FeedsEntry adaptEntry(SyndEntry entry) {
        FeedsEntry.Type type;
        String author;
        SyndContent desc;
        List contents;
        SyndContent desc2;
        if (entry == null) {
            return null;
        }
        String title = null;
        if (entry.getTitle() != null) {
            title = entry.getTitle();
        } else {
            SyndContent titleEx = entry.getTitleEx();
            if (titleEx != null && !titleEx.getValue().isEmpty()) {
                title = titleEx.getValue();
            }
        }
        if (title == null) {
            return null;
        }
        title = StringEscapeUtils.escapeHtml((String)title);
        String link = entry.getUri() == null || entry.getUri().trim().isEmpty() ? entry.getLink() : entry.getUri();
        String description = null;
        if (entry.getDescription() != null && (desc2 = entry.getDescription()) != null && !desc2.getValue().isEmpty()) {
            description = desc2.getValue();
        }
        if (description == null && (contents = entry.getContents()) != null && contents.size() > 0 && (desc = (SyndContent)contents.get(0)) != null && !desc.getValue().isEmpty()) {
            description = desc.getValue();
        }
        Date date = entry.getUpdatedDate() != null ? entry.getUpdatedDate() : entry.getPublishedDate();
        boolean isTwitterEntry = this.isTwitterEntry(entry);
        String string = author = entry.getAuthor() == null ? "unknown author" : entry.getAuthor();
        if (isTwitterEntry) {
            type = FeedsEntry.Type.TWITTER;
            author = author.replace("@twitter.com", "");
        } else {
            type = FeedsEntry.Type.BLOG;
        }
        return new FeedsEntry(title, link, description, author, date, type);
    }

    private boolean isTwitterEntry(SyndEntry entry) {
        return entry.getUri() != null && entry.getUri().contains("://twitter.com/") && entry.getAuthor().contains("@twitter.com");
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public List<FeedsEntry> getEntries() {
        return this.entries;
    }

    public String getUrlString() {
        return this.urlString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.exception = null;
        long urlModified = -1L;
        if (!this.forcedDownload) {
            urlModified = this.getUrlModified();
            if (this.exception != null) {
                return Status.CANCEL_STATUS;
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.forcedDownload || this.cacheModified == 0L || urlModified != this.cacheModified) {
            try {
                File tempFile = File.createTempFile("news", ".xml");
                tempFile.deleteOnExit();
                FileOutputStream destination = new FileOutputStream(tempFile);
                IStatus status = new URLTransportUtility().download(this.cacheFile.getName(), this.getUrlString(), (OutputStream)destination, 2000, monitor);
                URL url = this.getURL();
                if (monitor.isCanceled()) {
                    return this.getValidEntries(monitor);
                }
                if (status.isOK() && url != null) {
                    this.cacheModified = new URLTransportUtility().getLastModified(url);
                    ProjectExamplesActivator.copyFile((File)tempFile, (File)this.cacheFile);
                    tempFile.delete();
                    if (monitor.isCanceled()) {
                        return this.getValidEntries(monitor);
                    }
                    this.cacheFile.setLastModified(this.cacheModified);
                    this.getEntries(this.cacheFile);
                } else {
                    this.setException(status.getException());
                }
            }
            catch (Exception exception) {
                return this.getValidEntries(monitor);
            }
        }
        if (monitor.isCanceled()) {
            return this.getValidEntries(monitor);
        }
        if (this.getEntries().size() <= 0) return this.getValidEntries(monitor);
        try {
            File validCacheFile = this.getValidCacheFile();
            if (validCacheFile.isFile() && this.cacheFile.lastModified() == validCacheFile.lastModified()) return Status.OK_STATUS;
            ProjectExamplesActivator.copyFile((File)this.cacheFile, (File)this.getValidCacheFile());
            validCacheFile.setLastModified(this.cacheFile.lastModified());
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.exception = e;
            return this.getValidEntries(monitor);
        }
    }

    protected IStatus getValidEntries(IProgressMonitor monitor) {
        File file = this.getValidCacheFile();
        if (file.isFile()) {
            try {
                this.getEntries(file);
            }
            catch (Exception e) {
                this.exception = e;
                return Status.CANCEL_STATUS;
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private long getUrlModified() {
        long urlModified;
        URL url = this.getURL();
        if (this.exception != null) {
            return -1L;
        }
        try {
            urlModified = new URLTransportUtility().getLastModified(url);
        }
        catch (CoreException e) {
            this.exception = e;
            urlModified = -1L;
        }
        return urlModified;
    }

    private URL getURL() {
        try {
            URL url = new URL(this.getUrlString());
            return url;
        }
        catch (MalformedURLException e) {
            this.exception = e;
            return null;
        }
    }

    public boolean isForcedDownload() {
        return this.forcedDownload;
    }

    public void setForcedDownload(boolean forced) {
        this.forcedDownload = forced;
    }

    public boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setNeedsRefresh(boolean needRefresh) {
        this.needsRefresh = needRefresh;
    }

    public boolean belongsTo(Object family) {
        return family == JBossCentralActivator.JBOSS_CENTRAL_FAMILY;
    }
}

