/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.installation;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.installation.BundleFamilyExtension;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;

public class InstallationChecker {
    private static InstallationChecker INSTANCE;
    private static String EARLY_ACCESS_FAMILY_ID;
    private static String EXTENSION_POINT_ID;
    private Map<String, BundleFamilyExtension> iuFamilies = new HashMap<String, BundleFamilyExtension>();
    private Map<String, Set<IInstallableUnit>> installedUnitsPerFamily;

    static {
        EARLY_ACCESS_FAMILY_ID = "earlyaccess";
        EXTENSION_POINT_ID = "org.jboss.tools.central.iuFamilies";
    }

    private InstallationChecker() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            String familyId = extension.getAttribute("familyId");
            String label = extension.getAttribute("label");
            String urlKey = extension.getAttribute("urlKey");
            String url = PropertiesHelper.getPropertiesProvider().getValue(urlKey);
            String contributingBundleId = extension.getContributor().getName();
            URL listingFileResource = Platform.getBundle((String)contributingBundleId).getEntry(extension.getAttribute("listingFile"));
            this.iuFamilies.put(familyId, new BundleFamilyExtension(familyId, label, listingFileResource, url));
            if (listingFileResource == null) {
                JBossCentralActivator.log("Could not load default listing file for " + familyId);
            }
            ++n2;
        }
        this.installedUnitsPerFamily = new HashMap<String, Set<IInstallableUnit>>();
    }

    public static InstallationChecker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstallationChecker();
        }
        return INSTANCE;
    }

    public boolean hasEarlyAccess() {
        return !this.getEarlyAccessUnits().isEmpty();
    }

    public Set<IInstallableUnit> getEarlyAccessUnits() {
        return this.getUnits(EARLY_ACCESS_FAMILY_ID);
    }

    public Set<IInstallableUnit> getUnits(String family) {
        if (!this.installedUnitsPerFamily.containsKey(family)) {
            IProvisioningAgent agent;
            IProvisioningAgentProvider provider = (IProvisioningAgentProvider)PlatformUI.getWorkbench().getService(IProvisioningAgentProvider.class);
            try {
                agent = provider.createAgent(null);
            }
            catch (ProvisionException ex) {
                throw new RuntimeException(ex);
            }
            if (agent == null) {
                throw new RuntimeException("Location was not provisioned by p2");
            }
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
            if (profileRegistry == null) {
                throw new RuntimeException("Unable to acquire the profile registry service.");
            }
            IProfile profile = profileRegistry.getProfile("_SELF_");
            BundleFamilyExtension entry = this.iuFamilies.get(family);
            Map<String, Set<VersionRange>> iusForFamily = entry.loadBundleList();
            HashSet foundFamilyUnits = new HashSet();
            for (Map.Entry<String, Set<VersionRange>> iuVersions : iusForFamily.entrySet()) {
                String iuId = iuVersions.getKey();
                for (VersionRange versionRange : iuVersions.getValue()) {
                    IQuery query = QueryUtil.createIUQuery((String)iuId, (VersionRange)versionRange);
                    IQueryResult res = profile.query(query, (IProgressMonitor)new NullProgressMonitor());
                    foundFamilyUnits.addAll(res.toSet());
                }
            }
            this.installedUnitsPerFamily.put(family, foundFamilyUnits);
        }
        return Collections.unmodifiableSet(this.installedUnitsPerFamily.get(family));
    }
}

