/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors.xpl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.Messages;
import org.jboss.tools.central.editors.xpl.DiscoveryViewer;
import org.jboss.tools.central.editors.xpl.P2CachedRepoUtil;

public class ConnectorDescriptorItemUi
implements PropertyChangeListener,
Runnable {
    private static final ISchedulingRule SINGLE_JOB_RULE = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule arg0) {
            return arg0 == this;
        }

        public boolean contains(ISchedulingRule arg0) {
            return arg0 == this;
        }
    };
    private DiscoveryConnector connector;
    private Map<String, Version> connectorUnits;
    private ConnectorInstallationStatus installationStatus = ConnectorInstallationStatus.UNKNOWN;
    private boolean visible;
    private DiscoveryViewer discoveryViewer;
    private Job connectorUnitJob;
    private final Button checkbox;
    private final Label iconLabel;
    private final Label nameLabel;
    private final Label statusLabel;
    private ToolItem infoButton;
    private final Link providerLabel;
    private final Label description;
    private final Composite checkboxContainer;
    private final Composite connectorContainer;
    private final Display display;
    private Image iconImage;
    private static final String COLOR_DARK_GRAY = "DarkGray";
    private Color colorDisabled;
    private Font titleFont;
    private Image infoImage;
    private Set<Resource> disposables = new HashSet<Resource>();

    public ConnectorDescriptorItemUi(DiscoveryViewer discoveryViewer, final DiscoveryConnector connector, Composite categoryChildrenContainer, Color background, Font titleFont, Image infoImage) {
        if (this.colorDisabled == null) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_DARK_GRAY)) {
                colorRegistry.put(COLOR_DARK_GRAY, new RGB(105, 105, 105));
            }
            this.colorDisabled = colorRegistry.get(COLOR_DARK_GRAY);
        }
        this.discoveryViewer = discoveryViewer;
        this.titleFont = titleFont;
        this.connector = connector;
        this.infoImage = infoImage;
        this.display = categoryChildrenContainer.getDisplay();
        connector.addPropertyChangeListener((PropertyChangeListener)this);
        this.connectorContainer = new Composite(categoryChildrenContainer, 0);
        this.connectorContainer.setBackground(background);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.connectorContainer);
        GridLayout layout = new GridLayout(5, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        this.connectorContainer.setLayout((Layout)layout);
        this.checkboxContainer = new Composite(this.connectorContainer, 0);
        this.checkboxContainer.setBackground(background);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)this.checkboxContainer);
        GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(2).applyTo(this.checkboxContainer);
        this.checkbox = new Button(this.checkboxContainer, 32);
        this.checkbox.setText(" ");
        this.checkbox.setData("connectorId", (Object)connector.getId());
        this.checkbox.setVisible(connector.isInstallable());
        this.checkbox.setBackground(background);
        this.checkbox.setSelection(connector.isSelected());
        this.checkbox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ConnectorDescriptorItemUi.this.discoveryViewer.showConnectorControl(ConnectorDescriptorItemUi.this);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.checkbox);
        this.iconLabel = new Label(this.checkboxContainer, 0);
        this.iconLabel.setBackground(background);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.iconLabel);
        if (connector.getIcon() != null) {
            this.iconImage = DiscoveryViewer.computeIconImage(connector.getSource(), connector.getIcon(), 32, false);
            this.disposables.add((Resource)this.iconImage);
            if (this.iconImage != null) {
                this.iconLabel.setImage(this.iconImage);
            }
        }
        this.nameLabel = new Label(this.connectorContainer, 0);
        this.nameLabel.setBackground(background);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.titleFont);
        this.nameLabel.setText(connector.getName());
        this.statusLabel = new Label(this.connectorContainer, 0);
        this.statusLabel.setBackground(background);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.statusLabel);
        this.setUpToDateStatus();
        if (this.connector.isInstalled()) {
            this.createAndScheduleConnectorUnitJob();
        }
        this.providerLabel = new Link(this.connectorContainer, 131072);
        this.providerLabel.setBackground(background);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.providerLabel);
        if (connector.getCertification() != null) {
            this.providerLabel.setText(NLS.bind((String)Messages.DiscoveryViewer_Certification_Label0, (Object[])new String[]{connector.getProvider(), connector.getLicense(), connector.getCertification().getName()}));
            if (connector.getCertification().getUrl() != null) {
                this.providerLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BrowserUtil.openUrl((String)connector.getCertification().getUrl(), (int)128);
                    }
                });
            }
            Overview overview = new Overview();
            overview.setSummary(connector.getCertification().getDescription());
            overview.setUrl(connector.getCertification().getUrl());
            Image image = DiscoveryViewer.computeIconImage(connector.getSource(), connector.getCertification().getIcon(), 48, true);
            DiscoveryViewer.hookTooltip((Control)this.providerLabel, (Widget)this.providerLabel, (Control)this.connectorContainer, (Control)this.providerLabel, connector.getSource(), overview, image);
        } else {
            this.providerLabel.setText(NLS.bind((String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_provider_and_license, (Object)connector.getProvider(), (Object)connector.getLicense()));
        }
        if (this.hasTooltip(connector)) {
            ToolBar toolBar = new ToolBar(this.connectorContainer, 0x800000);
            toolBar.setBackground(background);
            this.infoButton = new ToolItem(toolBar, 8);
            this.infoButton.setImage(this.infoImage);
            this.infoButton.setToolTipText(org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
            DiscoveryViewer.hookTooltip((Control)toolBar, (Widget)this.infoButton, (Control)this.connectorContainer, (Control)this.nameLabel, connector.getSource(), connector.getOverview(), null);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        } else {
            Label label = new Label(this.connectorContainer, 0);
            label.setText(" ");
            label.setBackground(background);
        }
        this.description = new Label(this.connectorContainer, 64);
        this.description.setBackground(background);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(100, -1).applyTo((Control)this.description);
        String descriptionText = connector.getDescription();
        int maxDescriptionLength = 162;
        if (descriptionText.length() > maxDescriptionLength) {
            descriptionText = descriptionText.substring(0, maxDescriptionLength);
        }
        this.description.setText(descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " "));
        this.providerLabel.setForeground(this.colorDisabled);
        this.checkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ConnectorDescriptorItemUi.this.checkbox.getSelection();
                ConnectorDescriptorItemUi.this.maybeModifySelection(selected);
            }
        });
        MouseAdapter connectorItemMouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                boolean selected;
                boolean bl = selected = !ConnectorDescriptorItemUi.this.checkbox.getSelection();
                if (ConnectorDescriptorItemUi.this.maybeModifySelection(selected)) {
                    ConnectorDescriptorItemUi.this.checkbox.setSelection(selected);
                }
            }
        };
        this.checkboxContainer.addMouseListener((MouseListener)connectorItemMouseListener);
        this.connectorContainer.addMouseListener((MouseListener)connectorItemMouseListener);
        this.iconLabel.addMouseListener((MouseListener)connectorItemMouseListener);
        this.nameLabel.addMouseListener((MouseListener)connectorItemMouseListener);
        this.description.addMouseListener((MouseListener)connectorItemMouseListener);
    }

    private void createAndScheduleConnectorUnitJob() {
        this.connectorUnitJob = new Job("Computing connector status"){
            private boolean cancelled;

            protected IStatus run(IProgressMonitor arg0) {
                ConnectorDescriptorItemUi.this.connectorUnits = ConnectorDescriptorItemUi.resolveConnectorUnits((ConnectorDescriptor)ConnectorDescriptorItemUi.this.connector);
                if (ConnectorDescriptorItemUi.this.connector.isInstalled() && ConnectorDescriptorItemUi.this.connectorUnits != null) {
                    Map profileUnits = ConnectorDescriptorItemUi.resolveProfileUnits(ConnectorDescriptorItemUi.this.connector.getInstallableUnits());
                    if (profileUnits != null && !profileUnits.isEmpty()) {
                        for (String unitId : ConnectorDescriptorItemUi.this.connector.getInstallableUnits()) {
                            Version version = (Version)profileUnits.get(unitId);
                            Version connectorUnitVersion = (Version)ConnectorDescriptorItemUi.this.connectorUnits.get(unitId);
                            if (connectorUnitVersion == null) {
                                JBossCentralActivator.log("Could not resolve remote IU '" + unitId + "' in repository '" + ConnectorDescriptorItemUi.this.connector.getSiteUrl() + "'");
                                continue;
                            }
                            if (version == null) continue;
                            int compare = version.compareTo((Object)connectorUnitVersion);
                            if (compare == 0) {
                                ConnectorDescriptorItemUi.this.installationStatus = ConnectorInstallationStatus.UP_TO_DATE;
                                ConnectorDescriptorItemUi.this.discoveryViewer.modifySelection(ConnectorDescriptorItemUi.this, ConnectorDescriptorItemUi.this.connector.isSelected());
                                break;
                            }
                            if (compare <= 0) {
                                ConnectorDescriptorItemUi.this.installationStatus = ConnectorInstallationStatus.UPDATE_AVAILABLE;
                                break;
                            }
                            if (compare < 0) continue;
                            ConnectorDescriptorItemUi.this.installationStatus = ConnectorInstallationStatus.MORE_RECENT_VERSION_INSTALLED;
                            ConnectorDescriptorItemUi.this.discoveryViewer.modifySelection(ConnectorDescriptorItemUi.this, ConnectorDescriptorItemUi.this.connector.isSelected());
                            break;
                        }
                    }
                    if (this.cancelled) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!ConnectorDescriptorItemUi.this.checkboxContainer.isDisposed()) {
                        ConnectorDescriptorItemUi.this.checkboxContainer.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ConnectorDescriptorItemUi.this.setUpToDateStatus();
                            }
                        });
                    }
                }
                return Status.CANCEL_STATUS;
            }

            protected void canceling() {
                this.cancelled = true;
            }
        };
        this.connectorUnitJob.setSystem(true);
        if (this.connector.isInstalled()) {
            this.connectorUnitJob.setPriority(20);
        } else {
            this.connectorUnitJob.setPriority(30);
        }
        this.connectorUnitJob.setRule(SINGLE_JOB_RULE);
        this.connectorUnitJob.belongsTo((Object)this.discoveryViewer);
        this.connectorUnitJob.schedule();
    }

    private void setUpToDateStatus() {
        if (!this.connector.isInstalled() || this.statusLabel.isDisposed() || this.getControl().isDisposed()) {
            return;
        }
        String text = "(INSTALLED";
        if (this.installationStatus == ConnectorInstallationStatus.UP_TO_DATE) {
            text = String.valueOf(text) + " - UP TO DATE";
            this.statusLabel.setForeground(this.getControl().getDisplay().getSystemColor(6));
        } else if (this.installationStatus == ConnectorInstallationStatus.UPDATE_AVAILABLE) {
            text = String.valueOf(text) + " - UPDATE AVAILABLE";
            this.statusLabel.setForeground(this.getControl().getShell().getDisplay().getSystemColor(8));
        } else if (this.installationStatus == ConnectorInstallationStatus.MORE_RECENT_VERSION_INSTALLED) {
            text = String.valueOf(text) + " - MORE RECENT VERSION INSTALLED";
            this.statusLabel.setForeground(this.getControl().getDisplay().getSystemColor(6));
        }
        text = String.valueOf(text) + ")";
        this.statusLabel.setText(text);
    }

    private static Map<String, Version> resolveProfileUnits(List<String> installableUnits) {
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)PlatformUI.getWorkbench().getService(IProvisioningAgentProvider.class);
        if (provider == null) {
            return null;
        }
        try {
            IProvisioningAgent agent = provider.createAgent(null);
            if (agent == null) {
                throw new RuntimeException("Location was not provisioned by p2");
            }
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
            if (profileRegistry == null) {
                throw new RuntimeException("Unable to acquire the profile registry service.");
            }
            IProfile profile = profileRegistry.getProfile("_SELF_");
            HashMap<String, Version> res = new HashMap<String, Version>();
            for (String installableUnit : installableUnits) {
                IQueryResult queryResult = profile.query(QueryUtil.createIUQuery((String)installableUnit), (IProgressMonitor)new NullProgressMonitor());
                for (IInstallableUnit unit : queryResult) {
                    Version previousVersion = (Version)res.get(installableUnit);
                    if (previousVersion != null && previousVersion.compareTo((Object)unit.getVersion()) >= 0) continue;
                    res.put(installableUnit, unit.getVersion());
                }
            }
            return res;
        }
        catch (ProvisionException ex) {
            JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.central", ex.getMessage(), (Throwable)ex));
            return null;
        }
    }

    private static Map<String, Version> resolveConnectorUnits(ConnectorDescriptor connector) {
        IMetadataRepository repo = P2CachedRepoUtil.getRepoForConnector(connector);
        if (repo == null) {
            return null;
        }
        HashMap<String, Version> res = new HashMap<String, Version>();
        for (String unitId : connector.getInstallableUnits()) {
            IQueryResult queryResult = repo.query(QueryUtil.createIUQuery((String)unitId), (IProgressMonitor)new NullProgressMonitor());
            for (IInstallableUnit unit : queryResult) {
                Version previousVersion = (Version)res.get(unitId);
                if (previousVersion != null && previousVersion.compareTo((Object)unit.getVersion()) >= 0) continue;
                res.put(unitId, unit.getVersion());
            }
        }
        return res;
    }

    public boolean isUpToDate() {
        return this.installationStatus == ConnectorInstallationStatus.MORE_RECENT_VERSION_INSTALLED || this.installationStatus == ConnectorInstallationStatus.UP_TO_DATE;
    }

    protected boolean maybeModifySelection(boolean selected) {
        if (selected) {
            if (!this.connector.isInstalled() && !this.connector.isInstallable()) {
                if (this.connector.getInstallMessage() != null) {
                    MessageDialog.openInformation((Shell)this.checkbox.getShell(), (String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.DiscoveryViewer_Install_Connector_Title, (String)this.connector.getInstallMessage());
                }
                return false;
            }
            if (this.connector.getAvailable() != null && !this.connector.getAvailable().booleanValue()) {
                MessageDialog.openWarning((Shell)this.checkbox.getShell(), (String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_warningTitleConnectorUnavailable, (String)NLS.bind((String)org.eclipse.mylyn.internal.discovery.ui.wizards.Messages.ConnectorDiscoveryWizardMainPage_warningMessageConnectorUnavailable, (Object)this.connector.getName()));
                return false;
            }
        }
        this.discoveryViewer.modifySelection(this, selected);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.display.asyncExec((Runnable)this);
    }

    @Override
    public void run() {
        if (!this.connectorContainer.isDisposed()) {
            this.updateAvailability();
        }
    }

    public void updateAvailability() {
        boolean enabled = !this.connector.isInstalled() && (this.connector.getAvailable() == null || this.connector.getAvailable() != false);
        this.checkbox.setEnabled(enabled);
        this.nameLabel.setEnabled(enabled);
        this.providerLabel.setEnabled(enabled);
        this.description.setEnabled(enabled);
        Color foreground = enabled ? this.connectorContainer.getForeground() : this.colorDisabled;
        this.nameLabel.setForeground(foreground);
        this.description.setForeground(foreground);
        if (this.iconImage != null) {
            this.iconLabel.setImage(this.iconImage);
        }
    }

    void select(boolean select) {
        if (!this.checkbox.isDisposed() && this.checkbox.isVisible() && this.checkbox.getSelection() != select) {
            this.checkbox.setSelection(select);
            this.connector.setSelected(select);
            this.maybeModifySelection(select);
        }
    }

    boolean hasTooltip(DiscoveryConnector connector) {
        return connector.getOverview() != null && connector.getOverview().getSummary() != null && connector.getOverview().getSummary().length() > 0;
    }

    public void dispose() {
        if (this.connectorUnitJob != null) {
            this.connectorUnitJob.cancel();
        }
        for (Resource resource : this.disposables) {
            resource.dispose();
        }
    }

    public Control getControl() {
        return this.connectorContainer;
    }

    public DiscoveryConnector getConnector() {
        return this.connector;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        ((GridData)this.connectorContainer.getLayoutData()).exclude = !visible;
        this.connectorContainer.setVisible(visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Map<String, Version> getConnectorUnits() {
        if (this.connectorUnitJob == null) {
            this.createAndScheduleConnectorUnitJob();
        }
        if (this.isComputingUnits()) {
            try {
                this.connectorUnitJob.setPriority(10);
                this.connectorUnitJob.join();
            }
            catch (InterruptedException ex) {
                JBossCentralActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.central", ex.getMessage(), (Throwable)ex));
            }
        }
        return this.connectorUnits;
    }

    public boolean isComputingUnits() {
        return this.connectorUnitJob != null && this.connectorUnitJob.getState() != 0;
    }

    public static enum ConnectorInstallationStatus {
        UNKNOWN,
        UP_TO_DATE,
        UPDATE_AVAILABLE,
        MORE_RECENT_VERSION_INSTALLED;

    }
}

