/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.internal.dnd.JBossCentralDropTarget;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ShowJBossCentral
implements IStartup {
    private static final String EDITOR_AREA_ID = "org.eclipse.ui.editorss";
    private static final String ORG_JBOSS_TOOLS_CENTRAL_DONOTSHOW = "org.jboss.tools.central.donotshow";
    private static final String ORG_JBOSS_TOOLS_USAGE = "org.jboss.tools.usage";

    public void earlyStartup() {
        this.registerDropTarget(2000);
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                ShowJBossCentral.this.registerDropTarget(0);
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
            }
        });
        boolean doNotShow = Boolean.getBoolean(ORG_JBOSS_TOOLS_CENTRAL_DONOTSHOW);
        if (doNotShow) {
            return;
        }
        boolean showJBossCentral = JBossCentralActivator.getDefault().showJBossCentralOnStartup();
        IEclipsePreferences prefs = JBossCentralActivator.getDefault().getPreferences();
        Bundle usage = Platform.getBundle((String)ORG_JBOSS_TOOLS_USAGE);
        Bundle central = Platform.getBundle((String)"org.jboss.tools.central");
        if (!showJBossCentral && usage != null) {
            Version version = usage.getVersion();
            String versionString = version.toString();
            String savedVersion = prefs.get(ORG_JBOSS_TOOLS_USAGE, "");
            if (!savedVersion.equals(versionString)) {
                showJBossCentral = true;
            } else if (central != null) {
                version = central.getVersion();
                versionString = version.toString();
                savedVersion = prefs.get("org.jboss.tools.central", "");
                if (!savedVersion.equals(versionString)) {
                    showJBossCentral = true;
                }
            }
        }
        this.saveVersion(prefs, usage, ORG_JBOSS_TOOLS_USAGE);
        this.saveVersion(prefs, central, "org.jboss.tools.central");
        if (!showJBossCentral) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                JBossCentralActivator.getJBossCentralEditor(false);
            }
        });
    }

    private void registerDropTarget(int delay) {
        UIJob registerJob = new UIJob(Display.getDefault(), "JBoss Central DND initialization"){
            {
                this.setPriority(50);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow[] workbenchWindows;
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = workbenchWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    Shell shell = window.getShell();
                    JBossCentralActivator.initDropTarget((Control)shell);
                    this.addJBossDropListener(window);
                    ++n2;
                }
                return Status.OK_STATUS;
            }

            private void addJBossDropListener(IWorkbenchWindow window) {
                if (!(window instanceof WorkbenchWindow)) {
                    return;
                }
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)window;
                EModelService modelService = (EModelService)window.getService(EModelService.class);
                if (modelService == null) {
                    return;
                }
                List areas = modelService.findElements((MUIElement)workbenchWindow.getModel(), ShowJBossCentral.EDITOR_AREA_ID, MArea.class, null);
                if (areas == null || areas.isEmpty()) {
                    return;
                }
                for (MArea area : areas) {
                    Composite composite;
                    Object o;
                    Object object = area.getWidget();
                    if (!(object instanceof Composite) || !((o = (composite = (Composite)object).getData("DropTarget")) instanceof DropTarget)) continue;
                    new JBossCentralDropTarget((DropTarget)o);
                }
            }
        };
        registerJob.schedule((long)delay);
    }

    protected void saveVersion(IEclipsePreferences prefs, Bundle bundle, String preference) {
        if (bundle == null || prefs == null || preference == null) {
            return;
        }
        Version version = bundle.getVersion();
        String versionString = version.toString();
        String savedVersion = prefs.get(preference, "");
        if (!savedVersion.equals(versionString)) {
            prefs.put(preference, versionString);
        }
    }
}

