/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;

public class SourceType {
    private final String displayName;
    private final String erasureName;
    private final IType erasureType;
    private List<IType> typeArguments;
    private final boolean isPrimitive;
    private final ISourceRange nameRange;

    public static SourceType from(VariableDeclaration declaration) {
        IVariableBinding paramBinding = declaration.resolveBinding();
        if (paramBinding != null) {
            String erasureName = paramBinding.getType().getErasure().getQualifiedName();
            IType erasureType = (IType)paramBinding.getType().getErasure().getJavaElement();
            ArrayList<IType> typeArguments = new ArrayList<IType>();
            SourceRange nameRange = new SourceRange(declaration.getStartPosition(), declaration.getLength());
            ITypeBinding[] iTypeBindingArray = paramBinding.getType().getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgumentBinding = iTypeBindingArray[n2];
                typeArguments.add((IType)typeArgumentBinding.getJavaElement());
                ++n2;
            }
            return new SourceType(erasureName, erasureType, typeArguments, paramBinding.getType().isPrimitive(), (ISourceRange)nameRange);
        }
        return null;
    }

    public static SourceType from(FieldDeclaration declaration) {
        if (declaration != null && declaration.getType() != null) {
            return SourceType.from(declaration.getType().resolveBinding(), declaration.getStartPosition(), declaration.getLength());
        }
        return null;
    }

    public static SourceType from(ITypeBinding typeBinding, int startPosition, int length) {
        if (typeBinding != null) {
            String erasureName = typeBinding.getErasure().getQualifiedName();
            IType erasureType = (IType)typeBinding.getErasure().getJavaElement();
            ArrayList<IType> typeArguments = new ArrayList<IType>();
            SourceRange nameRange = new SourceRange(startPosition, length);
            ITypeBinding[] iTypeBindingArray = typeBinding.getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgumentBinding = iTypeBindingArray[n2];
                IJavaElement je = typeArgumentBinding.getJavaElement();
                if (je instanceof IType) {
                    typeArguments.add((IType)je);
                }
                ++n2;
            }
            return new SourceType(erasureName, erasureType, typeArguments, typeBinding.isPrimitive(), (ISourceRange)nameRange);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceType createWorkingCopy() {
        SourceType sourceType = this;
        synchronized (sourceType) {
            return new SourceType(this.erasureName, this.erasureType, new ArrayList<IType>(this.typeArguments), this.isPrimitive, (ISourceRange)new SourceRange(this.nameRange.getOffset(), this.nameRange.getLength()));
        }
    }

    public boolean exists() {
        if (this.erasureType == null || !this.erasureType.exists()) {
            return false;
        }
        for (IType typeArg : this.typeArguments) {
            if (typeArg != null && typeArg.exists()) continue;
            return false;
        }
        return true;
    }

    private SourceType(String erasureName, IType erasureType, List<IType> typeArguments, boolean isPrimitive, ISourceRange nameRange) {
        this.erasureName = erasureName;
        this.erasureType = erasureType;
        this.typeArguments = typeArguments;
        this.isPrimitive = isPrimitive;
        StringBuffer displayNameBuffer = new StringBuffer(erasureName);
        if (!typeArguments.isEmpty()) {
            displayNameBuffer.append('<');
            Iterator<IType> typeArgumentsIterator = typeArguments.iterator();
            while (typeArgumentsIterator.hasNext()) {
                displayNameBuffer.append(typeArgumentsIterator.next().getElementName());
                if (!typeArgumentsIterator.hasNext()) continue;
                displayNameBuffer.append(',');
            }
            displayNameBuffer.append('>');
        }
        this.displayName = displayNameBuffer.toString();
        this.nameRange = nameRange;
    }

    public String getErasureName() {
        return this.erasureName;
    }

    public IType getErasureType() {
        return this.erasureType;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public List<IType> getTypeArguments() {
        return this.typeArguments;
    }

    public String getDisplayableTypeName() {
        return JdtUtils.toDisplayableTypeName(this.displayName);
    }

    public ISourceRange getNameRange() {
        return this.nameRange;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceType other = (SourceType)obj;
        return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
    }

    public String toString() {
        return this.displayName;
    }
}

