/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <K, V> Map<K, V> toMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> MapComparison<K, V> compare(Map<K, V> control, Map<K, V> test) {
        HashMap addedItems = new HashMap();
        List addedItemKeys = CollectionUtils.difference(test.keySet(), control.keySet());
        for (Object addedItemKey : addedItemKeys) {
            addedItems.put(addedItemKey, test.get(addedItemKey));
        }
        List removedItemKeys = CollectionUtils.difference(control.keySet(), test.keySet());
        HashMap removedItems = new HashMap();
        for (Object removedItemKey : removedItemKeys) {
            removedItems.put(removedItemKey, control.get(removedItemKey));
        }
        List changedItemKeys = CollectionUtils.intersection(control.keySet(), test.keySet());
        HashMap changedItems = new HashMap();
        for (Object changedItemKey : changedItemKeys) {
            if (control.get(changedItemKey).equals(test.get(changedItemKey))) continue;
            changedItems.put(changedItemKey, test.get(changedItemKey));
        }
        return new MapComparison(addedItems, changedItems, removedItems);
    }

    public static <K, V> Map<K, V> difference(Map<K, V> control, Map<K, V> test) {
        if (control == null) {
            return null;
        }
        if (test == null) {
            return control;
        }
        HashMap result = new HashMap();
        List differentKeys = CollectionUtils.difference(control.keySet(), test.keySet());
        for (Object key : differentKeys) {
            result.put(key, control.get(key));
        }
        List sameKeys = CollectionUtils.intersection(control.keySet(), test.keySet());
        for (Object key : sameKeys) {
            V testValue;
            V controlValue = control.get(key);
            if (controlValue.equals(testValue = test.get(key))) continue;
            result.put(key, testValue);
        }
        return result;
    }

    public static <K, V> Map<K, V> intersection(Map<K, V> control, Map<K, V> test) {
        if (control == null) {
            return null;
        }
        if (test == null) {
            return control;
        }
        List keys = CollectionUtils.intersection(control.keySet(), test.keySet());
        HashMap result = new HashMap();
        for (Object key : keys) {
            result.put(key, control.get(key));
        }
        return result;
    }

    public static <T> CollectionComparison<T> compare(List<T> control, List<T> test) {
        List<T> addedItems = CollectionUtils.difference(test, control);
        List<T> removedItems = CollectionUtils.difference(control, test);
        List<T> itemsInCommon = CollectionUtils.intersection(control, test);
        return new CollectionComparison<T>(addedItems, itemsInCommon, removedItems);
    }

    public static <T> List<T> difference(Collection<T> control, Collection<T> test) {
        if (control == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(control);
        if (test != null) {
            result.removeAll(test);
        }
        return result;
    }

    public static <T> List<T> intersection(Collection<T> control, Collection<T> test) {
        if (control == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(control);
        if (test != null) {
            result.retainAll(test);
        }
        return result;
    }

    public static boolean hasIntersection(Collection<String> collection, Collection<String> otherCollection) {
        return !CollectionUtils.intersection(collection, otherCollection).isEmpty();
    }

    public static <T> T[] append(T[] sourceArray, T extraElement, T[] targetArray) {
        System.arraycopy(sourceArray, 0, targetArray, 0, sourceArray.length);
        targetArray[targetArray.length - 1] = extraElement;
        return targetArray;
    }

    public static <T> boolean contains(T[] source, T element) {
        if (element == null || source == null) {
            return false;
        }
        T[] TArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (item.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean notNullNorEmpty(List<?> elements) {
        return elements != null && !elements.isEmpty();
    }

    public static class CollectionComparison<T> {
        private final List<T> addedItems;
        private final List<T> itemsInCommon;
        private final List<T> removedItems;

        CollectionComparison(List<T> addedItems, List<T> itemsInCommon, List<T> removedItems) {
            this.addedItems = addedItems;
            this.itemsInCommon = itemsInCommon;
            this.removedItems = removedItems;
        }

        public List<T> getAddedItems() {
            return this.addedItems;
        }

        public List<T> getItemsInCommon() {
            return this.itemsInCommon;
        }

        public List<T> getRemovedItems() {
            return this.removedItems;
        }
    }

    public static class MapComparison<K, V> {
        private final Map<K, V> addedItems;
        private final Map<K, V> changedItems;
        private final Map<K, V> removedItems;

        MapComparison(Map<K, V> addedItems, Map<K, V> itemsInCommon, Map<K, V> removedItems) {
            this.addedItems = addedItems;
            this.changedItems = itemsInCommon;
            this.removedItems = removedItems;
        }

        public Map<K, V> getAddedItems() {
            return this.addedItems;
        }

        public Map<K, V> getChangedItems() {
            return this.changedItems;
        }

        public Map<K, V> getRemovedItems() {
            return this.removedItems;
        }

        public boolean hasDifferences() {
            return !this.addedItems.isEmpty() || !this.removedItems.isEmpty() || !this.changedItems.isEmpty();
        }
    }
}

