/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;

public class JaxrsEndpointFactory {
    public static List<IJaxrsEndpoint> createEndpoints(JaxrsResourceMethod resourceMethod) throws CoreException {
        ArrayList<IJaxrsEndpoint> endpoints = new ArrayList<IJaxrsEndpoint>();
        if (resourceMethod.getParentResource().isRootResource()) {
            switch (resourceMethod.getElementKind()) {
                case RESOURCE_METHOD: 
                case SUBRESOURCE_METHOD: {
                    endpoints.add(JaxrsEndpointFactory.createEndpointFromRootResourceMethod(resourceMethod));
                    break;
                }
                case SUBRESOURCE_LOCATOR: {
                    endpoints.addAll(JaxrsEndpointFactory.createEndpointsFromSubresourceLocator(resourceMethod));
                    break;
                }
                default: {
                    Logger.info("Unable to create endpoint from undefined JAX-RS Resource Method: " + resourceMethod);
                    break;
                }
            }
        } else {
            switch (resourceMethod.getElementKind()) {
                case RESOURCE_METHOD: 
                case SUBRESOURCE_METHOD: {
                    endpoints.addAll(JaxrsEndpointFactory.createEndpointsFromSubresourceMethod(resourceMethod));
                    break;
                }
                default: {
                    Logger.info("Unable to create endpoint from undefined JAX-RS Resource Method: " + resourceMethod);
                }
            }
        }
        return endpoints;
    }

    public static IJaxrsEndpoint createEndpointFromRootResourceMethod(JaxrsResourceMethod resourceMethod) throws CoreException {
        JaxrsEndpoint jaxrsEndpoint;
        long start = System.currentTimeMillis();
        try {
            JaxrsHttpMethod httpMethod = resourceMethod.getMetamodel().findHttpMethodByTypeName(resourceMethod.getHttpMethodAnnotation().getFullyQualifiedName());
            LinkedList<JaxrsResourceMethod> resourceMethods = new LinkedList<JaxrsResourceMethod>();
            resourceMethods.add(resourceMethod);
            JaxrsEndpoint endpoint = new JaxrsEndpoint(resourceMethod.getMetamodel(), httpMethod, resourceMethods);
            endpoint.joinMetamodel();
            jaxrsEndpoint = endpoint;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Created JAX-RS Endpoint from JAX-RS Resource Method in {}ms", end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Created JAX-RS Endpoint from JAX-RS Resource Method in {}ms", end - start);
        return jaxrsEndpoint;
    }

    public static List<IJaxrsEndpoint> createEndpointsFromSubresourceMethod(JaxrsResourceMethod resourceMethod) throws CoreException {
        ArrayList<IJaxrsEndpoint> arrayList;
        long start = System.currentTimeMillis();
        try {
            ArrayList<IJaxrsEndpoint> endpoints = new ArrayList<IJaxrsEndpoint>();
            JaxrsMetamodel metamodel = resourceMethod.getMetamodel();
            IType resourceType = (IType)resourceMethod.getParentResource().getJavaElement();
            List<IType> superTypes = JdtUtils.findSupertypes(resourceType);
            if (superTypes != null) {
                for (IType superType : superTypes) {
                    Set<IJaxrsResourceMethod> subresourceLocators = metamodel.findResourceMethodsByReturnedType(superType);
                    for (IJaxrsResourceMethod subresourceLocator : subresourceLocators) {
                        if (!subresourceLocator.getParentResource().isRootResource()) continue;
                        JaxrsHttpMethod httpMethod = resourceMethod.getMetamodel().findHttpMethodByTypeName(resourceMethod.getHttpMethodAnnotation().getFullyQualifiedName());
                        LinkedList<JaxrsResourceMethod> resourceMethods = new LinkedList<JaxrsResourceMethod>();
                        resourceMethods.add((JaxrsResourceMethod)subresourceLocator);
                        resourceMethods.add(resourceMethod);
                        JaxrsEndpoint endpoint = new JaxrsEndpoint(resourceMethod.getMetamodel(), httpMethod, resourceMethods);
                        endpoint.joinMetamodel();
                        endpoints.add(endpoint);
                    }
                }
            }
            arrayList = endpoints;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Created JAX-RS Endpoint from JAX-RS Subresource Method in {}ms", end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Created JAX-RS Endpoint from JAX-RS Subresource Method in {}ms", end - start);
        return arrayList;
    }

    public static List<JaxrsEndpoint> createEndpointsFromSubresourceLocator(JaxrsResourceMethod subresourceLocator) throws CoreException {
        ArrayList<JaxrsEndpoint> arrayList;
        long start = System.currentTimeMillis();
        try {
            ArrayList<JaxrsEndpoint> endpoints = new ArrayList<JaxrsEndpoint>();
            JaxrsMetamodel metamodel = subresourceLocator.getMetamodel();
            SourceType returnedType = subresourceLocator.getReturnedType();
            if (returnedType != null) {
                List<IType> returnedTypes = JdtUtils.findSubtypes(returnedType.getErasureType());
                for (IType subtype : returnedTypes) {
                    JaxrsResource matchingResource = metamodel.findResource(subtype);
                    if (matchingResource == null || !matchingResource.isSubresource()) continue;
                    for (IJaxrsResourceMethod method : matchingResource.getAllMethods()) {
                        switch (method.getElementKind()) {
                            case RESOURCE_METHOD: 
                            case SUBRESOURCE_METHOD: {
                                JaxrsHttpMethod httpMethod = metamodel.findHttpMethodByTypeName(method.getHttpMethodClassName());
                                LinkedList<JaxrsResourceMethod> resourceMethods = new LinkedList<JaxrsResourceMethod>(Arrays.asList(subresourceLocator, (JaxrsResourceMethod)method));
                                JaxrsEndpoint endpoint = new JaxrsEndpoint(metamodel, httpMethod, resourceMethods);
                                endpoint.joinMetamodel();
                                endpoints.add(endpoint);
                            }
                        }
                    }
                }
            }
            arrayList = endpoints;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Created JAX-RS Endpoint from JAX-RS Subresource Locator in {}ms", end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Created JAX-RS Endpoint from JAX-RS Subresource Locator in {}ms", end - start);
        return arrayList;
    }
}

