/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.configuration.ProjectNatureUtils;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedBuildJob;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedEvent;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;

public class JavaElementChangedListener
implements IElementChangedListener {
    private boolean active = true;

    public void pause() {
        this.active = false;
    }

    public void resume() {
        this.active = true;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!this.active) {
            return;
        }
        try {
            IProject project = this.getProject(event.getDelta());
            if (ProjectNatureUtils.isProjectNatureInstalled(project, "org.jboss.tools.ws.jaxrs.nature")) {
                this.logDelta(event.getDelta(), event.getType());
                JavaElementChangedBuildJob job = new JavaElementChangedBuildJob(event);
                job.setRule(project.getWorkspace().getRuleFactory().buildRule());
                job.schedule();
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to process Java Element change", e);
        }
    }

    private IProject getProject(IJavaElementDelta delta) {
        IJavaProject javaProject = delta.getElement().getJavaProject();
        if (javaProject != null) {
            return javaProject.getProject();
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta affectedChild = iJavaElementDeltaArray[n2];
            IProject project = this.getProject(affectedChild);
            if (project != null) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private void logDelta(IJavaElementDelta delta, int eventType) {
        IJavaElement element = delta.getElement();
        int deltaKind = JavaElementChangedListener.retrieveDeltaKind(delta);
        Flags flags = new Flags(delta.getFlags());
        CompilationUnit compilationUnitAST = null;
        JavaElementChangedEvent event = new JavaElementChangedEvent(element, deltaKind, eventType, compilationUnitAST, flags);
        Logger.trace("Event {}", event);
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta affectedChild = iJavaElementDeltaArray[n2];
            this.logDelta(affectedChild, eventType);
            ++n2;
        }
        iJavaElementDeltaArray = delta.getAnnotationDeltas();
        n = iJavaElementDeltaArray.length;
        n2 = 0;
        while (n2 < n) {
            IJavaElementDelta annotation = iJavaElementDeltaArray[n2];
            this.logDelta(annotation, eventType);
            ++n2;
        }
    }

    private static int retrieveDeltaKind(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        int elementType = element.getElementType();
        int flags = delta.getFlags();
        switch (elementType) {
            case 3: {
                switch (flags) {
                    case 64: {
                        return 1;
                    }
                    case 128: {
                        return 2;
                    }
                }
            }
        }
        return delta.getKind();
    }
}

