/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.seam.utils;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class SeamUtils {
    private static VersionRange SUPPORTED_SEAM_VERSION_RANGE;

    static {
        try {
            SUPPORTED_SEAM_VERSION_RANGE = VersionRange.createFromVersionSpec((String)"[2.0, 2.3)");
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {}
    }

    private SeamUtils() {
    }

    public static boolean isSeamConversionSupported(String seamVersion) {
        if (seamVersion == null) {
            return false;
        }
        String[] versionBits = seamVersion.split("\\.");
        if (versionBits.length > 0) {
            StringBuilder shortVersion = new StringBuilder(versionBits[0]);
            if (versionBits.length > 1) {
                shortVersion.append(".").append(versionBits[1]);
            }
            return SUPPORTED_SEAM_VERSION_RANGE.containsVersion((ArtifactVersion)new DefaultArtifactVersion(shortVersion.toString()));
        }
        return false;
    }
}

