/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.seam.internal.project.facet;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.jboss.tools.maven.seam.MavenSeamActivator;

public class MavenPostInstallListener
implements IFacetedProjectListener {
    private static final String M2_FACET_MODEL_PROVIDER = "org.jboss.tools.maven.core.internal.project.facet.MavenFacetInstallDataModelProvider";
    private static final String SEAM_FACET_MODEL_PROVIDER = "org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider";
    private static final IProjectFacet MAVEN_FACET = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
    private static final IProjectFacet SEAM_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
    private Map<IFacetedProject, IDataModel> seamModels = new WeakHashMap<IFacetedProject, IDataModel>(1);
    private Map<IFacetedProject, IDataModel> mavenModels = new WeakHashMap<IFacetedProject, IDataModel>(1);

    public void handleEvent(IFacetedProjectEvent event) {
        if (!(event instanceof IProjectFacetActionEvent)) {
            return;
        }
        IFacetedProject facetedProject = event.getProject();
        boolean isSeamProject = facetedProject.hasProjectFacet(SEAM_FACET);
        boolean isM2Project = facetedProject.hasProjectFacet(MAVEN_FACET);
        Object object = ((IProjectFacetActionEvent)event).getActionConfig();
        IDataModel m2FacetModel = null;
        IDataModel seamFacetModel = null;
        if (object instanceof IDataModel) {
            IDataModel dataModel = (IDataModel)object;
            if (SEAM_FACET_MODEL_PROVIDER.equals(dataModel.getID())) {
                this.seamModels.put(facetedProject, dataModel);
                seamFacetModel = dataModel;
            } else if (M2_FACET_MODEL_PROVIDER.equals(dataModel.getID())) {
                this.mavenModels.put(facetedProject, dataModel);
                m2FacetModel = dataModel;
            }
        }
        if (m2FacetModel == null) {
            m2FacetModel = this.mavenModels.get(facetedProject);
        }
        if (seamFacetModel == null) {
            seamFacetModel = this.seamModels.get(facetedProject);
        }
        if (isSeamProject && isM2Project && seamFacetModel != null && m2FacetModel != null) {
            boolean mavenProjectExists = seamFacetModel.getBooleanProperty("seam.project.already.exists");
            boolean bl = mavenProjectExists = mavenProjectExists || m2FacetModel.getBooleanProperty("mavenProjectExists");
            if (!mavenProjectExists) {
                MavenSeamActivator.getDefault().configureSeamProject(seamFacetModel, m2FacetModel);
            }
            this.mavenModels.remove(facetedProject);
            this.seamModels.remove(facetedProject);
        }
    }
}

