/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.osgi.framework.BundleContext;

public class PortletCoreActivator
extends Plugin {
    public static final String PORTLETBRIDGE = "portletbridge";
    public static final String SEAM = "seam";
    public static final String PLUGIN_ID = "org.jboss.tools.portlet.core";
    public static final String RESOURCES_FOLDER = "resources";
    public static final String JSFPORTLET_FOLDER = "jsfportlet";
    public static final String CHECK_RUNTIMES = "checkRuntimes";
    public static final boolean DEFAULT_CHECK_RUNTIMES = false;
    public static final String JSFPORTLET_LIBRARY_PROVIDER = "jsfportlet-library-provider";
    public static final String JSFPORTLETBRIDGE_LIBRARY_PROVIDER = "jsfportletbridge-library-provider";
    public static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };
    private static PortletCoreActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PortletCoreActivator getDefault() {
        return plugin;
    }

    public static IModelProvider getModelProvider(IProject webProject) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProject);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return null;
        }
        return provider;
    }

    public static IStatus getStatus(String message) {
        return new Status(4, PLUGIN_ID, message);
    }

    public static void createPortletXml(String versionString, IProject project, IProgressMonitor monitor) {
        block20: {
            IPath portletXmlPath = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getRawLocation().append((IPath)new Path("WEB-INF/portlet.xml"));
            IPath directory = portletXmlPath.removeLastSegments(1);
            directory.toFile().mkdirs();
            File file = portletXmlPath.toFile();
            if (file != null && file.exists()) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if ("2.0".equals(versionString)) {
                buffer.append("<portlet-app xmlns=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\"");
                buffer.append("\n\t");
                buffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
                buffer.append("\n\t");
                buffer.append("xsi:schemaLocation=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\" ");
                buffer.append("\n\t");
                buffer.append("version=\"2.0\">");
            } else {
                buffer.append("<portlet-app xmlns=\"http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd\"");
                buffer.append("\n\t");
                buffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                buffer.append("\n\t");
                buffer.append("xsi:schemaLocation=\"http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd\"");
                buffer.append("\n\t");
                buffer.append("version=\"1.0\">");
            }
            buffer.append("\n\n");
            buffer.append("</portlet-app>");
            buffer.append("\n");
            FileOutputStream outputStream = null;
            PrintWriter printWriter = null;
            try {
                try {
                    file.createNewFile();
                    outputStream = new FileOutputStream(file);
                    printWriter = new PrintWriter(outputStream);
                    printWriter.write(buffer.toString());
                }
                catch (Exception e) {
                    PortletCoreActivator.log(e);
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    if (outputStream != null) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (printWriter != null) {
                printWriter.close();
            }
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void log(Exception e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        PortletCoreActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        PortletCoreActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void createPortletInstances(IProject project, IFile file) throws CoreException, UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<!DOCTYPE deployments PUBLIC \n");
        buffer.append("\"-//JBoss Portal//DTD Portlet Instances 2.6//EN\"\n");
        buffer.append("\"http://www.jboss.org/portal/dtd/portlet-instances_2_6.dtd\">");
        buffer.append("<deployments>");
        buffer.append("</deployments>");
        ByteArrayInputStream source = new ByteArrayInputStream(buffer.toString().getBytes("UTF8"));
        file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createPortletObject(IProject project, IFile file) throws CoreException, UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<!DOCTYPE deployments PUBLIC \n");
        buffer.append("\"-//JBoss Portal//DTD Portal Object 2.6//EN\"\n");
        buffer.append("\"http://www.jboss.org/portal/dtd/portal-object_2_6.dtd\">");
        buffer.append("<deployments>");
        buffer.append("</deployments>");
        ByteArrayInputStream source = new ByteArrayInputStream(buffer.toString().getBytes("UTF8"));
        file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createJBossApp(IProject project, IFile file) throws CoreException, UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<!DOCTYPE jboss-app PUBLIC \n");
        buffer.append("\"-//JBoss Portal//DTD JBoss Web Application 2.6//EN\"\n");
        buffer.append("\"http://www.jboss.org/portal/dtd/jboss-app_2_6.dtd\">");
        buffer.append("<jboss-app>");
        buffer.append("</jboss-app>");
        ByteArrayInputStream source = new ByteArrayInputStream(buffer.toString().getBytes("UTF8"));
        file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createJBossPortlet(IProject project, IFile file) throws CoreException, UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<!DOCTYPE portlet-app PUBLIC \n");
        buffer.append("\"-//JBoss Portal//DTD JBoss Portlet 2.6//EN\"\n");
        buffer.append("\"http://www.jboss.org/portal/dtd/jboss-portlet_2_6.dtd\">");
        buffer.append("<portlet-app>");
        buffer.append("</portlet-app>");
        ByteArrayInputStream source = new ByteArrayInputStream(buffer.toString().getBytes("UTF8"));
        file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IRuntime[] runtimes;
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime r = iRuntimeArray[n2];
            if (id.equals(r.getId())) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isEPP(IFacetedProjectBase facetedProject) {
        boolean ok;
        boolean hasSeamAndPortletBridge;
        if (facetedProject == null) {
            return false;
        }
        boolean bl = hasSeamAndPortletBridge = PortletCoreActivator.getEPPDir(facetedProject, PORTLETBRIDGE) != null && PortletCoreActivator.getEPPDir(facetedProject, PORTLETBRIDGE).isDirectory() && PortletCoreActivator.getEPPDir(facetedProject, SEAM) != null && PortletCoreActivator.getEPPDir(facetedProject, SEAM).isDirectory();
        if (!hasSeamAndPortletBridge) {
            return false;
        }
        File portletBridgeHome = PortletCoreActivator.getEPPDir(facetedProject, PORTLETBRIDGE);
        String[] list = portletBridgeHome.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(PortletCoreActivator.PORTLETBRIDGE) && name.endsWith(".jar");
            }
        });
        boolean bl2 = ok = list != null && list.length >= 2;
        if (!ok) {
            return false;
        }
        File seamHome = PortletCoreActivator.getEPPDir(facetedProject, SEAM);
        File seamLib = new File(seamHome, "lib");
        list = seamLib.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("jsf-facelets") && name.endsWith(".jar");
            }
        });
        return list != null && list.length >= 1;
    }

    public static File getEPPDir(IFacetedProjectBase facetedProject, String dir) {
        File location = PortletCoreActivator.getRuntimeLocation(facetedProject);
        if (location != null) {
            return new File(location.getParentFile(), dir);
        }
        return null;
    }

    private static File getRuntimeLocation(IFacetedProjectBase facetedProject) {
        if (facetedProject == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetedProject.getPrimaryRuntime();
        if (facetRuntime == null) {
            return null;
        }
        IRuntime runtime = PortletCoreActivator.getRuntime(facetRuntime);
        if (runtime == null) {
            return null;
        }
        File location = runtime.getLocation().toFile();
        if (location == null || !location.isDirectory()) {
            return null;
        }
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            return location;
        }
        return null;
    }

    public static boolean isWebApp25(Object webApp) {
        return webApp instanceof WebApp && ((WebApp)webApp).getVersion() == WebAppVersionType._25_LITERAL;
    }

    public static void logMessage(String message) {
        Status status = new Status(1, PLUGIN_ID, message);
        PortletCoreActivator.getDefault().getLog().log((IStatus)status);
    }
}

