/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.model.Device;
import org.jboss.tools.vpe.browsersim.model.TruncateWindow;
import org.jboss.tools.vpe.browsersim.model.preferences.BrowserSimSpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.BrowserSimSpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.model.preferences.CommonPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.CommonPreferencesStorage;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.ui.AddDeviceDialog;
import org.jboss.tools.vpe.browsersim.ui.EditDeviceDialog;
import org.jboss.tools.vpe.browsersim.ui.Messages;
import org.jboss.tools.vpe.browsersim.ui.PreferencesWrapper;
import org.jboss.tools.vpe.browsersim.ui.VerifyDigitsListener;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;

public class ManageDevicesDialog
extends Dialog {
    private static final String BROWSERSIM_RESTART_COMMAND = "org.jboss.tools.vpe.browsersim.command.restart:";
    private String currentUrl;
    protected CommonPreferences oldCommonPreferences;
    protected SpecificPreferences oldSpecificPreferences;
    protected Map<String, Device> devices;
    protected String checkedDeviceId;
    protected String selectedDeviceId;
    protected Shell shell;
    protected Table table;
    protected CommonPreferences newCommonPreferences;
    protected SpecificPreferences newSpecificPreferences;
    protected boolean useSkins;
    protected boolean enableLiveReload;
    protected int liveReloadPort;
    protected boolean enableTouchEvents;
    protected boolean isJavaFx;
    protected TruncateWindow truncateWindow;
    protected Button askBeforeTruncateRadio;
    protected Button alwaysTruncateRadio;
    protected Button neverTruncateRadio;
    protected Button javaFXBrowserRadio;
    protected Button swtBrowserRadio;
    protected Button useSkinsCheckbox;
    protected Button liveReloadCheckBox;
    protected Button touchEventsCheckBox;
    protected Label liveReloadPortLabel;
    protected Text liveReloadPortText;
    protected Text screenshotsPath;
    protected Text weinreScriptUrlText;
    protected Text weinreClientUrlText;
    protected Button buttonEdit;
    protected Button buttonRemove;
    protected Composite settingsComposite;
    private Label livereloadErrorLabel;

    public ManageDevicesDialog(Shell parent, int style, CommonPreferences oldCommonPreferences, SpecificPreferences oldSpecificPreferences, String currentUrl) {
        super(parent, style);
        this.setText(Messages.ManageDevicesDialog_PREFERENCES);
        this.oldCommonPreferences = oldCommonPreferences;
        this.oldSpecificPreferences = oldSpecificPreferences;
        this.devices = new LinkedHashMap<String, Device>(oldCommonPreferences.getDevices());
        this.checkedDeviceId = oldSpecificPreferences.getSelectedDeviceId();
        this.selectedDeviceId = oldSpecificPreferences.getSelectedDeviceId();
        this.useSkins = oldSpecificPreferences.getUseSkins();
        this.enableLiveReload = oldSpecificPreferences.isEnableLiveReload();
        this.liveReloadPort = oldSpecificPreferences.getLiveReloadPort();
        this.enableTouchEvents = oldSpecificPreferences.isEnableTouchEvents();
        this.truncateWindow = oldCommonPreferences.getTruncateWindow();
        this.isJavaFx = oldSpecificPreferences.isJavaFx();
        this.currentUrl = currentUrl;
    }

    public PreferencesWrapper open() {
        this.createContents();
        this.updateDevices();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.newCommonPreferences == null || this.newSpecificPreferences == null) {
            return null;
        }
        return new PreferencesWrapper(this.newCommonPreferences, this.newSpecificPreferences);
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(800, 555);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 4);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Rectangle clientArea = this.shell.getClientArea();
        tabFolder.setLocation(clientArea.x, clientArea.y);
        TabItem devicesTab = new TabItem(tabFolder, 0);
        devicesTab.setText(Messages.ManageDevicesDialog_TABS_DEVICES);
        Composite devicesComposite = new Composite((Composite)tabFolder, 0);
        devicesComposite.setLayout((Layout)new GridLayout());
        Group devicesGroup = new Group(devicesComposite, 0);
        devicesGroup.setText(Messages.ManageDevicesDialog_DEVICES);
        devicesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        devicesGroup.setLayout((Layout)new GridLayout(2, false));
        this.table = new Table((Composite)devicesGroup, 67616);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    ManageDevicesDialog.this.checkedDeviceId = e.item.getData().toString();
                    TableItem[] tableItemArray = ManageDevicesDialog.this.table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(false);
                        ++n2;
                    }
                    ((TableItem)e.item).setChecked(true);
                } else {
                    ManageDevicesDialog.this.selectedDeviceId = e.item.getData().toString();
                }
            }
        });
        TableColumn tableColumnName = new TableColumn(this.table, 0);
        tableColumnName.setWidth(175);
        tableColumnName.setText(Messages.ManageDevicesDialog_NAME);
        TableColumn tableColumnWidth = new TableColumn(this.table, 0);
        tableColumnWidth.setWidth(75);
        tableColumnWidth.setText(Messages.ManageDevicesDialog_WIDTH);
        TableColumn tableColumnHeight = new TableColumn(this.table, 0);
        tableColumnHeight.setWidth(75);
        tableColumnHeight.setText(Messages.ManageDevicesDialog_HEIGHT);
        TableColumn tableColumnPixelRatio = new TableColumn(this.table, 0);
        tableColumnPixelRatio.setWidth(75);
        tableColumnPixelRatio.setText(Messages.ManageDevicesDialog_PIXEL_RATIO);
        TableColumn tableColumnUseragent = new TableColumn(this.table, 0);
        tableColumnUseragent.setWidth(150);
        tableColumnUseragent.setText(Messages.ManageDevicesDialog_USER_AGENT);
        TableColumn tableColumnSkin = new TableColumn(this.table, 0);
        tableColumnSkin.setWidth(75);
        tableColumnSkin.setText(Messages.ManageDevicesDialog_SKIN);
        Composite compositeControls = new Composite((Composite)devicesGroup, 0);
        compositeControls.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        compositeControls.setLayout((Layout)new FillLayout(512));
        Button buttonAdd = new Button(compositeControls, 0);
        buttonAdd.setSize(88, -1);
        buttonAdd.setText(Messages.ManageDevicesDialog_ADD);
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Device newDevice = new AddDeviceDialog(ManageDevicesDialog.this.shell, 66800, ManageDevicesDialog.this.devices.get(ManageDevicesDialog.this.selectedDeviceId)).open();
                if (newDevice != null) {
                    String id = UUID.randomUUID().toString();
                    newDevice.setId(id);
                    ManageDevicesDialog.this.devices.put(id, newDevice);
                    ManageDevicesDialog.this.table.setSelection(ManageDevicesDialog.this.table.getItemCount());
                    ManageDevicesDialog.this.selectedDeviceId = id;
                    ManageDevicesDialog.this.updateDevices();
                }
            }
        });
        this.buttonEdit = new Button(compositeControls, 0);
        this.buttonEdit.setText(Messages.ManageDevicesDialog_EDIT);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Device selected = ManageDevicesDialog.this.devices.get(ManageDevicesDialog.this.selectedDeviceId);
                Device newDevice = new EditDeviceDialog(ManageDevicesDialog.this.shell, 66800, selected).open();
                if (newDevice != null) {
                    newDevice.setId(selected.getId());
                    ManageDevicesDialog.this.devices.put(newDevice.getId(), newDevice);
                    ManageDevicesDialog.this.updateDevices();
                }
            }
        });
        this.buttonRemove = new Button(compositeControls, 0);
        this.buttonRemove.setText(Messages.ManageDevicesDialog_REMOVE);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ManageDevicesDialog.this.devices.size() > 1) {
                    boolean checkedRemoved = ManageDevicesDialog.this.checkedDeviceId.equals(ManageDevicesDialog.this.selectedDeviceId);
                    if (checkedRemoved) {
                        int nextSelection = ManageDevicesDialog.this.table.getSelectionIndex() + 1;
                        if (nextSelection == ManageDevicesDialog.this.table.getItemCount()) {
                            nextSelection = ManageDevicesDialog.this.table.getItemCount() - 2;
                        }
                        ManageDevicesDialog.this.devices.remove(ManageDevicesDialog.this.checkedDeviceId);
                        ManageDevicesDialog.this.checkedDeviceId = ManageDevicesDialog.this.table.getItem(nextSelection).getData().toString();
                    } else {
                        ManageDevicesDialog.this.devices.remove(ManageDevicesDialog.this.table.getItem(ManageDevicesDialog.this.table.getSelectionIndex()).getData());
                    }
                    ManageDevicesDialog.this.updateDevices();
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ManageDevicesDialog.this.buttonEdit.setEnabled(true);
                ManageDevicesDialog.this.buttonRemove.setEnabled(true);
            }
        });
        Button buttonReset = new Button(compositeControls, 0);
        buttonReset.setText(Messages.ManageDevicesDialog_REVERT_ALL);
        buttonReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDevicesDialog.this.devices = new LinkedHashMap<String, Device>(ManageDevicesDialog.this.oldCommonPreferences.getDevices());
                ManageDevicesDialog.this.checkedDeviceId = ManageDevicesDialog.this.oldSpecificPreferences.getSelectedDeviceId();
                ManageDevicesDialog.this.updateDevices();
            }
        });
        Group useSkinsGroup = new Group(devicesComposite, 0);
        useSkinsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        useSkinsGroup.setLayout((Layout)new RowLayout(512));
        useSkinsGroup.setText(Messages.ManageDevicesDialog_SKINS_OPTIONS);
        this.useSkinsCheckbox = new Button((Composite)useSkinsGroup, 32);
        this.useSkinsCheckbox.setText(Messages.ManageDevicesDialog_USE_SKINS);
        this.useSkinsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.widget;
                ManageDevicesDialog.this.useSkins = checkbox.getSelection();
            }
        });
        Group truncateWindowGroup = new Group(devicesComposite, 0);
        truncateWindowGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        truncateWindowGroup.setText(Messages.ManageDevicesDialog_TRUNCATE_THE_DEVICE_WINDOW);
        truncateWindowGroup.setLayout((Layout)new RowLayout(256));
        this.alwaysTruncateRadio = new Button((Composite)truncateWindowGroup, 16);
        this.alwaysTruncateRadio.setText(TruncateWindow.ALWAYS_TRUNCATE.getMessage());
        this.alwaysTruncateRadio.setData((Object)TruncateWindow.ALWAYS_TRUNCATE);
        this.neverTruncateRadio = new Button((Composite)truncateWindowGroup, 16);
        this.neverTruncateRadio.setText(TruncateWindow.NEVER_TRUNCATE.getMessage());
        this.neverTruncateRadio.setData((Object)TruncateWindow.NEVER_TRUNCATE);
        this.askBeforeTruncateRadio = new Button((Composite)truncateWindowGroup, 16);
        this.askBeforeTruncateRadio.setText(TruncateWindow.PROMPT.getMessage());
        this.askBeforeTruncateRadio.setData((Object)TruncateWindow.PROMPT);
        SelectionAdapter truncateSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button radio = (Button)e.widget;
                if (radio.getSelection()) {
                    ManageDevicesDialog.this.truncateWindow = (TruncateWindow)((Object)radio.getData());
                }
            }
        };
        this.alwaysTruncateRadio.addSelectionListener((SelectionListener)truncateSelectionListener);
        this.neverTruncateRadio.addSelectionListener((SelectionListener)truncateSelectionListener);
        this.askBeforeTruncateRadio.addSelectionListener((SelectionListener)truncateSelectionListener);
        devicesTab.setControl((Control)devicesComposite);
        TabItem settingsTab = new TabItem(tabFolder, 0);
        settingsTab.setText(Messages.ManageDevicesDialog_TABS_SETTINGS);
        this.settingsComposite = new Composite((Composite)tabFolder, 0);
        this.settingsComposite.setLayout((Layout)new GridLayout());
        final Group liveReloadGroup = new Group(this.settingsComposite, 0);
        liveReloadGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        liveReloadGroup.setLayout((Layout)new GridLayout(2, false));
        liveReloadGroup.setText(Messages.ManageDevicesDialog_LIVE_RELOAD_OPTIONS);
        this.liveReloadCheckBox = new Button((Composite)liveReloadGroup, 32);
        this.liveReloadCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.liveReloadCheckBox.setText(Messages.ManageDevicesDialog_ENABLE_LIVE_RELOAD);
        Composite liveReloadPortComposite = new Composite((Composite)liveReloadGroup, 0);
        liveReloadPortComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 15;
        liveReloadPortComposite.setLayoutData((Object)data);
        this.liveReloadPortLabel = new Label(liveReloadPortComposite, 0);
        this.liveReloadPortLabel.setText(Messages.ManageDevicesDialog_LIVE_RELOAD_PORT);
        this.liveReloadPortText = new Text(liveReloadPortComposite, 2048);
        this.liveReloadPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.liveReloadPortText.setText(Integer.toString(this.liveReloadPort));
        this.liveReloadPortText.setTextLimit(5);
        this.liveReloadPortText.addVerifyListener((VerifyListener)new VerifyDigitsListener());
        this.liveReloadPortText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if ("".equals(ManageDevicesDialog.this.liveReloadPortText.getText())) {
                    ManageDevicesDialog.this.liveReloadPortText.setText(Integer.toString(35729));
                }
            }
        });
        this.liveReloadCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.widget;
                ManageDevicesDialog.this.enableLiveReload = checkbox.getSelection();
                ManageDevicesDialog.this.enableLiveReloadPort(ManageDevicesDialog.this.enableLiveReload);
            }
        });
        this.livereloadErrorLabel = new Label((Composite)liveReloadGroup, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.livereloadErrorLabel.setLayoutData((Object)gd);
        this.livereloadErrorLabel.setText(Messages.ManageDevicesDialog_LIVE_RELOAD_UNAVAILABLE);
        this.livereloadErrorLabel.setForeground(Display.getDefault().getSystemColor(3));
        this.disableLivereloadForJavaFx7((Composite)liveReloadGroup);
        Group touchEventsGroup = new Group(this.settingsComposite, 0);
        touchEventsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        touchEventsGroup.setText(Messages.ManageDevicesDialog_TOUCH_EVENTS_OPTIONS);
        touchEventsGroup.setLayout((Layout)new GridLayout(2, false));
        this.touchEventsCheckBox = new Button((Composite)touchEventsGroup, 32);
        this.touchEventsCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.touchEventsCheckBox.setText(Messages.ManageDevicesDialog_SIMULATE_TOUCH_EVENTS);
        if (!BrowserSimArgs.standalone) {
            Group browserTypeGroup = new Group(this.settingsComposite, 0);
            browserTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            browserTypeGroup.setText(Messages.ManageDevicesDialog_BROWSER_ENGINE);
            browserTypeGroup.setLayout((Layout)new RowLayout(256));
            this.javaFXBrowserRadio = new Button((Composite)browserTypeGroup, 16);
            this.javaFXBrowserRadio.setText(Messages.ManageDevicesDialog_BROWSER_TYPE_JAVAFX);
            this.swtBrowserRadio = new Button((Composite)browserTypeGroup, 16);
            this.swtBrowserRadio.setText(Messages.ManageDevicesDialog_BROWSER_TYPE_SWT);
            SelectionAdapter browserTypeSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ManageDevicesDialog.this.isJavaFx = ManageDevicesDialog.this.javaFXBrowserRadio.equals((Button)e.widget);
                    ManageDevicesDialog.this.disableLivereloadForJavaFx7((Composite)liveReloadGroup);
                }
            };
            this.javaFXBrowserRadio.addSelectionListener((SelectionListener)browserTypeSelectionListener);
            this.swtBrowserRadio.addSelectionListener((SelectionListener)browserTypeSelectionListener);
            this.disableWebEngineSwitcherIfJavaFxNotAvailable(this.javaFXBrowserRadio, browserTypeGroup);
            this.disableWebEngineSwitcherIfWebKitNotAvailable(this.swtBrowserRadio, browserTypeGroup);
        }
        Group screnshotGroup = new Group(this.settingsComposite, 0);
        screnshotGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        screnshotGroup.setText(Messages.ManageDevicesDialog_SCREENSHOTS);
        screnshotGroup.setLayout((Layout)new GridLayout(3, false));
        Label screenshotsLabel = new Label((Composite)screnshotGroup, 0);
        screenshotsLabel.setText(Messages.ManageDevicesDialog_LOCATION);
        this.screenshotsPath = new Text((Composite)screnshotGroup, 2048);
        this.screenshotsPath.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.screenshotsPath.setText(this.oldCommonPreferences.getScreenshotsFolder());
        Button selectFolder = new Button((Composite)screnshotGroup, 8);
        selectFolder.setText(Messages.ManageDevicesDialog_BROWSE);
        selectFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dd = new DirectoryDialog(ManageDevicesDialog.this.shell);
                dd.setText(Messages.ManageDevicesDialog_SELECT_FOLDER);
                dd.setFilterPath(ManageDevicesDialog.this.screenshotsPath.getText());
                String selectedFolder = dd.open();
                if (selectedFolder != null) {
                    ManageDevicesDialog.this.screenshotsPath.setText(selectedFolder);
                }
            }
        });
        Group weinreGroup = new Group(this.settingsComposite, 0);
        weinreGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        weinreGroup.setText(Messages.ManageDevicesDialog_WEINRE);
        weinreGroup.setLayout((Layout)new GridLayout(2, false));
        Label weinreScriptUrlLabel = new Label((Composite)weinreGroup, 0);
        weinreScriptUrlLabel.setText(Messages.ManageDevicesDialog_WEINRE_SCRIPT_URL);
        this.weinreScriptUrlText = new Text((Composite)weinreGroup, 2048);
        this.weinreScriptUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.weinreScriptUrlText.setText(this.oldCommonPreferences.getWeinreScriptUrl());
        Label weinreClientUrlLabel = new Label((Composite)weinreGroup, 0);
        weinreClientUrlLabel.setText(Messages.ManageDevicesDialog_WEINRE_CLIENT_URL);
        this.weinreClientUrlText = new Text((Composite)weinreGroup, 2048);
        this.weinreClientUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.weinreClientUrlText.setText(this.oldCommonPreferences.getWeinreClientUrl());
        settingsTab.setControl((Control)this.settingsComposite);
        tabFolder.pack();
        Composite compositeOkCancel = new Composite((Composite)this.shell, 0);
        compositeOkCancel.setLayout((Layout)new GridLayout(2, true));
        compositeOkCancel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        new Label(compositeOkCancel, 0);
        Button buttonLoadDefaults = new Button(compositeOkCancel, 0);
        buttonLoadDefaults.setText(Messages.ManageDevicesDialog_LOAD_DEFAULTS);
        buttonLoadDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDevicesDialog.this.loadDefaultPreferences();
            }
        });
        Button buttonOk = new Button(compositeOkCancel, 0);
        buttonOk.setText(Messages.ManageDevicesDialog_OK);
        buttonOk.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.shell.setDefaultButton(buttonOk);
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDevicesDialog.this.performOK();
            }
        });
        Button buttonCancel = new Button(compositeOkCancel, 0);
        buttonCancel.setText(Messages.ManageDevicesDialog_CANCEL);
        buttonCancel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDevicesDialog.this.performCancel();
            }
        });
    }

    private void restart() {
        this.newCommonPreferences = new CommonPreferences(this.devices, this.truncateWindow, this.screenshotsPath.getText(), this.weinreScriptUrlText.getText(), this.weinreClientUrlText.getText());
        this.newSpecificPreferences = this.create(this.selectedDeviceId, this.useSkins, this.enableLiveReload, this.getLiveReloadPort(), this.touchEventsCheckBox.getSelection(), this.isJavaFx);
        this.getSpecificPreferencesStorage().save(this.newSpecificPreferences);
        CommonPreferencesStorage.INSTANCE.save(this.newCommonPreferences);
        Display.getDefault().dispose();
        this.sendRestartCommand();
    }

    private void disableWebEngineSwitcherIfJavaFxNotAvailable(Button javaFXBrowserRadio, Group browserTypeGroup) {
        String message = "";
        if ("linux".equals(PlatformUtil.getOs()) && !BrowserSimUtil.isRunningAgainstGTK2()) {
            message = Messages.ManageDevicesDialog_BROWSER_ENGINE_WARNING_ON_LINUX;
        } else if (!BrowserSimUtil.isJavaFxAvailable()) {
            message = Messages.ManageDevicesDialog_BROWSER_ENGINE_WARNING;
        }
        if (!message.isEmpty()) {
            this.disableSwitcher(javaFXBrowserRadio, browserTypeGroup, message);
        }
    }

    private void disableWebEngineSwitcherIfWebKitNotAvailable(Button swtBrowserRadio, Group browserTypeGroup) {
        String message = "";
        if (!BrowserSimUtil.isWebkitAvailable()) {
            String os = PlatformUtil.getOs();
            if ("win32".equals(os)) {
                message = "x86_64".equals(PlatformUtil.getArch()) ? Messages.ManageDevicesDialog_BROWSER_ENGINE_WEBKIT_WARNING_ON_WINDOWS64 : Messages.ManageDevicesDialog_BROWSER_ENGINE_WEBKIT_WARNING_ON_WINDOWS;
            } else if ("linux".equals(os)) {
                message = Messages.ManageDevicesDialog_BROWSER_ENGINE_WEBKIT_WARNING_ON_LINUX;
            }
        }
        if (!message.isEmpty()) {
            this.disableSwitcher(swtBrowserRadio, browserTypeGroup, message);
        }
    }

    private void disableSwitcher(Button javaFXBrowserRadio, Group browserTypeGroup, String message) {
        javaFXBrowserRadio.setEnabled(false);
        Label label = new Label((Composite)browserTypeGroup, 0);
        label.setText(message);
        label.setForeground(Display.getDefault().getSystemColor(3));
    }

    private void disableLivereloadForJavaFx7(Composite parent) {
        if (this.isJavaFx && BrowserSimUtil.isJavaFx7Available()) {
            this.liveReloadCheckBox.setSelection(false);
            this.liveReloadCheckBox.setEnabled(false);
            this.livereloadErrorLabel.setVisible(true);
        } else {
            this.liveReloadCheckBox.setEnabled(true);
            this.livereloadErrorLabel.setVisible(false);
        }
    }

    public void updateDevices() {
        this.table.removeAll();
        ArrayList<Device> values = new ArrayList<Device>(this.devices.values());
        int i = 0;
        while (i < values.size()) {
            Device device = (Device)values.get(i);
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setData((Object)device.getId());
            tableItem.setText(new String[]{device.getName(), device.getWidth() == -1 ? Messages.ManageDevicesDialog_DEFAULT : String.valueOf(device.getWidth()), device.getHeight() == -1 ? Messages.ManageDevicesDialog_DEFAULT : String.valueOf(device.getHeight()), Device.PIXEL_RAIO_FORMAT.format(device.getPixelRatio()), device.getUserAgent() == null ? Messages.ManageDevicesDialog_DEFAULT : device.getUserAgent(), device.getSkinId() == null ? Messages.ManageDevicesDialog_NONE : device.getSkinId()});
            if (device.getId().equals(this.checkedDeviceId)) {
                tableItem.setChecked(true);
            }
            if (device.getId().equals(this.selectedDeviceId)) {
                this.table.setSelection(tableItem);
            }
            ++i;
        }
        if (this.table.getSelectionIndex() < 0) {
            this.buttonEdit.setEnabled(false);
            this.buttonRemove.setEnabled(false);
        }
        this.useSkinsCheckbox.setSelection(this.useSkins);
        this.liveReloadCheckBox.setSelection(this.enableLiveReload);
        this.enableLiveReloadPort(this.enableLiveReload);
        this.touchEventsCheckBox.setSelection(this.enableTouchEvents);
        this.askBeforeTruncateRadio.setSelection(TruncateWindow.PROMPT.equals((Object)this.truncateWindow));
        this.alwaysTruncateRadio.setSelection(TruncateWindow.ALWAYS_TRUNCATE.equals((Object)this.truncateWindow));
        this.neverTruncateRadio.setSelection(TruncateWindow.NEVER_TRUNCATE.equals((Object)this.truncateWindow));
        if (!BrowserSimArgs.standalone) {
            this.javaFXBrowserRadio.setSelection(this.isJavaFx);
            this.swtBrowserRadio.setSelection(!this.isJavaFx);
        }
    }

    private void performOK() {
        if (this.isJavaFx != this.oldSpecificPreferences.isJavaFx()) {
            int result = this.showEngineSwitchConfirmationDialog();
            if (result == 32) {
                this.restart();
            }
        } else {
            this.newCommonPreferences = new CommonPreferences(this.devices, this.truncateWindow, this.screenshotsPath.getText(), this.weinreScriptUrlText.getText(), this.weinreClientUrlText.getText());
            this.newSpecificPreferences = this.create(this.checkedDeviceId, this.useSkins, this.enableLiveReload, this.getLiveReloadPort(), this.touchEventsCheckBox.getSelection(), this.isJavaFx);
            this.shell.close();
        }
    }

    private void performCancel() {
        this.newCommonPreferences = null;
        this.newSpecificPreferences = null;
        this.shell.close();
    }

    protected void loadDefaultPreferences() {
        CommonPreferences cp = CommonPreferencesStorage.INSTANCE.loadDefault();
        SpecificPreferences sp = this.getSpecificPreferencesStorage().loadDefault();
        this.devices = cp.getDevices();
        this.checkedDeviceId = sp.getSelectedDeviceId();
        this.selectedDeviceId = sp.getSelectedDeviceId();
        this.useSkins = sp.getUseSkins();
        this.enableLiveReload = sp.isEnableLiveReload();
        this.liveReloadPortText.setText(Integer.toString(sp.getLiveReloadPort()));
        this.enableTouchEvents = sp.isEnableTouchEvents();
        this.truncateWindow = cp.getTruncateWindow();
        this.isJavaFx = sp.isJavaFx();
        this.screenshotsPath.setText(cp.getScreenshotsFolder());
        this.weinreScriptUrlText.setText(cp.getWeinreScriptUrl());
        this.weinreClientUrlText.setText(cp.getWeinreClientUrl());
        this.updateDevices();
    }

    private void enableLiveReloadPort(boolean enableLiveReload) {
        this.liveReloadPortLabel.setEnabled(enableLiveReload);
        this.liveReloadPortText.setEnabled(enableLiveReload);
    }

    private int getLiveReloadPort() {
        String port = this.liveReloadPortText.getText();
        return port.isEmpty() ? 35729 : Integer.parseInt(port);
    }

    private int showEngineSwitchConfirmationDialog() {
        MessageBox dialog = new MessageBox(this.shell, 292);
        dialog.setText("Change web engine");
        dialog.setMessage("Changing browser engine requires restart. Do you want to restart BrowserSim now?");
        return dialog.open();
    }

    protected SpecificPreferencesStorage getSpecificPreferencesStorage() {
        return BrowserSimSpecificPreferencesStorage.INSTANCE;
    }

    protected SpecificPreferences create(String selectedDeviceId, boolean useSkins, boolean enableLiveReload, int liveReloadPort, boolean enableTouchEvents, boolean isJavaFx) {
        return new BrowserSimSpecificPreferences(selectedDeviceId, useSkins, enableLiveReload, liveReloadPort, enableTouchEvents, this.oldSpecificPreferences.getOrientationAngle(), this.getParent().getLocation(), isJavaFx);
    }

    protected void sendRestartCommand() {
        System.out.println(BROWSERSIM_RESTART_COMMAND + this.currentUrl);
    }
}

