/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.ui;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javafx.application.Platform;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.browser.ExtendedOpenWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedWindowEvent;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.IBrowserFunction;
import org.jboss.tools.vpe.browsersim.browser.IBrowserSimBrowserFactory;
import org.jboss.tools.vpe.browsersim.browser.IDisposable;
import org.jboss.tools.vpe.browsersim.browser.WebKitBrowserFactory;
import org.jboss.tools.vpe.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.vpe.browsersim.devtools.DevToolsDebuggerServer;
import org.jboss.tools.vpe.browsersim.js.log.JsLogFunction;
import org.jboss.tools.vpe.browsersim.js.log.MessageType;
import org.jboss.tools.vpe.browsersim.model.Device;
import org.jboss.tools.vpe.browsersim.model.preferences.BrowserSimSpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.model.preferences.CommonPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.CommonPreferencesStorage;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.scripting.TouchSupportLoader;
import org.jboss.tools.vpe.browsersim.scripting.WebSqlLoader;
import org.jboss.tools.vpe.browsersim.ui.BrowserSimControlHandler;
import org.jboss.tools.vpe.browsersim.ui.ControlHandler;
import org.jboss.tools.vpe.browsersim.ui.Messages;
import org.jboss.tools.vpe.browsersim.ui.debug.firebug.FireBugLiteLoader;
import org.jboss.tools.vpe.browsersim.ui.events.ExitListener;
import org.jboss.tools.vpe.browsersim.ui.events.SkinChangeEvent;
import org.jboss.tools.vpe.browsersim.ui.events.SkinChangeListener;
import org.jboss.tools.vpe.browsersim.ui.menu.BrowserSimMenuCreator;
import org.jboss.tools.vpe.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.vpe.browsersim.ui.skin.ResizableSkinSizeAdvisor;
import org.jboss.tools.vpe.browsersim.ui.skin.ResizableSkinSizeAdvisorImpl;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;
import org.jboss.tools.vpe.browsersim.util.ReflectionUtil;

public class BrowserSim {
    public static final String BROWSERSIM_PLUGIN_ID = "org.jboss.tools.vpe.browsersim";
    private static List<BrowserSim> instances = new ArrayList<BrowserSim>();
    private Shell parentShell;
    private String homeUrl;
    private static CommonPreferences commonPreferences;
    private SpecificPreferences specificPreferences;
    private ResizableSkinSizeAdvisor resizableSkinSizeAdvisor;
    protected BrowserSimSkin skin;
    private ControlHandler controlHandler;
    private Point currentLocation;
    private ProgressListener progressListener;
    private Observer commonPreferencesObserver;
    private LocationAdapter liveReloadLocationAdapter;
    private LocationAdapter touchEventsLocationAdapter;
    private List<SkinChangeListener> skinChangeListenerList = new ArrayList<SkinChangeListener>();
    private List<ExitListener> exitListenerList = new ArrayList<ExitListener>();
    private boolean deviceUpdateRequired = false;

    static {
        if (commonPreferences == null && (commonPreferences = (CommonPreferences)CommonPreferencesStorage.INSTANCE.load(PreferencesUtil.getConfigFolderPath())) == null) {
            commonPreferences = CommonPreferencesStorage.INSTANCE.loadDefault();
        }
    }

    public BrowserSim(String homeUrl, Shell parent) {
        this.homeUrl = homeUrl;
        this.parentShell = parent;
    }

    public void open(boolean isJavaFxAvailable, boolean isWebKitAvailable) {
        SpecificPreferences sp = (SpecificPreferences)this.getSpecificPreferencesStorage().load(PreferencesUtil.getConfigFolderPath());
        if (sp == null) {
            sp = this.getSpecificPreferencesStorage().loadDefault();
        }
        if (BrowserSimArgs.standalone) {
            sp.setJavaFx(false);
        } else {
            if (!isWebKitAvailable && isJavaFxAvailable) {
                sp.setJavaFx(true);
            }
            if (!isJavaFxAvailable) {
                sp.setJavaFx(false);
            }
        }
        this.open(sp, null);
    }

    public void open(SpecificPreferences sp, String url) {
        if (url == null) {
            url = this.homeUrl;
        }
        this.specificPreferences = sp;
        this.enableLivereloadIfAvailable();
        this.initObservers();
        Device defaultDevice = commonPreferences.getDevices().get(this.specificPreferences.getSelectedDeviceId());
        if (defaultDevice == null) {
            String id;
            BrowserSimLogger.logError(Messages.BrowserSim_NO_SELECTED_DEVICE, new NullPointerException());
            try {
                id = commonPreferences.getDevices().keySet().iterator().next();
            }
            catch (NoSuchElementException noSuchElementException) {
                commonPreferences = CommonPreferencesStorage.INSTANCE.loadDefault();
                id = commonPreferences.getDevices().keySet().iterator().next();
            }
            this.specificPreferences.setSelectedDeviceId(id);
            defaultDevice = commonPreferences.getDevices().get(id);
        }
        this.initSkin(BrowserSimUtil.getSkinClass(defaultDevice, this.specificPreferences.getUseSkins()), this.specificPreferences.getLocation(), this.parentShell);
        this.setSelectedDevice(null);
        this.controlHandler.goToAddress(url);
        instances.add(this);
        this.skin.getShell().open();
    }

    private void initSkin(Class<? extends BrowserSimSkin> skinClass, Point location, Shell parentShell) {
        try {
            this.skin = skinClass.newInstance();
        }
        catch (InstantiationException e1) {
            BrowserSimLogger.logError(e1.getMessage(), e1);
        }
        catch (IllegalAccessException e1) {
            BrowserSimLogger.logError(e1.getMessage(), e1);
        }
        this.skin.setBrowserFactory((IBrowserSimBrowserFactory)new WebKitBrowserFactory());
        Display display = Display.getDefault();
        this.skin.createControls(display, location, parentShell, this.specificPreferences.isJavaFx());
        this.skin.setAddressBarVisible(this.isAddressBarVisibleByDefault());
        this.currentLocation = location;
        final Shell shell = this.skin.getShell();
        this.resizableSkinSizeAdvisor = new ResizableSkinSizeAdvisorImpl(commonPreferences, this.specificPreferences, shell);
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                BrowserSim.this.currentLocation = shell.getLocation();
                super.controlMoved(e);
            }
        });
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                instances.remove(BrowserSim.this);
                BrowserSim.this.specificPreferences.setLocation(BrowserSim.this.currentLocation);
                BrowserSim.this.getSpecificPreferencesStorage().save(BrowserSim.this.specificPreferences);
                if (instances.isEmpty()) {
                    CommonPreferencesStorage.INSTANCE.save(commonPreferences);
                }
                commonPreferences.deleteObserver(BrowserSim.this.commonPreferencesObserver);
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                try {
                    if (!BrowserSimArgs.standalone) {
                        ReflectionUtil.call("org.jboss.tools.vpe.browsersim.devtools.DevToolsDebuggerServer", "stopDebugServer");
                    }
                }
                catch (Exception e) {
                    BrowserSimLogger.logError(e.getMessage(), e);
                }
            }
        });
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                for (ExitListener e : BrowserSim.this.exitListenerList) {
                    e.exit();
                }
            }
        });
        final IBrowser browser = this.getBrowser();
        this.controlHandler = this.createControlHandler(browser, this.homeUrl, this.specificPreferences);
        final BrowserSimMenuCreator menuCreator = this.createMenuCreator(this.skin, commonPreferences, this.specificPreferences, this.controlHandler, this.homeUrl);
        shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
                menuCreator.addMenuBar();
            }
        });
        menuCreator.addMenuBar();
        BrowserSimUtil.setShellAttributes(shell);
        this.skin.setControlHandler(this.controlHandler);
        Menu contextMenu = new Menu((Control)shell);
        this.skin.setContextMenu(contextMenu);
        menuCreator.createMenuItemsForContextMenu(contextMenu);
        this.progressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
                int ratio = event.current == event.total || event.total == 0 ? -1 : event.current * 100 / event.total;
                BrowserSim.this.skin.progressChanged(ratio);
            }

            public void completed(ProgressEvent event) {
                BrowserSim.this.skin.progressChanged(-1);
            }
        };
        browser.addProgressListener(this.progressListener);
        browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                BrowserSim.this.skin.statusTextChanged(event.text);
            }
        });
        browser.addLocationListener(this.createNavButtonsListener());
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                BrowserSim.this.initOrientation(BrowserSim.this.specificPreferences.getOrientationAngle());
                WebSqlLoader.initWebSql(BrowserSim.this.skin.getBrowser());
            }
        });
        BrowserSimUtil.setCustomScrollbarStylesForWindows(browser);
        browser.addOpenWindowListener(new ExtendedOpenWindowListener(){

            public void open(ExtendedWindowEvent event) {
                if (FireBugLiteLoader.isFireBugPopUp(event)) {
                    FireBugLiteLoader.processFireBugPopUp(event, BrowserSim.this.skin, BrowserSim.this.specificPreferences.isJavaFx());
                } else {
                    event.browser = browser;
                }
            }
        });
        browser.addLocationListener(new LocationListener(){
            private IDisposable scrollListener = null;

            public void changed(LocationEvent event) {
                if (this.scrollListener != null) {
                    this.scrollListener.dispose();
                }
                this.scrollListener = ((IBrowser)event.widget).registerBrowserFunction("_browserSim_scrollListener", new IBrowserFunction(){

                    public Object function(Object[] arguments) {
                        double pageYOffset = (Double)arguments[0];
                        if (pageYOffset > 0.0) {
                            (this).BrowserSim.this.skin.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (((this).this).BrowserSim.this.skin != null && ((this).this).BrowserSim.this.skin.getShell() != null && !((this).this).BrowserSim.this.skin.getShell().isDisposed() && ((this).this).BrowserSim.this.skin.automaticallyHideAddressBar()) {
                                        ((this).this).BrowserSim.this.skin.setAddressBarVisible(false);
                                    }
                                }
                            });
                        }
                        return null;
                    }
                });
                IBrowser browser = (IBrowser)event.widget;
                browser.execute("(function() {var scrollListener = function(e){window._browserSim_scrollListener(window.pageYOffset)};window.addEventListener('scroll', scrollListener);window.addEventListener('beforeunload', function(e){window.removeEventListener('scroll', scrollListener);delete window._browserSim_scrollListener;})})();");
            }

            public void changing(LocationEvent event) {
                if (BrowserSim.this.skin.automaticallyHideAddressBar() && BrowserSim.this.isAddressBarVisibleByDefault()) {
                    BrowserSim.this.skin.setAddressBarVisible(true);
                }
            }
        });
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (BrowserSim.this.getBrowser().equals(Display.getDefault().getFocusControl()) && event.top) {
                    for (BrowserSim bs : instances) {
                        if (bs.skin == BrowserSim.this.skin) continue;
                        bs.skin.getBrowser().setUrl(event.location);
                    }
                }
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                BrowserSim.this.skin.pageTitleChanged(event.title);
            }
        });
        this.overrideJsConsole(browser);
    }

    private void overrideJsConsole(final IBrowser browser) {
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent e) {
                if (browser instanceof JavaFXBrowser && BrowserSimUtil.isJavaFx8Available()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserSim.this.createLogFunctions(browser);
                            BrowserSim.this.overrideJsLogFunctions(browser);
                        }
                    });
                } else {
                    BrowserSim.this.createLogFunctions(browser);
                    BrowserSim.this.overrideJsLogFunctions(browser);
                }
            }
        });
    }

    private void createLogFunctions(IBrowser browser) {
        if (browser != null && !browser.isDisposed()) {
            browser.registerBrowserFunction("browserSimConsoleLog", (IBrowserFunction)new JsLogFunction(browser, MessageType.LOG));
            browser.registerBrowserFunction("browserSimConsoleInfo", (IBrowserFunction)new JsLogFunction(browser, MessageType.INFO));
            browser.registerBrowserFunction("browserSimConsoleWarn", (IBrowserFunction)new JsLogFunction(browser, MessageType.WARN));
            browser.registerBrowserFunction("browserSimConsoleError", (IBrowserFunction)new JsLogFunction(browser, MessageType.ERROR));
        }
    }

    private void overrideJsLogFunctions(IBrowser browser) {
        if (browser != null && !browser.isDisposed()) {
            browser.execute("(function() {if (window.console) {var originalConsole = window.console;console = {log: function(message) {originalConsole.log(message);browserSimConsoleLog(message);},info: function(message) {originalConsole.info(message);browserSimConsoleInfo(message);},warn: function(message) {originalConsole.warn(message);browserSimConsoleWarn(message);},error: function(message) {originalConsole.error(message);browserSimConsoleError(message);},debug: function(message) {console.log(message);}};window.onerror = function(msg, url, lineNumber) {console.error(msg + ' on line ' + lineNumber + ' for ' + url);}}})();");
        }
    }

    private void enableLivereloadIfAvailable() {
        if (this.isLivereloadAvailable()) {
            this.specificPreferences.setEnableLiveReload(true);
        } else {
            this.specificPreferences.setEnableLiveReload(false);
        }
    }

    private void initObservers() {
        this.commonPreferencesObserver = new Observer(){

            @Override
            public void update(Observable o, Object refreshRequired) {
                BrowserSim.this.setSelectedDeviceAsync((Boolean)refreshRequired);
            }
        };
        commonPreferences.addObserver(this.commonPreferencesObserver);
        this.specificPreferences.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object refreshRequired) {
                BrowserSim.this.setSelectedDeviceAsync((Boolean)refreshRequired);
            }
        });
    }

    private void setSelectedDeviceAsync(final Boolean refreshRequired) {
        this.deviceUpdateRequired = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BrowserSim.this.deviceUpdateRequired) {
                    BrowserSim.this.setSelectedDevice(refreshRequired);
                    BrowserSim.this.deviceUpdateRequired = false;
                }
            }
        });
    }

    protected void setSelectedDevice(Boolean refreshRequired) {
        final Device device = commonPreferences.getDevices().get(this.specificPreferences.getSelectedDeviceId());
        if (device == null) {
            this.skin.getShell().close();
        } else {
            boolean needToChangeEngine;
            final Class<? extends BrowserSimSkin> newSkinClass = BrowserSimUtil.getSkinClass(device, this.specificPreferences.getUseSkins());
            boolean needToChangeSkin = newSkinClass != this.skin.getClass();
            boolean bl = needToChangeEngine = this.skin.getBrowser() instanceof JavaFXBrowser && !this.specificPreferences.isJavaFx() || !(this.skin.getBrowser() instanceof JavaFXBrowser) && this.specificPreferences.isJavaFx();
            if (needToChangeSkin || needToChangeEngine) {
                final String oldSkinUrl = this.skin.getBrowser().getUrl();
                final Point currentLocation = this.skin.getShell().getLocation();
                this.skin.getBrowser().removeProgressListener(this.progressListener);
                this.skin.getBrowser().getShell().dispose();
                if (this.specificPreferences.isJavaFx()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserSim.this.changeSkinOrEngine(newSkinClass, device, currentLocation, oldSkinUrl);
                        }
                    });
                } else {
                    this.changeSkinOrEngine(newSkinClass, device, currentLocation, oldSkinUrl);
                }
            } else {
                this.setOrientation(this.specificPreferences.getOrientationAngle(), device);
                this.skin.getBrowser().setUserAgent(device.getUserAgent());
                this.processLiveReload(this.specificPreferences.isEnableLiveReload());
                this.processTouchEvents(this.specificPreferences.isEnableTouchEvents());
                if (!Boolean.FALSE.equals(refreshRequired)) {
                    this.getBrowser().refresh();
                }
                this.skin.getShell().open();
            }
        }
    }

    private void changeSkinOrEngine(Class<? extends BrowserSimSkin> newSkinClass, Device device, Point currentLocation, String oldSkinUrl) {
        this.initSkin(newSkinClass, currentLocation, this.parentShell);
        this.fireSkinChangeEvent();
        if (this.skin.getBrowser() instanceof JavaFXBrowser && !"STARTED".equals(DevToolsDebuggerServer.getServerState())) {
            try {
                DevToolsDebuggerServer.startDebugServer(((JavaFXBrowser)this.skin.getBrowser()).getDebugger());
            }
            catch (Exception e) {
                BrowserSimLogger.logError(e.getMessage(), e);
            }
        }
        this.setOrientation(this.specificPreferences.getOrientationAngle(), device);
        this.skin.getBrowser().setUserAgent(device.getUserAgent());
        this.processLiveReload(this.specificPreferences.isEnableLiveReload());
        this.processTouchEvents(this.specificPreferences.isEnableTouchEvents());
        if (oldSkinUrl != null && this.isUrlResettingNeededAfterSkinChange()) {
            this.skin.getBrowser().setUrl(oldSkinUrl);
        }
        this.skin.getShell().open();
    }

    protected boolean isUrlResettingNeededAfterSkinChange() {
        return true;
    }

    public void reinitSkin() {
        Device device = commonPreferences.getDevices().get(this.specificPreferences.getSelectedDeviceId());
        Class<? extends BrowserSimSkin> newSkinClass = BrowserSimUtil.getSkinClass(device, this.specificPreferences.getUseSkins());
        String oldSkinUrl = this.skin.getBrowser().getUrl();
        Point currentLocation = this.skin.getShell().getLocation();
        this.skin.getBrowser().removeProgressListener(this.progressListener);
        this.skin.getBrowser().getShell().dispose();
        this.initSkin(newSkinClass, currentLocation, this.parentShell);
        this.setOrientation(this.specificPreferences.getOrientationAngle(), device);
        this.skin.getBrowser().setUserAgent(device.getUserAgent());
        this.skin.getBrowser().setUrl(oldSkinUrl);
        this.skin.getShell().open();
        this.processLiveReload(this.specificPreferences.isEnableLiveReload());
    }

    private void processLiveReload(boolean isLiveReloadEnabled) {
        if (isLiveReloadEnabled) {
            if (this.specificPreferences.isJavaFx() && BrowserSimUtil.isJavaFx7Available()) {
                this.showLivereloadError(Messages.ManageDevicesDialog_LIVE_RELOAD_UNAVAILABLE);
                this.specificPreferences.setEnableLiveReload(false);
            } else if (this.isLivereloadAvailable()) {
                if (this.liveReloadLocationAdapter == null) {
                    this.initLiveReloadLocationAdapter();
                }
                this.skin.getBrowser().addLocationListener((LocationListener)this.liveReloadLocationAdapter);
            } else {
                this.showLivereloadError(Messages.BrowserSim_LIVERELOAD_WARNING);
                this.specificPreferences.setEnableLiveReload(false);
            }
        } else if (this.liveReloadLocationAdapter != null) {
            this.skin.getBrowser().removeLocationListener((LocationListener)this.liveReloadLocationAdapter);
        }
    }

    private void processTouchEvents(boolean isTouchEventsEnabled) {
        if (isTouchEventsEnabled) {
            if (this.touchEventsLocationAdapter == null) {
                this.initTouchEventsLocationAdapter();
            }
            this.skin.getBrowser().addLocationListener((LocationListener)this.touchEventsLocationAdapter);
        } else if (this.touchEventsLocationAdapter != null) {
            this.skin.getBrowser().removeLocationListener((LocationListener)this.touchEventsLocationAdapter);
        }
    }

    private void initLiveReloadLocationAdapter() {
        this.liveReloadLocationAdapter = new LocationAdapter(){

            public void changed(final LocationEvent event) {
                if (BrowserSim.this.isLivereloadAvailable()) {
                    if (BrowserSim.this.specificPreferences.isJavaFx()) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                BrowserSim.this.processLiveReloadEvent(event);
                            }
                        });
                    } else {
                        BrowserSim.this.processLiveReloadEvent(event);
                    }
                } else {
                    BrowserSim.this.showLivereloadError(Messages.BrowserSim_LIVERELOAD_WARNING);
                    BrowserSim.this.skin.getBrowser().removeLocationListener((LocationListener)BrowserSim.this.liveReloadLocationAdapter);
                    BrowserSim.this.specificPreferences.setEnableLiveReload(false);
                }
            }
        };
    }

    private boolean isLivereloadAvailable() {
        try {
            HttpURLConnection.setFollowRedirects(false);
            URL url = new URL("http://localhost:" + this.specificPreferences.getLiveReloadPort() + "/livereload.js");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(1000);
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void showLivereloadError(String message) {
        MessageBox warning = new MessageBox(this.skin.getShell(), 8);
        warning.setText(Messages.WARNING);
        warning.setMessage(message);
        warning.open();
    }

    private void processLiveReloadEvent(LocationEvent event) {
        IBrowser browser = (IBrowser)event.widget;
        browser.execute("if (!window.LiveReload) {window.addEventListener('load', function(){var e = document.createElement('script');e.type = 'text/javascript';e.async = 'true';e.src = 'http://localhost:" + this.specificPreferences.getLiveReloadPort() + "/livereload.js';" + "document.head.appendChild(e);" + "});" + "}");
    }

    private void initTouchEventsLocationAdapter() {
        this.touchEventsLocationAdapter = new LocationAdapter(){

            public void changed(final LocationEvent event) {
                if (BrowserSim.this.specificPreferences.isJavaFx()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TouchSupportLoader.initTouchEvents((IBrowser)event.widget);
                        }
                    });
                } else {
                    TouchSupportLoader.initTouchEvents((IBrowser)event.widget);
                }
            }
        };
    }

    private void initOrientation(int orientation) {
        this.getBrowser().execute("window.onorientationchange = null;window.orientation = " + orientation + ";");
    }

    private void setOrientation(int orientationAngle, Device device) {
        Point size = BrowserSimUtil.getSizeInDesktopPixels(device);
        Point browserSize = orientationAngle == 90 || orientationAngle == -90 ? new Point(size.y, size.x) : size;
        this.skin.setOrientationAndLocationAndSize(orientationAngle, this.currentLocation, browserSize, this.resizableSkinSizeAdvisor);
        this.getBrowser().execute("window.orientation = " + orientationAngle + ";" + "(function(){" + "var event = document.createEvent('Event');" + "event.initEvent('orientationchange', false, false);" + "window.dispatchEvent(event);" + "if (typeof window.onorientationchange === 'function') {" + "window.onorientationchange(event);" + "}" + "})();");
    }

    public IBrowser getBrowser() {
        return this.skin != null ? this.skin.getBrowser() : null;
    }

    public void addSkinChangeListener(SkinChangeListener listener) {
        this.skinChangeListenerList.add(listener);
    }

    public void addExitListener(ExitListener listener) {
        this.exitListenerList.add(listener);
    }

    public void fireSkinChangeEvent() {
        SkinChangeEvent event = new SkinChangeEvent(this, this.skin);
        for (SkinChangeListener listener : this.skinChangeListenerList) {
            listener.skinChanged(event);
        }
    }

    public Device getCurrentDevice() {
        return commonPreferences.getDevices().get(this.specificPreferences.getSelectedDeviceId());
    }

    public static List<BrowserSim> getInstances() {
        return instances;
    }

    protected boolean isAddressBarVisibleByDefault() {
        return true;
    }

    protected ControlHandler createControlHandler(IBrowser browser, String homeUrl, SpecificPreferences specificPreferences) {
        return new BrowserSimControlHandler(browser, homeUrl, specificPreferences);
    }

    protected BrowserSimMenuCreator createMenuCreator(BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences, ControlHandler controlHandler, String homeUrl) {
        return new BrowserSimMenuCreator(skin, commonPreferences, specificPreferences, controlHandler, homeUrl);
    }

    protected SpecificPreferencesStorage getSpecificPreferencesStorage() {
        return BrowserSimSpecificPreferencesStorage.INSTANCE;
    }

    public SpecificPreferences getSpecificPreferences() {
        return this.specificPreferences;
    }

    protected LocationListener createNavButtonsListener() {
        return new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (event.top) {
                    IBrowser browser = (IBrowser)event.widget;
                    BrowserSim.this.skin.locationChanged(event.location, browser.isBackEnabled(), browser.isForwardEnabled());
                }
            }
        };
    }
}

